/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BaseViewStmt;
import org.apache.doris.analysis.ColWithComment;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.SessionVariable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreateViewStmt
extends BaseViewStmt {
    private static final Logger LOG = LogManager.getLogger(CreateViewStmt.class);
    private final boolean ifNotExists;
    private final String comment;

    public CreateViewStmt(boolean ifNotExists, TableName tableName, List<ColWithComment> cols, String comment, QueryStmt queryStmt) {
        super(tableName, cols, queryStmt);
        this.ifNotExists = ifNotExists;
        this.comment = Strings.nullToEmpty((String)comment);
    }

    public boolean isSetIfNotExists() {
        return this.ifNotExists;
    }

    public String getComment() {
        return this.comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        SessionVariable sv;
        this.tableName.analyze(analyzer);
        this.viewDefStmt.setNeedToSql(true);
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.tableName.getDb(), this.tableName.getTbl(), PrivPredicate.CREATE)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "CREATE");
        }
        boolean originEnableVec = true;
        if (ConnectContext.get() != null) {
            ConnectContext.get().setNotEvalNondeterministicFunction(true);
            sv = ConnectContext.get().getSessionVariable();
            originEnableVec = sv.enableVectorizedEngine;
            sv.setEnableVectorizedEngine(false);
        }
        try {
            if (this.cols != null) {
                this.cloneStmt = this.viewDefStmt.clone();
            }
            Analyzer viewAnalyzer = new Analyzer(analyzer);
            this.viewDefStmt.analyze(viewAnalyzer);
            this.createColumnAndViewDefs(analyzer);
        }
        finally {
            if (ConnectContext.get() != null) {
                ConnectContext.get().setNotEvalNondeterministicFunction(false);
                sv = ConnectContext.get().getSessionVariable();
                sv.setEnableVectorizedEngine(originEnableVec);
            }
        }
    }
}

