/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.UserDesc;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.MysqlPassword;
import org.apache.doris.mysql.privilege.PaloAuth;
import org.apache.doris.mysql.privilege.PaloRole;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreateUserStmt
extends DdlStmt {
    private static final Logger LOG = LogManager.getLogger(CreateUserStmt.class);
    private boolean ifNotExist;
    private UserIdentity userIdent;
    private String password;
    private byte[] scramblePassword;
    private boolean isPlain;
    private String role;

    public CreateUserStmt() {
    }

    public CreateUserStmt(UserDesc userDesc) {
        this.userIdent = userDesc.getUserIdent();
        this.password = userDesc.getPassword();
        this.isPlain = userDesc.isPlain();
    }

    public CreateUserStmt(boolean ifNotExist, UserDesc userDesc, String role) {
        this.ifNotExist = ifNotExist;
        this.userIdent = userDesc.getUserIdent();
        this.password = userDesc.getPassword();
        this.isPlain = userDesc.isPlain();
        this.role = role;
    }

    public boolean isIfNotExist() {
        return this.ifNotExist;
    }

    public boolean isSuperuser() {
        return this.role.equalsIgnoreCase(PaloRole.ADMIN_ROLE);
    }

    public boolean hasRole() {
        return this.role != null;
    }

    public String getQualifiedRole() {
        return this.role;
    }

    public byte[] getPassword() {
        return this.scramblePassword;
    }

    public UserIdentity getUserIdent() {
        return this.userIdent;
    }

    @Override
    public boolean needAuditEncryption() {
        return true;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        this.userIdent.analyze(analyzer.getClusterName());
        if (this.userIdent.isRootUser()) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_COMMON_ERROR, "Can not create root user");
        }
        this.scramblePassword = !Strings.isNullOrEmpty((String)this.password) ? (this.isPlain ? MysqlPassword.makeScrambledPassword(this.password) : MysqlPassword.checkPassword(this.password)) : new byte[0];
        if (this.role != null) {
            if (this.role.equalsIgnoreCase("SUPERUSER")) {
                this.role = PaloRole.ADMIN_ROLE;
            }
            FeNameFormat.checkRoleName(this.role, true, "Can not granted user to role");
            this.role = ClusterNamespace.getFullName(analyzer.getClusterName(), this.role);
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkHasPriv(ConnectContext.get(), PrivPredicate.GRANT, PaloAuth.PrivLevel.GLOBAL, PaloAuth.PrivLevel.DATABASE)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "GRANT");
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE USER ").append(this.userIdent);
        if (!Strings.isNullOrEmpty((String)this.password)) {
            if (this.isPlain) {
                sb.append(" IDENTIFIED BY '").append("*XXX").append("'");
            } else {
                sb.append(" IDENTIFIED BY PASSWORD '").append(this.password).append("'");
            }
        }
        if (!Strings.isNullOrEmpty((String)this.role)) {
            sb.append(" DEFAULT ROLE '").append(this.role).append("'");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

