/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.doris.analysis.AlterClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ColumnDef;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.DistributionDesc;
import org.apache.doris.analysis.IndexDef;
import org.apache.doris.analysis.KeysDesc;
import org.apache.doris.analysis.ListPartitionDesc;
import org.apache.doris.analysis.PartitionDesc;
import org.apache.doris.analysis.RangePartitionDesc;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.ArrayType;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.DistributionInfo;
import org.apache.doris.catalog.Index;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.external.elasticsearch.EsUtil;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreateTableStmt
extends DdlStmt {
    private static final Logger LOG = LogManager.getLogger(CreateTableStmt.class);
    private static final String DEFAULT_ENGINE_NAME = "olap";
    private boolean ifNotExists;
    private boolean isExternal;
    private TableName tableName;
    private List<ColumnDef> columnDefs;
    private List<IndexDef> indexDefs;
    private KeysDesc keysDesc;
    private PartitionDesc partitionDesc;
    private DistributionDesc distributionDesc;
    private Map<String, String> properties;
    private Map<String, String> extProperties;
    private String engineName;
    private String comment;
    private List<AlterClause> rollupAlterClauseList;
    private static Set<String> engineNames = Sets.newHashSet();
    private List<Column> columns = Lists.newArrayList();
    private List<Index> indexes = Lists.newArrayList();

    public CreateTableStmt() {
        this.tableName = new TableName();
        this.columnDefs = Lists.newArrayList();
    }

    public CreateTableStmt(boolean ifNotExists, boolean isExternal, TableName tableName, List<ColumnDef> columnDefinitions, String engineName, KeysDesc keysDesc, PartitionDesc partitionDesc, DistributionDesc distributionDesc, Map<String, String> properties, Map<String, String> extProperties, String comment) {
        this(ifNotExists, isExternal, tableName, columnDefinitions, null, engineName, keysDesc, partitionDesc, distributionDesc, properties, extProperties, comment, null);
    }

    public CreateTableStmt(boolean ifNotExists, boolean isExternal, TableName tableName, List<ColumnDef> columnDefinitions, String engineName, KeysDesc keysDesc, PartitionDesc partitionDesc, DistributionDesc distributionDesc, Map<String, String> properties, Map<String, String> extProperties, String comment, List<AlterClause> ops) {
        this(ifNotExists, isExternal, tableName, columnDefinitions, null, engineName, keysDesc, partitionDesc, distributionDesc, properties, extProperties, comment, ops);
    }

    public CreateTableStmt(boolean ifNotExists, boolean isExternal, TableName tableName, List<ColumnDef> columnDefinitions, List<IndexDef> indexDefs, String engineName, KeysDesc keysDesc, PartitionDesc partitionDesc, DistributionDesc distributionDesc, Map<String, String> properties, Map<String, String> extProperties, String comment, List<AlterClause> rollupAlterClauseList) {
        this.tableName = tableName;
        this.columnDefs = columnDefinitions == null ? Lists.newArrayList() : columnDefinitions;
        this.indexDefs = indexDefs;
        this.engineName = Strings.isNullOrEmpty((String)engineName) ? DEFAULT_ENGINE_NAME : engineName;
        this.keysDesc = keysDesc;
        this.partitionDesc = partitionDesc;
        this.distributionDesc = distributionDesc;
        this.properties = properties;
        this.extProperties = extProperties;
        this.isExternal = isExternal;
        this.ifNotExists = ifNotExists;
        this.comment = Strings.nullToEmpty((String)comment);
        this.rollupAlterClauseList = rollupAlterClauseList == null ? new ArrayList() : rollupAlterClauseList;
    }

    public CreateTableStmt(boolean ifNotExists, boolean isExternal, TableName tableName, String engineName, Map<String, String> properties, String comment) {
        this.ifNotExists = ifNotExists;
        this.isExternal = isExternal;
        this.tableName = tableName;
        this.engineName = engineName;
        this.properties = properties;
        this.columnDefs = Lists.newArrayList();
        this.comment = Strings.nullToEmpty((String)comment);
    }

    public void addColumnDef(ColumnDef columnDef) {
        this.columnDefs.add(columnDef);
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public boolean isSetIfNotExists() {
        return this.ifNotExists;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public TableName getDbTbl() {
        return this.tableName;
    }

    public String getTableName() {
        return this.tableName.getTbl();
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public KeysDesc getKeysDesc() {
        return this.keysDesc;
    }

    public PartitionDesc getPartitionDesc() {
        return this.partitionDesc;
    }

    public DistributionDesc getDistributionDesc() {
        return this.distributionDesc;
    }

    public void setDistributionDesc(DistributionDesc desc) {
        this.distributionDesc = desc;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getExtProperties() {
        return this.extProperties;
    }

    public String getEngineName() {
        return this.engineName;
    }

    public String getDbName() {
        return this.tableName.getDb();
    }

    public void setTableName(String newTableName) {
        this.tableName = new TableName(this.tableName.getDb(), newTableName);
    }

    public String getComment() {
        return this.comment;
    }

    public List<AlterClause> getRollupAlterClauseList() {
        return this.rollupAlterClauseList;
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        this.tableName.analyze(analyzer);
        FeNameFormat.checkTableName(this.tableName.getTbl());
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.tableName.getDb(), this.tableName.getTbl(), PrivPredicate.CREATE)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "CREATE");
        }
        this.analyzeEngineName();
        if (this.engineName.equals("hive") && !Config.enable_spark_load) {
            throw new AnalysisException("Spark Load from hive table is coming soon");
        }
        if (this.engineName.equalsIgnoreCase(DEFAULT_ENGINE_NAME)) {
            if (this.keysDesc == null) {
                ArrayList keysColumnNames = Lists.newArrayList();
                int keyLength = 0;
                boolean hasAggregate = false;
                for (ColumnDef columnDef : this.columnDefs) {
                    if (columnDef.getAggregateType() == null) continue;
                    hasAggregate = true;
                    break;
                }
                if (hasAggregate) {
                    for (ColumnDef columnDef : this.columnDefs) {
                        if (columnDef.getAggregateType() != null || columnDef.getType().isScalarType(PrimitiveType.STRING)) continue;
                        keysColumnNames.add(columnDef.getName());
                    }
                    this.keysDesc = new KeysDesc(KeysType.AGG_KEYS, keysColumnNames);
                } else {
                    for (ColumnDef columnDef : this.columnDefs) {
                        if (keysColumnNames.size() >= FeConstants.shortkey_max_column_count || (keyLength += columnDef.getType().getIndexSize()) > FeConstants.shortkey_maxsize_bytes) {
                            if (keysColumnNames.size() != 0 || !columnDef.getType().getPrimitiveType().isCharFamily()) break;
                            keysColumnNames.add(columnDef.getName());
                            break;
                        }
                        if (columnDef.getType().isFloatingPointType() || columnDef.getType().getPrimitiveType() == PrimitiveType.STRING) break;
                        if (columnDef.getType().getPrimitiveType() == PrimitiveType.VARCHAR) {
                            keysColumnNames.add(columnDef.getName());
                            break;
                        }
                        keysColumnNames.add(columnDef.getName());
                    }
                    if (keysColumnNames.isEmpty()) {
                        throw new AnalysisException("The olap table first column could not be float, double, string use decimal or varchar instead.");
                    }
                    this.keysDesc = new KeysDesc(KeysType.DUP_KEYS, keysColumnNames);
                }
            }
            this.keysDesc.analyze(this.columnDefs);
            for (int i = 0; i < this.keysDesc.keysColumnSize(); ++i) {
                this.columnDefs.get(i).setIsKey(true);
            }
            if (this.keysDesc.getKeysType() != KeysType.AGG_KEYS) {
                AggregateType type = AggregateType.REPLACE;
                if (this.keysDesc.getKeysType() == KeysType.DUP_KEYS) {
                    type = AggregateType.NONE;
                }
                for (int i = this.keysDesc.keysColumnSize(); i < this.columnDefs.size(); ++i) {
                    this.columnDefs.get(i).setAggregateType(type);
                }
            }
        } else {
            if (this.keysDesc != null) {
                throw new AnalysisException("Create " + this.engineName + " table should not contain keys desc");
            }
            for (ColumnDef columnDef : this.columnDefs) {
                columnDef.setIsKey(true);
            }
        }
        if (!this.engineName.equals("iceberg") && (this.columnDefs == null || this.columnDefs.isEmpty())) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLE_MUST_HAVE_COLUMNS, new Object[0]);
        }
        if (Config.enable_batch_delete_by_default && this.keysDesc != null && this.keysDesc.getKeysType() == KeysType.UNIQUE_KEYS) {
            this.columnDefs.add(ColumnDef.newDeleteSignColumnDef(AggregateType.REPLACE));
        }
        boolean hasHll = false;
        boolean hasBitmap = false;
        TreeSet columnSet = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (ColumnDef columnDef : this.columnDefs) {
            columnDef.analyze(this.engineName.equals(DEFAULT_ENGINE_NAME));
            if (columnDef.getType().isArrayType()) {
                ArrayType tp = (ArrayType)columnDef.getType();
                if (!tp.getItemType().getPrimitiveType().isIntegerType() && !tp.getItemType().getPrimitiveType().isCharFamily()) {
                    throw new AnalysisException("Array column just support INT/VARCHAR sub-type");
                }
                if (columnDef.getAggregateType() != null && columnDef.getAggregateType() != AggregateType.NONE) {
                    throw new AnalysisException("Array column can't support aggregation " + (Object)((Object)columnDef.getAggregateType()));
                }
                if (columnDef.isKey()) {
                    throw new AnalysisException("Array can only be used in the non-key column of the duplicate table at present.");
                }
            }
            if (columnDef.getType().isHllType()) {
                hasHll = true;
            }
            if (columnDef.getAggregateType() == AggregateType.BITMAP_UNION) {
                hasBitmap = columnDef.getType().isBitmapType();
            }
            if (columnSet.add(columnDef.getName())) continue;
            ErrorReport.reportAnalysisException(ErrorCode.ERR_DUP_FIELDNAME, columnDef.getName());
        }
        if (hasHll && this.keysDesc.getKeysType() != KeysType.AGG_KEYS) {
            throw new AnalysisException("HLL must be used in AGG_KEYS");
        }
        if (hasBitmap && this.keysDesc.getKeysType() != KeysType.AGG_KEYS) {
            throw new AnalysisException("BITMAP_UNION must be used in AGG_KEYS");
        }
        if (this.engineName.equals(DEFAULT_ENGINE_NAME)) {
            if (this.partitionDesc != null) {
                if (this.partitionDesc instanceof ListPartitionDesc || this.partitionDesc instanceof RangePartitionDesc) {
                    this.partitionDesc.analyze(this.columnDefs, this.properties);
                } else {
                    throw new AnalysisException("Currently only support range and list partition with engine type olap");
                }
            }
            if (this.distributionDesc == null) {
                throw new AnalysisException("Create olap table should contain distribution desc");
            }
            this.distributionDesc.analyze(columnSet, this.columnDefs);
            if (this.distributionDesc.type == DistributionInfo.DistributionInfoType.RANDOM) {
                if (this.keysDesc.getKeysType() == KeysType.UNIQUE_KEYS) {
                    throw new AnalysisException("Create unique keys table should not contain random distribution desc");
                }
                if (this.keysDesc.getKeysType() == KeysType.AGG_KEYS) {
                    for (ColumnDef columnDef : this.columnDefs) {
                        if (columnDef.getAggregateType() != AggregateType.REPLACE && columnDef.getAggregateType() != AggregateType.REPLACE_IF_NOT_NULL) continue;
                        throw new AnalysisException("Create aggregate keys table with value columns of which aggregate type is " + (Object)((Object)columnDef.getAggregateType()) + " should not contain random distribution desc");
                    }
                }
            }
        } else if (this.engineName.equalsIgnoreCase("elasticsearch")) {
            EsUtil.analyzePartitionAndDistributionDesc(this.partitionDesc, this.distributionDesc);
        } else if (this.partitionDesc != null || this.distributionDesc != null) {
            throw new AnalysisException("Create " + this.engineName + " table should not contain partition or distribution desc");
        }
        for (ColumnDef columnDef : this.columnDefs) {
            Column col = columnDef.toColumn();
            if (this.keysDesc != null && this.keysDesc.getKeysType() == KeysType.UNIQUE_KEYS && !col.isKey()) {
                col.setAggregationTypeImplicit(true);
            }
            this.columns.add(col);
        }
        if (CollectionUtils.isNotEmpty(this.indexDefs)) {
            TreeSet<String> distinct = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            HashSet distinctCol = new HashSet();
            for (IndexDef indexDef : this.indexDefs) {
                indexDef.analyze();
                if (!this.engineName.equalsIgnoreCase(DEFAULT_ENGINE_NAME)) {
                    throw new AnalysisException("index only support in olap engine at current version.");
                }
                for (String indexColName : indexDef.getColumns()) {
                    boolean found = false;
                    for (Column column : this.columns) {
                        if (!column.getName().equalsIgnoreCase(indexColName)) continue;
                        indexDef.checkColumn(column, this.getKeysDesc().getKeysType());
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new AnalysisException("BITMAP column does not exist in table. invalid column: " + indexColName);
                }
                this.indexes.add(new Index(indexDef.getIndexName(), indexDef.getColumns(), indexDef.getIndexType(), indexDef.getComment()));
                distinct.add(indexDef.getIndexName());
                distinctCol.add(indexDef.getColumns().stream().map(String::toUpperCase).collect(Collectors.toList()));
            }
            if (distinct.size() != this.indexes.size()) {
                throw new AnalysisException("index name must be unique.");
            }
            if (distinctCol.size() != this.indexes.size()) {
                throw new AnalysisException("same index columns have multiple index name is not allowed.");
            }
        }
    }

    private void analyzeEngineName() throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.engineName)) {
            this.engineName = DEFAULT_ENGINE_NAME;
        }
        this.engineName = this.engineName.toLowerCase();
        if (!engineNames.contains(this.engineName)) {
            throw new AnalysisException("Unknown engine name: " + this.engineName);
        }
        if (this.engineName.equals("mysql") || this.engineName.equals("odbc") || this.engineName.equals("broker") || this.engineName.equals("elasticsearch") || this.engineName.equals("hive") || this.engineName.equals("iceberg")) {
            if (!this.isExternal) {
                this.isExternal = true;
                LOG.warn("create " + this.engineName + " table without keyword external");
            }
        } else if (this.isExternal) {
            throw new AnalysisException("Do not support external table with engine name = olap");
        }
    }

    public static CreateTableStmt read(DataInput in) throws IOException {
        throw new RuntimeException("CreateTableStmt serialization is not supported anymore.");
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE ");
        if (this.isExternal) {
            sb.append("EXTERNAL ");
        }
        sb.append("TABLE ");
        sb.append(this.tableName.toSql()).append(" (\n");
        int idx = 0;
        for (ColumnDef columnDef : this.columnDefs) {
            if (idx != 0) {
                sb.append(",\n");
            }
            sb.append("  ").append(columnDef.toSql());
            ++idx;
        }
        if (CollectionUtils.isNotEmpty(this.indexDefs)) {
            sb.append(",\n");
            for (IndexDef indexDef : this.indexDefs) {
                sb.append("  ").append(indexDef.toSql());
            }
        }
        sb.append("\n)");
        if (this.engineName != null) {
            sb.append(" ENGINE = ").append(this.engineName);
        }
        if (this.keysDesc != null) {
            sb.append("\n").append(this.keysDesc.toSql());
        }
        if (this.partitionDesc != null) {
            sb.append("\n").append(this.partitionDesc.toSql());
        }
        if (this.distributionDesc != null) {
            sb.append("\n").append(this.distributionDesc.toSql());
        }
        if (this.rollupAlterClauseList != null && this.rollupAlterClauseList.size() != 0) {
            sb.append("\n rollup(");
            StringBuilder opsSb = new StringBuilder();
            for (int i = 0; i < this.rollupAlterClauseList.size(); ++i) {
                opsSb.append(this.rollupAlterClauseList.get(i).toSql());
                if (i == this.rollupAlterClauseList.size() - 1) continue;
                opsSb.append(",");
            }
            sb.append(opsSb.toString().replace("ADD ROLLUP", "")).append(")");
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append("\nPROPERTIES (");
            sb.append(new PrintableMap<String, String>(this.properties, " = ", true, true, true));
            sb.append(")");
        }
        if (this.extProperties != null && !this.extProperties.isEmpty()) {
            sb.append("\n").append(this.engineName.toUpperCase()).append(" PROPERTIES (");
            sb.append(new PrintableMap<String, String>(this.extProperties, " = ", true, true, true));
            sb.append(")");
        }
        if (!Strings.isNullOrEmpty((String)this.comment)) {
            sb.append("\nCOMMENT \"").append(this.comment).append("\"");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public boolean needAuditEncryption() {
        return !this.engineName.equals(DEFAULT_ENGINE_NAME);
    }

    static {
        engineNames.add(DEFAULT_ENGINE_NAME);
        engineNames.add("odbc");
        engineNames.add("mysql");
        engineNames.add("broker");
        engineNames.add("elasticsearch");
        engineNames.add("hive");
        engineNames.add("iceberg");
    }
}

