/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreateTableLikeStmt
extends DdlStmt {
    private static final Logger LOG = LogManager.getLogger(CreateTableLikeStmt.class);
    private final boolean ifNotExists;
    private final TableName tableName;
    private final TableName existedTableName;
    private final ArrayList<String> rollupNames;
    private final boolean withAllRollup;

    public CreateTableLikeStmt(boolean ifNotExists, TableName tableName, TableName existedTableName, ArrayList<String> rollupNames, boolean withAllRollup) throws DdlException {
        this.ifNotExists = ifNotExists;
        this.tableName = tableName;
        this.existedTableName = existedTableName;
        if (!CollectionUtils.isEmpty(rollupNames) && withAllRollup) {
            throw new DdlException("Either all or part of the rollup can be copied, not both");
        }
        this.rollupNames = rollupNames;
        this.withAllRollup = withAllRollup;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public String getDbName() {
        return this.tableName.getDb();
    }

    public String getTableName() {
        return this.tableName.getTbl();
    }

    public String getExistedDbName() {
        return this.existedTableName.getDb();
    }

    public String getExistedTableName() {
        return this.existedTableName.getTbl();
    }

    public ArrayList<String> getRollupNames() {
        return this.rollupNames;
    }

    public boolean isWithAllRollup() {
        return this.withAllRollup;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        this.existedTableName.analyze(analyzer);
        ConnectContext ctx = ConnectContext.get();
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ctx, this.existedTableName.getDb(), this.existedTableName.getTbl(), PrivPredicate.SELECT)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "SELECT");
        }
        this.tableName.analyze(analyzer);
        FeNameFormat.checkTableName(this.getTableName());
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ctx, this.tableName.getDb(), this.tableName.getTbl(), PrivPredicate.CREATE)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "CREATE");
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(this.tableName.toSql()).append(" LIKE ").append(this.existedTableName.toSql());
        if (this.withAllRollup && CollectionUtils.isEmpty(this.rollupNames)) {
            sb.append(" WITH ROLLUP");
        }
        if (!this.withAllRollup && !CollectionUtils.isEmpty(this.rollupNames)) {
            sb.append(" WITH ROLLUP (").append(Joiner.on((String)",").join(this.rollupNames)).append(")");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

