/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.CreateTableStmt;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.InsertStmt;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;

public class CreateTableAsSelectStmt
extends DdlStmt {
    private final CreateTableStmt createTableStmt;
    private final List<String> columnNames;
    private QueryStmt queryStmt;
    private final InsertStmt insertStmt;

    protected CreateTableAsSelectStmt(CreateTableStmt createTableStmt, List<String> columnNames, QueryStmt queryStmt) {
        this.createTableStmt = createTableStmt;
        this.columnNames = columnNames;
        this.queryStmt = queryStmt;
        this.insertStmt = new InsertStmt(createTableStmt.getDbTbl(), queryStmt.clone());
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        Analyzer dummyRootAnalyzer = new Analyzer(analyzer.getCatalog(), analyzer.getContext());
        QueryStmt tmpStmt = this.queryStmt.clone();
        tmpStmt.analyze(dummyRootAnalyzer);
        this.queryStmt = tmpStmt;
        List resultExprs = this.getQueryStmt().getResultExprs();
        for (Expr expr : resultExprs) {
            if (!expr.getType().isDecimalV2()) continue;
            ErrorReport.reportAnalysisException(ErrorCode.ERR_UNSUPPORTED_TYPE_IN_CTAS, expr.getType());
        }
        if (this.columnNames != null && this.columnNames.size() != ((ArrayList)resultExprs).size()) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_COL_NUMBER_NOT_MATCH, new Object[0]);
        }
    }

    public CreateTableStmt getCreateTableStmt() {
        return this.createTableStmt;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public QueryStmt getQueryStmt() {
        return this.queryStmt;
    }

    public InsertStmt getInsertStmt() {
        return this.insertStmt;
    }
}

