/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.common.util.SqlBlockUtil;
import org.apache.doris.common.util.Util;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class CreateSqlBlockRuleStmt
extends DdlStmt {
    public static final String SQL_PROPERTY = "sql";
    public static final String SQL_HASH_PROPERTY = "sqlHash";
    public static final String SCANNED_PARTITION_NUM = "partition_num";
    public static final String SCANNED_TABLET_NUM = "tablet_num";
    public static final String SCANNED_CARDINALITY = "cardinality";
    public static final String GLOBAL_PROPERTY = "global";
    public static final String ENABLE_PROPERTY = "enable";
    public static final String STRING_NOT_SET = "NULL";
    private final String ruleName;
    private String sql;
    private String sqlHash;
    private Long partitionNum;
    private Long tabletNum;
    private Long cardinality;
    private boolean global;
    private boolean enable;
    private final Map<String, String> properties;
    private static final String NAME_TYPE = "SQL BLOCK RULE NAME";
    public static final ImmutableSet<String> PROPERTIES_SET = new ImmutableSet.Builder().add((Object)"sql").add((Object)"sqlHash").add((Object)"global").add((Object)"enable").add((Object)"partition_num").add((Object)"tablet_num").add((Object)"cardinality").build();

    public CreateSqlBlockRuleStmt(String ruleName, Map<String, String> properties) {
        this.ruleName = ruleName;
        this.properties = properties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        FeNameFormat.checkCommonName(NAME_TYPE, this.ruleName);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
        CreateSqlBlockRuleStmt.checkCommonProperties(this.properties);
        this.setProperties(this.properties);
    }

    private void setProperties(Map<String, String> properties) throws UserException {
        this.sql = properties.getOrDefault(SQL_PROPERTY, STRING_NOT_SET);
        this.sqlHash = properties.getOrDefault(SQL_HASH_PROPERTY, STRING_NOT_SET);
        String partitionNumString = properties.get(SCANNED_PARTITION_NUM);
        String tabletNumString = properties.get(SCANNED_TABLET_NUM);
        String cardinalityString = properties.get(SCANNED_CARDINALITY);
        SqlBlockUtil.checkSqlAndSqlHashSetBoth(this.sql, this.sqlHash);
        SqlBlockUtil.checkPropertiesValidate(this.sql, this.sqlHash, partitionNumString, tabletNumString, cardinalityString);
        this.partitionNum = Util.getLongPropertyOrDefault(partitionNumString, 0L, null, "partition_num should be a long");
        this.tabletNum = Util.getLongPropertyOrDefault(tabletNumString, 0L, null, "tablet_num should be a long");
        this.cardinality = Util.getLongPropertyOrDefault(cardinalityString, 0L, null, "cardinality should be a long");
        this.global = Util.getBooleanPropertyOrDefault(properties.get(GLOBAL_PROPERTY), false, "global should be a boolean");
        this.enable = Util.getBooleanPropertyOrDefault(properties.get(ENABLE_PROPERTY), true, "enable should be a boolean");
    }

    public static void checkCommonProperties(Map<String, String> properties) throws UserException {
        if (properties == null || properties.isEmpty()) {
            throw new AnalysisException("Not set properties");
        }
        Optional<String> optional = properties.keySet().stream().filter(entity -> !PROPERTIES_SET.contains(entity)).findFirst();
        if (optional.isPresent()) {
            throw new AnalysisException(optional.get() + " is invalid property");
        }
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public String getSql() {
        return this.sql;
    }

    public String getSqlHash() {
        return this.sqlHash;
    }

    public Long getPartitionNum() {
        return this.partitionNum;
    }

    public Long getTabletNum() {
        return this.tabletNum;
    }

    public Long getCardinality() {
        return this.cardinality;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isEnable() {
        return this.enable;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE SQL_BLOCK_RULE ").append(this.ruleName).append(" \nPROPERTIES(\n").append(new PrintableMap<String, String>(this.properties, " = ", true, true, true)).append(")");
        return sb.toString();
    }
}

