/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.ImportColumnsStmt;
import org.apache.doris.analysis.ImportDeleteOnStmt;
import org.apache.doris.analysis.ImportSequenceStmt;
import org.apache.doris.analysis.ImportWhereStmt;
import org.apache.doris.analysis.LabelName;
import org.apache.doris.analysis.ParseNode;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.RoutineLoadDataSourceProperties;
import org.apache.doris.analysis.Separator;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.common.util.Util;
import org.apache.doris.load.RoutineLoadDesc;
import org.apache.doris.load.loadv2.LoadTask;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreateRoutineLoadStmt
extends DdlStmt {
    private static final Logger LOG = LogManager.getLogger(CreateRoutineLoadStmt.class);
    public static final String DESIRED_CONCURRENT_NUMBER_PROPERTY = "desired_concurrent_number";
    public static final String MAX_ERROR_NUMBER_PROPERTY = "max_error_number";
    public static final String MAX_BATCH_INTERVAL_SEC_PROPERTY = "max_batch_interval";
    public static final String MAX_BATCH_ROWS_PROPERTY = "max_batch_rows";
    public static final String MAX_BATCH_SIZE_PROPERTY = "max_batch_size";
    public static final String EXEC_MEM_LIMIT_PROPERTY = "exec_mem_limit";
    public static final String FORMAT = "format";
    public static final String STRIP_OUTER_ARRAY = "strip_outer_array";
    public static final String JSONPATHS = "jsonpaths";
    public static final String JSONROOT = "json_root";
    public static final String NUM_AS_STRING = "num_as_string";
    public static final String FUZZY_PARSE = "fuzzy_parse";
    public static final String KAFKA_BROKER_LIST_PROPERTY = "kafka_broker_list";
    public static final String KAFKA_TOPIC_PROPERTY = "kafka_topic";
    public static final String KAFKA_PARTITIONS_PROPERTY = "kafka_partitions";
    public static final String KAFKA_OFFSETS_PROPERTY = "kafka_offsets";
    public static final String KAFKA_DEFAULT_OFFSETS = "kafka_default_offsets";
    public static final String KAFKA_ORIGIN_DEFAULT_OFFSETS = "kafka_origin_default_offsets";
    private static final String NAME_TYPE = "ROUTINE LOAD NAME";
    public static final String ENDPOINT_REGEX = "[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]";
    public static final String SEND_BATCH_PARALLELISM = "send_batch_parallelism";
    public static final String LOAD_TO_SINGLE_TABLET = "load_to_single_tablet";
    private static final ImmutableSet<String> PROPERTIES_SET = new ImmutableSet.Builder().add((Object)"desired_concurrent_number").add((Object)"max_error_number").add((Object)"max_batch_interval").add((Object)"max_batch_rows").add((Object)"max_batch_size").add((Object)"format").add((Object)"jsonpaths").add((Object)"strip_outer_array").add((Object)"num_as_string").add((Object)"fuzzy_parse").add((Object)"json_root").add((Object)"strict_mode").add((Object)"timezone").add((Object)"exec_mem_limit").add((Object)"send_batch_parallelism").add((Object)"load_to_single_tablet").build();
    private final LabelName labelName;
    private final String tableName;
    private final List<ParseNode> loadPropertyList;
    private final Map<String, String> jobProperties;
    private final String typeName;
    private final RoutineLoadDataSourceProperties dataSourceProperties;
    private String name;
    private String dbName;
    private RoutineLoadDesc routineLoadDesc;
    private int desiredConcurrentNum = 1;
    private long maxErrorNum = -1L;
    private long maxBatchIntervalS = -1L;
    private long maxBatchRows = -1L;
    private long maxBatchSizeBytes = -1L;
    private boolean strictMode = true;
    private long execMemLimit = 0x80000000L;
    private String timezone = "Asia/Shanghai";
    private int sendBatchParallelism = 1;
    private boolean loadToSingleTablet = false;
    private String format = "";
    private String jsonPaths = "";
    private String jsonRoot = "";
    private boolean stripOuterArray = false;
    private boolean numAsString = false;
    private boolean fuzzyParse = false;
    private LoadTask.MergeType mergeType;
    public static final Predicate<Long> DESIRED_CONCURRENT_NUMBER_PRED = v -> v > 0L;
    public static final Predicate<Long> MAX_ERROR_NUMBER_PRED = v -> v >= 0L;
    public static final Predicate<Long> MAX_BATCH_INTERVAL_PRED = v -> v >= 5L && v <= 60L;
    public static final Predicate<Long> MAX_BATCH_ROWS_PRED = v -> v >= 200000L;
    public static final Predicate<Long> MAX_BATCH_SIZE_PRED = v -> v >= 0x6400000L && v <= 0x40000000L;
    public static final Predicate<Long> EXEC_MEM_LIMIT_PRED = v -> v >= 0L;
    public static final Predicate<Long> SEND_BATCH_PARALLELISM_PRED = v -> v > 0L;

    public CreateRoutineLoadStmt(LabelName labelName, String tableName, List<ParseNode> loadPropertyList, Map<String, String> jobProperties, String typeName, Map<String, String> dataSourceProperties, LoadTask.MergeType mergeType) {
        this.labelName = labelName;
        this.tableName = tableName;
        this.loadPropertyList = loadPropertyList;
        this.jobProperties = jobProperties == null ? Maps.newHashMap() : jobProperties;
        this.typeName = typeName.toUpperCase();
        this.dataSourceProperties = new RoutineLoadDataSourceProperties(this.typeName, dataSourceProperties, false);
        this.mergeType = mergeType;
    }

    public String getName() {
        return this.name;
    }

    public String getDBName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public RoutineLoadDesc getRoutineLoadDesc() {
        return this.routineLoadDesc;
    }

    public int getDesiredConcurrentNum() {
        return this.desiredConcurrentNum;
    }

    public long getMaxErrorNum() {
        return this.maxErrorNum;
    }

    public long getMaxBatchIntervalS() {
        return this.maxBatchIntervalS;
    }

    public long getMaxBatchRows() {
        return this.maxBatchRows;
    }

    public long getMaxBatchSize() {
        return this.maxBatchSizeBytes;
    }

    public long getExecMemLimit() {
        return this.execMemLimit;
    }

    public int getSendBatchParallelism() {
        return this.sendBatchParallelism;
    }

    public boolean isLoadToSingleTablet() {
        return this.loadToSingleTablet;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isStripOuterArray() {
        return this.stripOuterArray;
    }

    public boolean isNumAsString() {
        return this.numAsString;
    }

    public boolean isFuzzyParse() {
        return this.fuzzyParse;
    }

    public String getJsonPaths() {
        return this.jsonPaths;
    }

    public String getJsonRoot() {
        return this.jsonRoot;
    }

    public String getKafkaBrokerList() {
        return this.dataSourceProperties.getKafkaBrokerList();
    }

    public String getKafkaTopic() {
        return this.dataSourceProperties.getKafkaTopic();
    }

    public List<Pair<Integer, Long>> getKafkaPartitionOffsets() {
        return this.dataSourceProperties.getKafkaPartitionOffsets();
    }

    public Map<String, String> getCustomKafkaProperties() {
        return this.dataSourceProperties.getCustomKafkaProperties();
    }

    public LoadTask.MergeType getMergeType() {
        return this.mergeType;
    }

    public boolean isOffsetsForTimes() {
        return this.dataSourceProperties.isOffsetsForTimes();
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        this.checkDBTable(analyzer);
        FeNameFormat.checkCommonName(NAME_TYPE, this.name);
        this.checkLoadProperties();
        this.checkJobProperties();
        this.checkDataSourceProperties();
        if (this.routineLoadDesc != null) {
            this.routineLoadDesc.analyze(analyzer);
        } else if (this.mergeType == LoadTask.MergeType.MERGE) {
            throw new AnalysisException("Excepted DELETE ON clause when merge type is MERGE.");
        }
    }

    public void checkDBTable(Analyzer analyzer) throws AnalysisException {
        this.labelName.analyze(analyzer);
        this.dbName = this.labelName.getDbName();
        this.name = this.labelName.getLabelName();
        if (Strings.isNullOrEmpty((String)this.tableName)) {
            throw new AnalysisException("Table name should not be null");
        }
        Database db = Catalog.getCurrentCatalog().getDbOrAnalysisException(this.dbName);
        Table table = db.getTableOrAnalysisException(this.tableName);
        if (this.mergeType != LoadTask.MergeType.APPEND && (table.getType() != Table.TableType.OLAP || ((OlapTable)table).getKeysType() != KeysType.UNIQUE_KEYS)) {
            throw new AnalysisException("load by MERGE or DELETE is only supported in unique tables.");
        }
        if (!(this.mergeType == LoadTask.MergeType.APPEND || table.getType() == Table.TableType.OLAP && ((OlapTable)table).hasDeleteSign())) {
            throw new AnalysisException("load by MERGE or DELETE need to upgrade table to support batch delete.");
        }
    }

    public void checkLoadProperties() throws UserException {
        Separator columnSeparator = null;
        Separator lineDelimiter = null;
        ImportColumnsStmt importColumnsStmt = null;
        ImportWhereStmt precedingImportWhereStmt = null;
        ImportWhereStmt importWhereStmt = null;
        ImportSequenceStmt importSequenceStmt = null;
        PartitionNames partitionNames = null;
        ImportDeleteOnStmt importDeleteOnStmt = null;
        if (this.loadPropertyList != null) {
            for (ParseNode parseNode : this.loadPropertyList) {
                if (parseNode instanceof Separator) {
                    if (columnSeparator != null) {
                        throw new AnalysisException("repeat setting of column separator");
                    }
                    columnSeparator = (Separator)parseNode;
                    columnSeparator.analyze(null);
                    continue;
                }
                if (parseNode instanceof ImportColumnsStmt) {
                    if (importColumnsStmt != null) {
                        throw new AnalysisException("repeat setting of columns info");
                    }
                    importColumnsStmt = (ImportColumnsStmt)parseNode;
                    continue;
                }
                if (parseNode instanceof ImportWhereStmt) {
                    ImportWhereStmt node = (ImportWhereStmt)parseNode;
                    if (node.isPreceding()) {
                        if (precedingImportWhereStmt != null) {
                            throw new AnalysisException("repeat setting of preceding where predicate");
                        }
                        precedingImportWhereStmt = node;
                        continue;
                    }
                    if (importWhereStmt != null) {
                        throw new AnalysisException("repeat setting of where predicate");
                    }
                    importWhereStmt = node;
                    continue;
                }
                if (parseNode instanceof PartitionNames) {
                    if (partitionNames != null) {
                        throw new AnalysisException("repeat setting of partition names");
                    }
                    partitionNames = (PartitionNames)parseNode;
                    partitionNames.analyze(null);
                    continue;
                }
                if (parseNode instanceof ImportDeleteOnStmt) {
                    if (importDeleteOnStmt != null) {
                        throw new AnalysisException("repeat setting of delete predicate");
                    }
                    importDeleteOnStmt = (ImportDeleteOnStmt)parseNode;
                    continue;
                }
                if (!(parseNode instanceof ImportSequenceStmt)) continue;
                if (importSequenceStmt != null) {
                    throw new AnalysisException("repeat setting of sequence column");
                }
                importSequenceStmt = (ImportSequenceStmt)parseNode;
            }
        }
        this.routineLoadDesc = new RoutineLoadDesc(columnSeparator, lineDelimiter, importColumnsStmt, precedingImportWhereStmt, importWhereStmt, partitionNames, importDeleteOnStmt == null ? null : importDeleteOnStmt.getExpr(), this.mergeType, importSequenceStmt == null ? null : importSequenceStmt.getSequenceColName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkJobProperties() throws UserException {
        Optional<String> optional = this.jobProperties.keySet().stream().filter(entity -> !PROPERTIES_SET.contains(entity)).findFirst();
        if (optional.isPresent()) {
            throw new AnalysisException(optional.get() + " is invalid property");
        }
        this.desiredConcurrentNum = Long.valueOf(Util.getLongPropertyOrDefault(this.jobProperties.get(DESIRED_CONCURRENT_NUMBER_PROPERTY), Config.max_routine_load_task_concurrent_num, DESIRED_CONCURRENT_NUMBER_PRED, "desired_concurrent_number should > 0")).intValue();
        this.maxErrorNum = Util.getLongPropertyOrDefault(this.jobProperties.get(MAX_ERROR_NUMBER_PROPERTY), 0L, MAX_ERROR_NUMBER_PRED, "max_error_number should >= 0");
        this.maxBatchIntervalS = Util.getLongPropertyOrDefault(this.jobProperties.get(MAX_BATCH_INTERVAL_SEC_PROPERTY), 10L, MAX_BATCH_INTERVAL_PRED, "max_batch_interval should between 5 and 60");
        this.maxBatchRows = Util.getLongPropertyOrDefault(this.jobProperties.get(MAX_BATCH_ROWS_PROPERTY), 200000L, MAX_BATCH_ROWS_PRED, "max_batch_rows should > 200000");
        this.maxBatchSizeBytes = Util.getLongPropertyOrDefault(this.jobProperties.get(MAX_BATCH_SIZE_PROPERTY), 0x6400000L, MAX_BATCH_SIZE_PRED, "max_batch_size should between 100MB and 1GB");
        this.strictMode = Util.getBooleanPropertyOrDefault(this.jobProperties.get("strict_mode"), false, "strict_mode should be a boolean");
        this.execMemLimit = Util.getLongPropertyOrDefault(this.jobProperties.get(EXEC_MEM_LIMIT_PROPERTY), 0x80000000L, EXEC_MEM_LIMIT_PRED, "exec_mem_limitshould > 0");
        this.sendBatchParallelism = Long.valueOf(Util.getLongPropertyOrDefault(this.jobProperties.get(SEND_BATCH_PARALLELISM), ConnectContext.get().getSessionVariable().getSendBatchParallelism(), SEND_BATCH_PARALLELISM_PRED, "send_batch_parallelism should > 0")).intValue();
        this.loadToSingleTablet = Util.getBooleanPropertyOrDefault(this.jobProperties.get(LOAD_TO_SINGLE_TABLET), false, "load_to_single_tablet should be a boolean");
        if (ConnectContext.get() != null) {
            this.timezone = ConnectContext.get().getSessionVariable().getTimeZone();
        }
        this.timezone = TimeUtils.checkTimeZoneValidAndStandardize(this.jobProperties.getOrDefault("timezone", this.timezone));
        this.format = this.jobProperties.get(FORMAT);
        if (this.format != null) {
            if (this.format.equalsIgnoreCase("csv")) {
                this.format = "";
                return;
            } else {
                if (!this.format.equalsIgnoreCase("json")) throw new UserException("Format type is invalid. format=`" + this.format + "`");
                this.format = "json";
                this.jsonPaths = this.jobProperties.get(JSONPATHS);
                this.jsonRoot = this.jobProperties.get(JSONROOT);
                this.stripOuterArray = Boolean.valueOf(this.jobProperties.getOrDefault(STRIP_OUTER_ARRAY, "false"));
                this.numAsString = Boolean.valueOf(this.jobProperties.getOrDefault(NUM_AS_STRING, "false"));
                this.fuzzyParse = Boolean.valueOf(this.jobProperties.getOrDefault(FUZZY_PARSE, "false"));
            }
            return;
        } else {
            this.format = "csv";
        }
    }

    private void checkDataSourceProperties() throws UserException {
        this.dataSourceProperties.setTimezone(this.timezone);
        this.dataSourceProperties.analyze();
    }
}

