/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class CreateRoleStmt
extends DdlStmt {
    private boolean ifNotExists;
    private String role;

    public CreateRoleStmt(String role) {
        this.role = role;
    }

    public CreateRoleStmt(boolean ifNotExists, String role) {
        this.ifNotExists = ifNotExists;
        this.role = role;
    }

    public boolean isSetIfNotExists() {
        return this.ifNotExists;
    }

    public String getQualifiedRole() {
        return this.role;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        FeNameFormat.checkRoleName(this.role, false, "Can not create role");
        this.role = ClusterNamespace.getFullName(analyzer.getClusterName(), this.role);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.GRANT)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "CREATE USER");
        }
    }

    @Override
    public String toSql() {
        return "CREATE ROLE " + this.role;
    }
}

