/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Resource;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class CreateResourceStmt
extends DdlStmt {
    private static final String TYPE = "type";
    private final boolean isExternal;
    private final String resourceName;
    private final Map<String, String> properties;
    private Resource.ResourceType resourceType;

    public CreateResourceStmt(boolean isExternal, String resourceName, Map<String, String> properties) {
        this.isExternal = isExternal;
        this.resourceName = resourceName;
        this.properties = properties;
        this.resourceType = Resource.ResourceType.UNKNOWN;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Resource.ResourceType getResourceType() {
        return this.resourceType;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
        FeNameFormat.checkResourceName(this.resourceName);
        if (this.properties == null || this.properties.isEmpty()) {
            throw new AnalysisException("Resource properties can't be null");
        }
        String type = this.properties.get(TYPE);
        if (type == null) {
            throw new AnalysisException("Resource type can't be null");
        }
        this.resourceType = Resource.ResourceType.fromString(type);
        if (this.resourceType == Resource.ResourceType.UNKNOWN) {
            throw new AnalysisException("Unsupported resource type: " + type);
        }
        if (this.resourceType == Resource.ResourceType.SPARK && !this.isExternal) {
            throw new AnalysisException("Spark is external resource");
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE ");
        if (this.isExternal) {
            sb.append("EXTERNAL ");
        }
        sb.append("RESOURCE '").append(this.resourceName).append("' ");
        sb.append("PROPERTIES(").append(new PrintableMap<String, String>(this.properties, " = ", true, false)).append(")");
        return sb.toString();
    }
}

