/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class CreateRepositoryStmt
extends DdlStmt {
    private boolean isReadOnly;
    private String name;
    private StorageBackend storage;

    public CreateRepositoryStmt(boolean isReadOnly, String name, StorageBackend storage) {
        this.isReadOnly = isReadOnly;
        this.name = name;
        this.storage = storage;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public String getName() {
        return this.name;
    }

    public String getBrokerName() {
        return this.storage.getStorageName();
    }

    public StorageBackend.StorageType getStorageType() {
        return this.storage.getStorageType();
    }

    public String getLocation() {
        return this.storage.getLocation();
    }

    public Map<String, String> getProperties() {
        return this.storage.getProperties();
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        this.storage.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
        FeNameFormat.checkCommonName("repository", this.name);
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE ");
        if (this.isReadOnly) {
            sb.append("READ_ONLY ");
        }
        sb.append("REPOSITORY `").append(this.name).append("` WITH ").append(this.storage.toSql());
        return sb.toString();
    }
}

