/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.CaseExpr;
import org.apache.doris.analysis.CaseWhenClause;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.IsNullPredicate;
import org.apache.doris.analysis.MVColumnBitmapUnionPattern;
import org.apache.doris.analysis.MVColumnHLLUnionPattern;
import org.apache.doris.analysis.MVColumnItem;
import org.apache.doris.analysis.MVColumnOneChildPattern;
import org.apache.doris.analysis.MVColumnPattern;
import org.apache.doris.analysis.OrderByElement;
import org.apache.doris.analysis.SelectList;
import org.apache.doris.analysis.SelectListItem;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.analysis.TypeDef;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.UserException;

public class CreateMaterializedViewStmt
extends DdlStmt {
    public static final String MATERIALIZED_VIEW_NAME_PREFIX = "mv_";
    public static final Map<String, MVColumnPattern> FN_NAME_TO_PATTERN = Maps.newHashMap();
    private String mvName;
    private SelectStmt selectStmt;
    private Map<String, String> properties;
    private int beginIndexOfAggregation = -1;
    private List<MVColumnItem> mvColumnItemList = Lists.newArrayList();
    private String baseIndexName;
    private String dbName;
    private KeysType mvKeysType = KeysType.DUP_KEYS;
    private boolean isReplay = false;

    public CreateMaterializedViewStmt(String mvName, SelectStmt selectStmt, Map<String, String> properties) {
        this.mvName = mvName;
        this.selectStmt = selectStmt;
        this.properties = properties;
    }

    public void setIsReplay(boolean isReplay) {
        this.isReplay = isReplay;
    }

    public String getMVName() {
        return this.mvName;
    }

    public SelectStmt getSelectStmt() {
        return this.selectStmt;
    }

    public List<MVColumnItem> getMVColumnItemList() {
        return this.mvColumnItemList;
    }

    public String getBaseIndexName() {
        return this.baseIndexName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getDBName() {
        return this.dbName;
    }

    public KeysType getMVKeysType() {
        return this.mvKeysType;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        FeNameFormat.checkTableName(this.mvName);
        this.selectStmt.forbiddenMVRewrite();
        this.selectStmt.analyze(analyzer);
        if (this.selectStmt.getAggInfo() != null) {
            this.mvKeysType = KeysType.AGG_KEYS;
        }
        this.analyzeSelectClause();
        this.analyzeFromClause();
        if (this.selectStmt.getWhereClause() != null) {
            throw new AnalysisException("The where clause is not supported in add materialized view clause, expr:" + this.selectStmt.getWhereClause().toSql());
        }
        if (this.selectStmt.getHavingPred() != null) {
            throw new AnalysisException("The having clause is not supported in add materialized view clause, expr:" + this.selectStmt.getHavingPred().toSql());
        }
        this.analyzeOrderByClause();
        if (this.selectStmt.getLimit() != -1L) {
            throw new AnalysisException("The limit clause is not supported in add materialized view clause, expr: limit " + this.selectStmt.getLimit());
        }
    }

    public void analyzeSelectClause() throws AnalysisException {
        SelectList selectList = this.selectStmt.getSelectList();
        if (selectList.getItems().isEmpty()) {
            throw new AnalysisException("The materialized view must contain at least one column");
        }
        boolean meetAggregate = false;
        HashSet mvColumnNameSet = Sets.newHashSet();
        for (int i = 0; i < selectList.getItems().size(); ++i) {
            SelectListItem selectListItem = selectList.getItems().get(i);
            Expr selectListItemExpr = selectListItem.getExpr();
            if (!(selectListItemExpr instanceof SlotRef) && !(selectListItemExpr instanceof FunctionCallExpr)) {
                throw new AnalysisException("The materialized view only support the single column or function expr. Error column: " + selectListItemExpr.toSql());
            }
            if (selectListItemExpr instanceof SlotRef) {
                if (meetAggregate) {
                    throw new AnalysisException("The aggregate column should be after the single column");
                }
                SlotRef slotRef = (SlotRef)selectListItemExpr;
                String columnName = slotRef.getColumnName().toLowerCase();
                if (!mvColumnNameSet.add(columnName)) {
                    ErrorReport.reportAnalysisException(ErrorCode.ERR_DUP_FIELDNAME, columnName);
                }
                MVColumnItem mvColumnItem = new MVColumnItem(columnName, slotRef.getType());
                this.mvColumnItemList.add(mvColumnItem);
                continue;
            }
            if (!(selectListItemExpr instanceof FunctionCallExpr)) continue;
            FunctionCallExpr functionCallExpr = (FunctionCallExpr)selectListItemExpr;
            String functionName = functionCallExpr.getFnName().getFunction();
            if (!this.isReplay) {
                MVColumnPattern mvColumnPattern = FN_NAME_TO_PATTERN.get(functionName.toLowerCase());
                if (mvColumnPattern == null) {
                    throw new AnalysisException("Materialized view does not support this function:" + functionCallExpr.toSqlImpl());
                }
                if (!mvColumnPattern.match(functionCallExpr)) {
                    throw new AnalysisException("The function " + functionName + " must match pattern:" + mvColumnPattern.toString());
                }
            }
            ArrayList slots = new ArrayList();
            functionCallExpr.collect(SlotRef.class, slots);
            Preconditions.checkArgument((slots.size() == 1 ? 1 : 0) != 0);
            String columnName = ((SlotRef)slots.get(0)).getColumnName().toLowerCase();
            if (!mvColumnNameSet.add(columnName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_DUP_FIELDNAME, columnName);
            }
            if (this.beginIndexOfAggregation == -1) {
                this.beginIndexOfAggregation = i;
            }
            meetAggregate = true;
            this.mvColumnItemList.add(this.buildMVColumnItem(functionCallExpr));
        }
        if (this.beginIndexOfAggregation == 0) {
            throw new AnalysisException("The materialized view must contain at least one key column");
        }
    }

    private void analyzeFromClause() throws AnalysisException {
        List<TableRef> tableRefList = this.selectStmt.getTableRefs();
        if (tableRefList.size() != 1) {
            throw new AnalysisException("The materialized view only support one table in from clause.");
        }
        TableName tableName = tableRefList.get(0).getName();
        this.baseIndexName = tableName.getTbl();
        this.dbName = tableName.getDb();
    }

    private void analyzeOrderByClause() throws AnalysisException {
        if (this.selectStmt.getOrderByElements() == null) {
            this.supplyOrderColumn();
            return;
        }
        ArrayList<OrderByElement> orderByElements = this.selectStmt.getOrderByElements();
        if (orderByElements.size() > this.mvColumnItemList.size()) {
            throw new AnalysisException("The number of columns in order clause must be less than the number of columns in select clause");
        }
        if (this.beginIndexOfAggregation != -1 && orderByElements.size() != this.beginIndexOfAggregation) {
            throw new AnalysisException("The key of columns in mv must be all of group by columns");
        }
        for (int i = 0; i < orderByElements.size(); ++i) {
            Expr orderByElement = ((OrderByElement)orderByElements.get(i)).getExpr();
            if (!(orderByElement instanceof SlotRef)) {
                throw new AnalysisException("The column in order clause must be original column without calculation. Error column: " + orderByElement.toSql());
            }
            MVColumnItem mvColumnItem = this.mvColumnItemList.get(i);
            SlotRef slotRef = (SlotRef)orderByElement;
            if (!mvColumnItem.getName().equalsIgnoreCase(slotRef.getColumnName())) {
                throw new AnalysisException("The order of columns in order by clause must be same as the order of columns in select list");
            }
            Preconditions.checkState((mvColumnItem.getAggregationType() == null ? 1 : 0) != 0);
            mvColumnItem.setIsKey(true);
        }
        for (MVColumnItem mvColumnItem : this.mvColumnItemList) {
            if (mvColumnItem.isKey()) continue;
            if (mvColumnItem.getAggregationType() != null) break;
            mvColumnItem.setAggregationType(AggregateType.NONE, true);
        }
    }

    private void supplyOrderColumn() throws AnalysisException {
        block7: {
            int theBeginIndexOfValue;
            block6: {
                if (this.mvKeysType != KeysType.AGG_KEYS) break block6;
                for (MVColumnItem mvColumnItem : this.mvColumnItemList) {
                    if (mvColumnItem.getAggregationType() != null) break;
                    mvColumnItem.setIsKey(true);
                }
                break block7;
            }
            if (this.mvKeysType != KeysType.DUP_KEYS) break block7;
            int keySizeByte = 0;
            for (theBeginIndexOfValue = 0; theBeginIndexOfValue < this.mvColumnItemList.size(); ++theBeginIndexOfValue) {
                MVColumnItem column = this.mvColumnItemList.get(theBeginIndexOfValue);
                if (theBeginIndexOfValue + 1 > FeConstants.shortkey_max_column_count || (keySizeByte += column.getType().getIndexSize()) > FeConstants.shortkey_maxsize_bytes) {
                    if (theBeginIndexOfValue != 0 || !column.getType().getPrimitiveType().isCharFamily()) break;
                    column.setIsKey(true);
                    ++theBeginIndexOfValue;
                    break;
                }
                if (column.getType().isFloatingPointType()) break;
                if (column.getType().getPrimitiveType() == PrimitiveType.VARCHAR) {
                    column.setIsKey(true);
                    ++theBeginIndexOfValue;
                    break;
                }
                column.setIsKey(true);
            }
            if (theBeginIndexOfValue == 0) {
                throw new AnalysisException("The first column could not be float or double type, use decimal instead");
            }
            while (theBeginIndexOfValue < this.mvColumnItemList.size()) {
                MVColumnItem mvColumnItem = this.mvColumnItemList.get(theBeginIndexOfValue);
                mvColumnItem.setAggregationType(AggregateType.NONE, true);
                ++theBeginIndexOfValue;
            }
        }
    }

    private MVColumnItem buildMVColumnItem(FunctionCallExpr functionCallExpr) throws AnalysisException {
        Type type;
        AggregateType mvAggregateType;
        String mvColumnName;
        String functionName = functionCallExpr.getFnName().getFunction();
        ArrayList slots = new ArrayList();
        functionCallExpr.collect(SlotRef.class, slots);
        Preconditions.checkArgument((slots.size() == 1 ? 1 : 0) != 0);
        SlotRef baseColumnRef = (SlotRef)slots.get(0);
        String baseColumnName = baseColumnRef.getColumnName().toLowerCase();
        Column baseColumn = baseColumnRef.getColumn();
        Preconditions.checkNotNull((Object)baseColumn);
        Type baseType = baseColumn.getOriginType();
        Expr functionChild0 = (Expr)functionCallExpr.getChild(0);
        Expr defineExpr = null;
        switch (functionName.toLowerCase()) {
            case "sum": {
                mvColumnName = baseColumnName;
                mvAggregateType = AggregateType.valueOf(functionName.toUpperCase());
                PrimitiveType baseColumnType = baseColumnRef.getType().getPrimitiveType();
                if (baseColumnType == PrimitiveType.TINYINT || baseColumnType == PrimitiveType.SMALLINT || baseColumnType == PrimitiveType.INT) {
                    type = Type.BIGINT;
                    break;
                }
                if (baseColumnType == PrimitiveType.FLOAT) {
                    type = Type.DOUBLE;
                    break;
                }
                type = baseType;
                break;
            }
            case "min": 
            case "max": {
                mvColumnName = baseColumnName;
                mvAggregateType = AggregateType.valueOf(functionName.toUpperCase());
                type = baseType;
                break;
            }
            case "bitmap_union": {
                if (baseColumnRef.getType().getPrimitiveType() == PrimitiveType.BITMAP) {
                    mvColumnName = baseColumnName;
                } else {
                    mvColumnName = CreateMaterializedViewStmt.mvColumnBuilder(functionName, baseColumnName);
                    defineExpr = functionChild0;
                }
                mvAggregateType = AggregateType.valueOf(functionName.toUpperCase());
                type = Type.BITMAP;
                break;
            }
            case "hll_union": {
                if (baseColumnRef.getType().getPrimitiveType() == PrimitiveType.HLL) {
                    mvColumnName = baseColumnName;
                } else {
                    mvColumnName = CreateMaterializedViewStmt.mvColumnBuilder(functionName, baseColumnName);
                    defineExpr = functionChild0;
                }
                mvAggregateType = AggregateType.valueOf(functionName.toUpperCase());
                type = Type.HLL;
                break;
            }
            case "count": {
                mvColumnName = CreateMaterializedViewStmt.mvColumnBuilder(functionName, baseColumnName);
                mvAggregateType = AggregateType.SUM;
                defineExpr = new CaseExpr(null, Lists.newArrayList((Object[])new CaseWhenClause[]{new CaseWhenClause(new IsNullPredicate(baseColumnRef, false), new IntLiteral(0L, (Type)Type.BIGINT))}), new IntLiteral(1L, (Type)Type.BIGINT));
                type = Type.BIGINT;
                break;
            }
            default: {
                throw new AnalysisException("Unsupported function:" + functionName);
            }
        }
        MVColumnItem mvColumnItem = new MVColumnItem(mvColumnName, type, mvAggregateType, false, defineExpr, baseColumnName);
        return mvColumnItem;
    }

    public Map<String, Expr> parseDefineExprWithoutAnalyze() throws AnalysisException {
        HashMap result = Maps.newHashMap();
        SelectList selectList = this.selectStmt.getSelectList();
        for (SelectListItem selectListItem : selectList.getItems()) {
            Expr selectListItemExpr = selectListItem.getExpr();
            if (selectListItemExpr instanceof SlotRef) {
                SlotRef slotRef = (SlotRef)selectListItemExpr;
                result.put(slotRef.getColumnName(), null);
                continue;
            }
            if (selectListItemExpr instanceof FunctionCallExpr) {
                FunctionCallExpr functionCallExpr = (FunctionCallExpr)selectListItemExpr;
                ArrayList slots = new ArrayList();
                functionCallExpr.collect(SlotRef.class, slots);
                Preconditions.checkArgument((slots.size() == 1 ? 1 : 0) != 0);
                String baseColumnName = ((SlotRef)slots.get(0)).getColumnName();
                String functionName = functionCallExpr.getFnName().getFunction();
                SlotRef baseSlotRef = (SlotRef)slots.get(0);
                switch (functionName.toLowerCase()) {
                    case "sum": 
                    case "min": 
                    case "max": {
                        result.put(baseColumnName, null);
                        break;
                    }
                    case "bitmap_union": {
                        FunctionCallExpr defineExpr;
                        ArrayList params;
                        CastExpr castExpr;
                        if (functionCallExpr.getChild(0) instanceof FunctionCallExpr) {
                            castExpr = new CastExpr(new TypeDef(Type.VARCHAR), (Expr)baseSlotRef);
                            params = Lists.newArrayList();
                            params.add(castExpr);
                            defineExpr = new FunctionCallExpr("to_bitmap", (List<Expr>)params);
                            result.put(CreateMaterializedViewStmt.mvColumnBuilder(functionName, baseColumnName), defineExpr);
                            break;
                        }
                        result.put(baseColumnName, null);
                        break;
                    }
                    case "hll_union": {
                        FunctionCallExpr defineExpr;
                        ArrayList params;
                        CastExpr castExpr;
                        if (functionCallExpr.getChild(0) instanceof FunctionCallExpr) {
                            castExpr = new CastExpr(new TypeDef(Type.VARCHAR), (Expr)baseSlotRef);
                            params = Lists.newArrayList();
                            params.add(castExpr);
                            defineExpr = new FunctionCallExpr("hll_hash", (List<Expr>)params);
                            result.put(CreateMaterializedViewStmt.mvColumnBuilder(functionName, baseColumnName), defineExpr);
                            break;
                        }
                        result.put(baseColumnName, null);
                        break;
                    }
                    case "count": {
                        CaseExpr defineExpr = new CaseExpr(null, Lists.newArrayList((Object[])new CaseWhenClause[]{new CaseWhenClause(new IsNullPredicate((Expr)slots.get(0), false), new IntLiteral(0L, (Type)Type.BIGINT))}), new IntLiteral(1L, (Type)Type.BIGINT));
                        result.put(CreateMaterializedViewStmt.mvColumnBuilder(functionName, baseColumnName), defineExpr);
                        break;
                    }
                    default: {
                        throw new AnalysisException("Unsupported function:" + functionName);
                    }
                }
                continue;
            }
            throw new AnalysisException("Unsupported select item:" + selectListItem.toSql());
        }
        return result;
    }

    public static String mvColumnBuilder(String functionName, String sourceColumnName) {
        return MATERIALIZED_VIEW_NAME_PREFIX + functionName + "_" + sourceColumnName;
    }

    @Override
    public String toSql() {
        return null;
    }

    static {
        FN_NAME_TO_PATTERN.put(AggregateType.SUM.name().toLowerCase(), new MVColumnOneChildPattern(AggregateType.SUM.name().toLowerCase()));
        FN_NAME_TO_PATTERN.put(AggregateType.MIN.name().toLowerCase(), new MVColumnOneChildPattern(AggregateType.MIN.name().toLowerCase()));
        FN_NAME_TO_PATTERN.put(AggregateType.MAX.name().toLowerCase(), new MVColumnOneChildPattern(AggregateType.MAX.name().toLowerCase()));
        FN_NAME_TO_PATTERN.put("count", new MVColumnOneChildPattern("count"));
        FN_NAME_TO_PATTERN.put("bitmap_union", new MVColumnBitmapUnionPattern());
        FN_NAME_TO_PATTERN.put("hll_union", new MVColumnHLLUnionPattern());
    }
}

