/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.IndexDef;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Index;
import org.apache.doris.common.AnalysisException;

public class CreateIndexClause
extends AlterTableClause {
    private TableName tableName;
    private IndexDef indexDef;
    private boolean alter;
    private Index index;

    public CreateIndexClause(TableName tableName, IndexDef indexDef, boolean alter) {
        super(AlterOpType.SCHEMA_CHANGE);
        this.tableName = tableName;
        this.indexDef = indexDef;
        this.alter = alter;
    }

    @Override
    public Map<String, String> getProperties() {
        return Maps.newHashMap();
    }

    public Index getIndex() {
        return this.index;
    }

    public IndexDef getIndexDef() {
        return this.indexDef;
    }

    public boolean isAlter() {
        return this.alter;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.indexDef == null) {
            throw new AnalysisException("index definition expected.");
        }
        this.indexDef.analyze();
        this.index = new Index(this.indexDef.getIndexName(), this.indexDef.getColumns(), this.indexDef.getIndexType(), this.indexDef.getComment());
    }

    @Override
    public String toSql() {
        if (this.alter) {
            return this.indexDef.toSql();
        }
        return "CREATE " + this.indexDef.toSql(this.tableName.toSql());
    }
}

