/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionArgsDef;
import org.apache.doris.analysis.FunctionName;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.TypeDef;
import org.apache.doris.catalog.AggregateFunction;
import org.apache.doris.catalog.AliasFunction;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.ScalarFunction;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.URI;
import org.apache.doris.common.util.Util;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.proto.FunctionService;
import org.apache.doris.proto.PFunctionServiceGrpc;
import org.apache.doris.proto.Types;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.thrift.TFunctionBinaryType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreateFunctionStmt
extends DdlStmt {
    private static final Logger LOG = LogManager.getLogger(CreateFunctionStmt.class);
    public static final String OBJECT_FILE_KEY = "object_file";
    public static final String SYMBOL_KEY = "symbol";
    public static final String PREPARE_SYMBOL_KEY = "prepare_fn";
    public static final String CLOSE_SYMBOL_KEY = "close_fn";
    public static final String MD5_CHECKSUM = "md5";
    public static final String INIT_KEY = "init_fn";
    public static final String UPDATE_KEY = "update_fn";
    public static final String MERGE_KEY = "merge_fn";
    public static final String SERIALIZE_KEY = "serialize_fn";
    public static final String FINALIZE_KEY = "finalize_fn";
    public static final String GET_VALUE_KEY = "get_value_fn";
    public static final String REMOVE_KEY = "remove_fn";
    public static final String BINARY_TYPE = "type";
    private final FunctionName functionName;
    private final boolean isAggregate;
    private final boolean isAlias;
    private final FunctionArgsDef argsDef;
    private final TypeDef returnType;
    private TypeDef intermediateType;
    private final Map<String, String> properties;
    private final List<String> parameters;
    private final Expr originFunction;
    TFunctionBinaryType binaryType = TFunctionBinaryType.NATIVE;
    private String objectFile;
    private Function function;
    private String checksum = "";
    private static final int HTTP_TIMEOUT_MS = 10000;

    public CreateFunctionStmt(boolean isAggregate, FunctionName functionName, FunctionArgsDef argsDef, TypeDef returnType, TypeDef intermediateType, Map<String, String> properties) {
        this.functionName = functionName;
        this.isAggregate = isAggregate;
        this.argsDef = argsDef;
        this.returnType = returnType;
        this.intermediateType = intermediateType;
        this.properties = properties == null ? ImmutableSortedMap.of() : ImmutableSortedMap.copyOf(properties, (Comparator)String.CASE_INSENSITIVE_ORDER);
        this.isAlias = false;
        this.parameters = ImmutableList.of();
        this.originFunction = null;
    }

    public CreateFunctionStmt(FunctionName functionName, FunctionArgsDef argsDef, List<String> parameters, Expr originFunction) {
        this.functionName = functionName;
        this.isAlias = true;
        this.argsDef = argsDef;
        this.parameters = parameters == null ? ImmutableList.of() : ImmutableList.copyOf(parameters);
        this.originFunction = originFunction;
        this.isAggregate = false;
        this.returnType = new TypeDef(Type.VARCHAR);
        this.properties = ImmutableSortedMap.of();
    }

    public FunctionName getFunctionName() {
        return this.functionName;
    }

    public Function getFunction() {
        return this.function;
    }

    public Expr getOriginFunction() {
        return this.originFunction;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        this.analyzeCommon(analyzer);
        if (this.isAggregate) {
            this.analyzeUda();
        } else if (this.isAlias) {
            this.analyzeAliasFunction();
        } else {
            this.analyzeUdf();
        }
    }

    private void analyzeCommon(Analyzer analyzer) throws AnalysisException {
        this.functionName.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
        this.argsDef.analyze(analyzer);
        if (this.isAlias) {
            return;
        }
        this.returnType.analyze(analyzer);
        if (this.intermediateType != null) {
            this.intermediateType.analyze(analyzer);
        } else {
            this.intermediateType = this.returnType;
        }
        String type = this.properties.getOrDefault(BINARY_TYPE, "NATIVE");
        this.binaryType = this.getFunctionBinaryType(type);
        if (this.binaryType == null) {
            throw new AnalysisException("unknown function type");
        }
        this.objectFile = this.properties.get(OBJECT_FILE_KEY);
        if (Strings.isNullOrEmpty((String)this.objectFile)) {
            throw new AnalysisException("No 'object_file' in properties");
        }
        if (this.binaryType != TFunctionBinaryType.RPC) {
            try {
                this.computeObjectChecksum();
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new AnalysisException("cannot to compute object's checksum. err: " + e.getMessage());
            }
            String md5sum = this.properties.get(MD5_CHECKSUM);
            if (md5sum != null && !md5sum.equalsIgnoreCase(this.checksum)) {
                throw new AnalysisException("library's checksum is not equal with input, checksum=" + this.checksum);
            }
        }
    }

    private void computeObjectChecksum() throws IOException, NoSuchAlgorithmException {
        if (FeConstants.runningUnitTest) {
            return;
        }
        try (InputStream inputStream = Util.getInputStreamFromUrl(this.objectFile, null, 10000, 10000);){
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buf = new byte[4096];
            int bytesRead = 0;
            while ((bytesRead = inputStream.read(buf)) >= 0) {
                digest.update(buf, 0, bytesRead);
            }
            this.checksum = Hex.encodeHexString((byte[])digest.digest());
        }
    }

    private void analyzeUda() throws AnalysisException {
        if (this.binaryType == TFunctionBinaryType.RPC) {
            throw new AnalysisException("RPC UDAF is not supported.");
        }
        AggregateFunction.AggregateFunctionBuilder builder = AggregateFunction.AggregateFunctionBuilder.createUdfBuilder();
        builder.name(this.functionName).argsType(this.argsDef.getArgTypes()).retType(this.returnType.getType()).hasVarArgs(this.argsDef.isVariadic()).intermediateType(this.intermediateType.getType()).location(URI.create(this.objectFile));
        String initFnSymbol = this.properties.get(INIT_KEY);
        if (initFnSymbol == null) {
            throw new AnalysisException("No 'init_fn' in properties");
        }
        String updateFnSymbol = this.properties.get(UPDATE_KEY);
        if (updateFnSymbol == null) {
            throw new AnalysisException("No 'update_fn' in properties");
        }
        String mergeFnSymbol = this.properties.get(MERGE_KEY);
        if (mergeFnSymbol == null) {
            throw new AnalysisException("No 'merge_fn' in properties");
        }
        this.function = builder.initFnSymbol(initFnSymbol).updateFnSymbol(updateFnSymbol).mergeFnSymbol(mergeFnSymbol).serializeFnSymbol(this.properties.get(SERIALIZE_KEY)).finalizeFnSymbol(this.properties.get(FINALIZE_KEY)).getValueFnSymbol(this.properties.get(GET_VALUE_KEY)).removeFnSymbol(this.properties.get(REMOVE_KEY)).build();
        this.function.setChecksum(this.checksum);
    }

    private void analyzeUdf() throws AnalysisException {
        String symbol = this.properties.get(SYMBOL_KEY);
        if (Strings.isNullOrEmpty((String)symbol)) {
            throw new AnalysisException("No 'symbol' in properties");
        }
        String prepareFnSymbol = this.properties.get(PREPARE_SYMBOL_KEY);
        String closeFnSymbol = this.properties.get(CLOSE_SYMBOL_KEY);
        if (this.binaryType == TFunctionBinaryType.RPC && !this.objectFile.contains("://")) {
            if (StringUtils.isNotBlank((CharSequence)prepareFnSymbol) || StringUtils.isNotBlank((CharSequence)closeFnSymbol)) {
                throw new AnalysisException(" prepare and close in RPC UDF are not supported.");
            }
            String[] url = this.objectFile.split(":");
            if (url.length != 2) {
                throw new AnalysisException("function server address invalid.");
            }
            String host = url[0];
            int port = Integer.valueOf(url[1]);
            ManagedChannel channel = ((NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)host, (int)port).flowControlWindow(Config.grpc_max_message_size_bytes).maxInboundMessageSize(Config.grpc_max_message_size_bytes)).enableRetry()).maxRetryAttempts(3)).usePlaintext().build();
            PFunctionServiceGrpc.PFunctionServiceBlockingStub stub = PFunctionServiceGrpc.newBlockingStub((Channel)channel);
            FunctionService.PCheckFunctionRequest.Builder builder = FunctionService.PCheckFunctionRequest.newBuilder();
            builder.getFunctionBuilder().setFunctionName(symbol);
            for (Type arg : this.argsDef.getArgTypes()) {
                builder.getFunctionBuilder().addInputs(this.convertToPParameterType(arg));
            }
            builder.getFunctionBuilder().setOutput(this.convertToPParameterType(this.returnType.getType()));
            FunctionService.PCheckFunctionResponse response = stub.checkFn(builder.build());
            if (response == null || !response.hasStatus()) {
                throw new AnalysisException("cannot access function server");
            }
            if (response.getStatus().getStatusCode() != 0) {
                throw new AnalysisException("check function [" + symbol + "] failed: " + response.getStatus());
            }
        }
        URI location = URI.create(this.objectFile);
        this.function = ScalarFunction.createUdf(this.binaryType, this.functionName, this.argsDef.getArgTypes(), this.returnType.getType(), this.argsDef.isVariadic(), location, symbol, prepareFnSymbol, closeFnSymbol);
        this.function.setChecksum(this.checksum);
    }

    private Types.PGenericType convertToPParameterType(Type arg) throws AnalysisException {
        Types.PGenericType.Builder typeBuilder = Types.PGenericType.newBuilder();
        switch (arg.getPrimitiveType()) {
            case INVALID_TYPE: {
                typeBuilder.setId(Types.PGenericType.TypeId.UNKNOWN);
                break;
            }
            case BOOLEAN: {
                typeBuilder.setId(Types.PGenericType.TypeId.BOOLEAN);
                break;
            }
            case SMALLINT: {
                typeBuilder.setId(Types.PGenericType.TypeId.INT16);
                break;
            }
            case TINYINT: {
                typeBuilder.setId(Types.PGenericType.TypeId.INT8);
                break;
            }
            case INT: {
                typeBuilder.setId(Types.PGenericType.TypeId.INT32);
                break;
            }
            case BIGINT: {
                typeBuilder.setId(Types.PGenericType.TypeId.INT64);
                break;
            }
            case FLOAT: {
                typeBuilder.setId(Types.PGenericType.TypeId.FLOAT);
                break;
            }
            case DOUBLE: {
                typeBuilder.setId(Types.PGenericType.TypeId.DOUBLE);
                break;
            }
            case CHAR: 
            case VARCHAR: {
                typeBuilder.setId(Types.PGenericType.TypeId.STRING);
                break;
            }
            case HLL: {
                typeBuilder.setId(Types.PGenericType.TypeId.HLL);
                break;
            }
            case BITMAP: {
                typeBuilder.setId(Types.PGenericType.TypeId.BITMAP);
                break;
            }
            case DATE: {
                typeBuilder.setId(Types.PGenericType.TypeId.DATE);
                break;
            }
            case DATETIME: 
            case TIME: {
                typeBuilder.setId(Types.PGenericType.TypeId.DATETIME);
                break;
            }
            case DECIMALV2: {
                typeBuilder.setId(Types.PGenericType.TypeId.DECIMAL128).getDecimalTypeBuilder().setPrecision(((ScalarType)arg).getScalarPrecision()).setScale(((ScalarType)arg).getScalarScale());
                break;
            }
            case LARGEINT: {
                typeBuilder.setId(Types.PGenericType.TypeId.INT128);
                break;
            }
            default: {
                throw new AnalysisException("type " + arg.getPrimitiveType().toString() + " is not supported");
            }
        }
        return typeBuilder.build();
    }

    private TFunctionBinaryType getFunctionBinaryType(String type) {
        TFunctionBinaryType binaryType = null;
        try {
            binaryType = TFunctionBinaryType.valueOf((String)type);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return binaryType;
    }

    private void analyzeAliasFunction() throws AnalysisException {
        this.function = AliasFunction.createFunction(this.functionName, this.argsDef.getArgTypes(), Type.VARCHAR, this.argsDef.isVariadic(), this.parameters, this.originFunction);
        ((AliasFunction)this.function).analyze();
    }

    @Override
    public String toSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE ");
        if (this.isAggregate) {
            stringBuilder.append("AGGREGATE ");
        } else if (this.isAlias) {
            stringBuilder.append("ALIAS ");
        }
        stringBuilder.append("FUNCTION ");
        stringBuilder.append(this.functionName.toString());
        stringBuilder.append(this.argsDef.toSql());
        if (this.isAlias) {
            stringBuilder.append(" WITH PARAMETER (").append(this.parameters.toString()).append(") AS ").append(this.originFunction.toSql());
        } else {
            stringBuilder.append(" RETURNS ");
            stringBuilder.append(this.returnType.toString());
        }
        if (this.properties.size() > 0) {
            stringBuilder.append(" PROPERTIES (");
            int i = 0;
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\"').append(entry.getKey()).append('\"');
                stringBuilder.append("=");
                stringBuilder.append('\"').append(entry.getValue()).append('\"');
                ++i;
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.FORWARD_WITH_SYNC;
    }
}

