/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class CreateFileStmt
extends DdlStmt {
    public static final String PROP_CATALOG_DEFAULT = "DEFAULT";
    private static final String PROP_CATALOG = "catalog";
    private static final String PROP_URL = "url";
    private static final String PROP_MD5 = "md5";
    private static final String PROP_SAVE_CONTENT = "save_content";
    private static final ImmutableSet<String> PROPERTIES_SET = new ImmutableSet.Builder().add((Object)"catalog").add((Object)"url").add((Object)"md5").build();
    private final String fileName;
    private String dbName;
    private final Map<String, String> properties;
    private String catalogName;
    private String downloadUrl;
    private String checksum;
    private boolean saveContent = true;

    public CreateFileStmt(String fileName, String dbName, Map<String, String> properties) {
        this.fileName = fileName;
        this.dbName = dbName;
        this.properties = properties;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public boolean isSaveContent() {
        return this.saveContent;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
        if (this.dbName == null) {
            this.dbName = analyzer.getDefaultDb();
        } else {
            if (Strings.isNullOrEmpty((String)analyzer.getClusterName())) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NAME_NULL, new Object[0]);
            }
            this.dbName = ClusterNamespace.getFullName(analyzer.getClusterName(), this.dbName);
        }
        if (Strings.isNullOrEmpty((String)this.dbName)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
        }
        if (Strings.isNullOrEmpty((String)this.fileName)) {
            throw new AnalysisException("File name is not specified");
        }
        this.analyzeProperties();
    }

    private void analyzeProperties() throws AnalysisException {
        Optional<String> optional = this.properties.keySet().stream().filter(entity -> !PROPERTIES_SET.contains(entity)).findFirst();
        if (optional.isPresent()) {
            throw new AnalysisException(optional.get() + " is invalid property");
        }
        this.catalogName = this.properties.get(PROP_CATALOG);
        if (Strings.isNullOrEmpty((String)this.catalogName)) {
            this.catalogName = PROP_CATALOG_DEFAULT;
        }
        this.downloadUrl = this.properties.get(PROP_URL);
        if (Strings.isNullOrEmpty((String)this.downloadUrl)) {
            throw new AnalysisException("download url is missing");
        }
        if (this.properties.containsKey(PROP_MD5)) {
            this.checksum = this.properties.get(PROP_MD5);
        }
        if (this.properties.containsKey(PROP_SAVE_CONTENT)) {
            throw new AnalysisException("'save_content' property is not supported yet");
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE FILE \"").append(this.fileName).append("\"");
        if (this.dbName != null) {
            sb.append(" IN ").append(this.dbName);
        }
        sb.append(" PROPERTIES(");
        PrintableMap<String, String> map = new PrintableMap<String, String>(this.properties, ",", true, false);
        sb.append(map.toString());
        return sb.toString();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.FORWARD_WITH_SYNC;
    }
}

