/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.EncryptKeyName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.EncryptKey;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class CreateEncryptKeyStmt
extends DdlStmt {
    private final EncryptKeyName encryptKeyName;
    private final String keyString;
    private EncryptKey encryptKey;

    public CreateEncryptKeyStmt(EncryptKeyName encryptKeyName, String keyString) {
        this.encryptKeyName = encryptKeyName;
        this.keyString = keyString;
    }

    public EncryptKeyName getEncryptKeyName() {
        return this.encryptKeyName;
    }

    public String getKeyString() {
        return this.keyString;
    }

    public EncryptKey getEncryptKey() {
        return this.encryptKey;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
        this.encryptKeyName.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.keyString)) {
            throw new AnalysisException("keyString can not be null or empty string.");
        }
        this.encryptKey = new EncryptKey(this.encryptKeyName, this.keyString);
    }

    @Override
    public String toSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE ENCRYPTKEY ").append(this.encryptKeyName.getKeyName()).append(" AS \"").append(this.keyString).append("\"");
        return stringBuilder.toString();
    }
}

