/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinlogDesc;
import org.apache.doris.analysis.ChannelDescription;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.load.sync.DataSyncJobType;

public class CreateDataSyncJobStmt
extends DdlStmt {
    private String jobName;
    private String dbName;
    private DataSyncJobType dataSyncJobType;
    private final List<ChannelDescription> channelDescriptions;
    private final BinlogDesc binlogDesc;
    private final Map<String, String> properties;

    public CreateDataSyncJobStmt(String jobName, String dbName, List<ChannelDescription> channelDescriptions, BinlogDesc binlogDesc, Map<String, String> properties) {
        this.jobName = jobName;
        this.dbName = dbName;
        this.channelDescriptions = channelDescriptions;
        this.binlogDesc = binlogDesc;
        this.properties = properties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.dbName)) {
            if (Strings.isNullOrEmpty((String)analyzer.getDefaultDb())) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
            this.dbName = analyzer.getDefaultDb();
        }
        this.dbName = ClusterNamespace.getFullName(analyzer.getClusterName(), this.dbName);
        if (this.binlogDesc != null) {
            this.binlogDesc.analyze();
            this.dataSyncJobType = this.binlogDesc.getDataSyncJobType();
            if (this.dataSyncJobType != DataSyncJobType.CANAL) {
                throw new AnalysisException("Data sync job now only support CANAL type");
            }
        }
        if (this.channelDescriptions == null || this.channelDescriptions.isEmpty()) {
            throw new AnalysisException("No channel is assign in data sync job statement.");
        }
        for (ChannelDescription channelDescription : this.channelDescriptions) {
            channelDescription.analyze(this.dbName);
            String tableName = channelDescription.getTargetTable();
            Database db = Catalog.getCurrentCatalog().getDbOrAnalysisException(this.dbName);
            OlapTable olapTable = db.getOlapTableOrAnalysisException(tableName);
            if (olapTable.getKeysType() != KeysType.UNIQUE_KEYS) {
                throw new AnalysisException("Table: " + tableName + " is not a unique table, key type: " + (Object)((Object)olapTable.getKeysType()));
            }
            if (olapTable.hasDeleteSign()) continue;
            throw new AnalysisException("Table: " + tableName + " don't support batch delete. Please upgrade it to support, see `help alter table`.");
        }
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public List<ChannelDescription> getChannelDescriptions() {
        return this.channelDescriptions;
    }

    public BinlogDesc getBinlogDesc() {
        return this.binlogDesc;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public DataSyncJobType getDataSyncJobType() {
        return this.dataSyncJobType;
    }
}

