/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.Config;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.MysqlPassword;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

@Deprecated
public class CreateClusterStmt
extends DdlStmt {
    public static String CLUSTER_INSTANCE_NUM = "instance_num";
    public static String CLUSTER_SUPERMAN_PASSWORD = "password";
    public static String CLUSTER_SUPERUSER_NAME = "superuser";
    private String clusterName;
    private boolean ifNotExists;
    private int instanceNum;
    private Map<String, String> properties;
    private byte[] scramblePassword;
    private String passwd;

    public CreateClusterStmt() {
    }

    public CreateClusterStmt(String clusterName, Map<String, String> properties, String passwd) {
        this.clusterName = clusterName;
        this.properties = properties;
        this.passwd = passwd;
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    @Override
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public boolean isSetIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        String password;
        if (Config.disable_cluster_feature) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_INVALID_OPERATION, "CREATE CLUSTER");
        }
        FeNameFormat.checkDbName(this.clusterName);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.OPERATOR)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NO_AUTHORITY, analyzer.getQualifiedUser());
        }
        if (this.properties == null || this.properties.size() == 0 || !this.properties.containsKey(CLUSTER_INSTANCE_NUM)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NO_PARAMETER, new Object[0]);
        }
        try {
            this.instanceNum = Integer.valueOf(this.properties.get(CLUSTER_INSTANCE_NUM));
        }
        catch (NumberFormatException e) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NO_PARAMETER, new Object[0]);
        }
        if (this.instanceNum < 0) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_CREATE_ISTANCE_NUM_ERROR, new Object[0]);
        }
        this.scramblePassword = !Strings.isNullOrEmpty((String)(password = this.passwd)) ? MysqlPassword.makeScrambledPassword(password) : new byte[0];
    }

    @Override
    public String toSql() {
        String sql = "CREATE CLUSTER " + this.clusterName + " PROPERTIES(\"instance_num\"=\"" + this.instanceNum + "\")IDENTIFIED BY '" + this.passwd + "'";
        return sql;
    }

    public String toString() {
        return this.toSql();
    }

    public int getInstanceNum() {
        return this.instanceNum;
    }

    public void setInstanceNum(int instanceNum) {
        this.instanceNum = instanceNum;
    }

    public byte[] getPassword() {
        return this.scramblePassword;
    }
}

