/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.Predicate;
import org.apache.doris.catalog.FunctionSet;
import org.apache.doris.catalog.ScalarFunction;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;
import org.apache.doris.thrift.TExprOpcode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompoundPredicate
extends Predicate {
    private static final Logger LOG = LogManager.getLogger(CompoundPredicate.class);
    private final Operator op;

    public static void initBuiltins(FunctionSet functionSet) {
        functionSet.addBuiltinBothScalaAndVectorized(ScalarFunction.createBuiltinOperator(Operator.AND.toString(), Lists.newArrayList((Object[])new Type[]{Type.BOOLEAN, Type.BOOLEAN}), Type.BOOLEAN));
        functionSet.addBuiltinBothScalaAndVectorized(ScalarFunction.createBuiltinOperator(Operator.OR.toString(), Lists.newArrayList((Object[])new Type[]{Type.BOOLEAN, Type.BOOLEAN}), Type.BOOLEAN));
        functionSet.addBuiltinBothScalaAndVectorized(ScalarFunction.createBuiltinOperator(Operator.NOT.toString(), Lists.newArrayList((Object[])new Type[]{Type.BOOLEAN}), Type.BOOLEAN));
    }

    public CompoundPredicate(Operator op, Expr e1, Expr e2) {
        this.op = op;
        Preconditions.checkNotNull((Object)e1);
        this.children.add(e1);
        Preconditions.checkArgument((op == Operator.NOT && e2 == null || op != Operator.NOT && e2 != null ? 1 : 0) != 0);
        if (e2 != null) {
            this.children.add(e2);
        }
    }

    protected CompoundPredicate(CompoundPredicate other) {
        super(other);
        this.op = other.op;
    }

    @Override
    public Expr clone() {
        return new CompoundPredicate(this);
    }

    public Operator getOp() {
        return this.op;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && ((CompoundPredicate)obj).op == this.op;
    }

    @Override
    public String toSqlImpl() {
        if (this.children.size() == 1) {
            Preconditions.checkState((this.op == Operator.NOT ? 1 : 0) != 0);
            return "NOT " + ((Expr)this.getChild(0)).toSql();
        }
        return ((Expr)this.getChild(0)).toSql() + " " + this.op.toString() + " " + ((Expr)this.getChild(1)).toSql();
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.COMPOUND_PRED;
        msg.setOpcode(this.op.toThrift());
    }

    @Override
    public boolean isVectorized() {
        return false;
    }

    @Override
    public void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        super.analyzeImpl(analyzer);
        for (Expr e : this.children) {
            if (e.getType().equals(Type.BOOLEAN) || e.getType().isNull()) continue;
            throw new AnalysisException(String.format("Operand '%s' part of predicate '%s' should return type 'BOOLEAN' but returns type '%s'.", e.toSql(), this.toSql(), e.getType()));
        }
        if (((Expr)this.getChild((int)0)).selectivity == -1.0 || this.children.size() == 2 && ((Expr)this.getChild((int)1)).selectivity == -1.0) {
            this.selectivity = -1.0;
            return;
        }
        switch (this.op) {
            case AND: {
                this.selectivity = ((Expr)this.getChild((int)0)).selectivity * ((Expr)this.getChild((int)1)).selectivity;
                break;
            }
            case OR: {
                this.selectivity = ((Expr)this.getChild((int)0)).selectivity + ((Expr)this.getChild((int)1)).selectivity - ((Expr)this.getChild((int)0)).selectivity * ((Expr)this.getChild((int)1)).selectivity;
                break;
            }
            case NOT: {
                this.selectivity = 1.0 - ((Expr)this.getChild((int)0)).selectivity;
            }
        }
        this.selectivity = Math.max(0.0, Math.min(1.0, this.selectivity));
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.toSql() + " selectivity: " + Double.toString(this.selectivity));
        }
    }

    @Override
    public Expr negate() {
        if (this.op == Operator.NOT) {
            return (Expr)this.getChild(0);
        }
        Expr negatedLeft = ((Expr)this.getChild(0)).negate();
        Expr negatedRight = ((Expr)this.getChild(1)).negate();
        Operator newOp = this.op == Operator.OR ? Operator.AND : Operator.OR;
        return new CompoundPredicate(newOp, negatedLeft, negatedRight);
    }

    public static Expr createConjunction(Expr lhs, Expr rhs) {
        if (rhs == null) {
            return lhs;
        }
        return new CompoundPredicate(Operator.AND, rhs, lhs);
    }

    public static Expr createConjunctivePredicate(List<Expr> conjuncts) {
        Expr conjunctivePred = null;
        for (Expr expr : conjuncts) {
            if (conjunctivePred == null) {
                conjunctivePred = expr;
                continue;
            }
            conjunctivePred = new CompoundPredicate(Operator.AND, expr, conjunctivePred);
        }
        return conjunctivePred;
    }

    @Override
    public Expr getResultValue() throws AnalysisException {
        this.recursiveResetChildrenResult();
        boolean compoundResult = false;
        if (this.op == Operator.NOT) {
            Expr childValue = (Expr)this.getChild(0);
            if (!(childValue instanceof BoolLiteral)) {
                return this;
            }
            BoolLiteral boolChild = (BoolLiteral)childValue;
            compoundResult = !boolChild.getValue();
        } else {
            Expr leftChildValue = (Expr)this.getChild(0);
            Expr rightChildValue = (Expr)this.getChild(1);
            if (!(leftChildValue instanceof BoolLiteral) || !(rightChildValue instanceof BoolLiteral)) {
                return this;
            }
            BoolLiteral leftBoolValue = (BoolLiteral)leftChildValue;
            BoolLiteral rightBoolValue = (BoolLiteral)rightChildValue;
            switch (this.op) {
                case AND: {
                    compoundResult = leftBoolValue.getValue() && rightBoolValue.getValue();
                    break;
                }
                case OR: {
                    compoundResult = leftBoolValue.getValue() || rightBoolValue.getValue();
                    break;
                }
                default: {
                    Preconditions.checkState((boolean)false, (Object)"No defined binary operator.");
                }
            }
        }
        return new BoolLiteral(compoundResult);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode((Object)this.op);
    }

    @Override
    public boolean isNullable() {
        return this.hasNullableChild();
    }

    public static enum Operator {
        AND("AND", TExprOpcode.COMPOUND_AND),
        OR("OR", TExprOpcode.COMPOUND_OR),
        NOT("NOT", TExprOpcode.COMPOUND_NOT);

        private final String description;
        private final TExprOpcode thriftOp;

        private Operator(String description, TExprOpcode thriftOp) {
            this.description = description;
            this.thriftOp = thriftOp;
        }

        public String toString() {
            return this.description;
        }

        public TExprOpcode toThrift() {
            return this.thriftOp;
        }
    }
}

