/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.FeNameFormat;

public class ColumnRenameClause
extends AlterTableClause {
    private String colName;
    private String newColName;

    public ColumnRenameClause(String colName, String newColName) {
        super(AlterOpType.RENAME);
        this.colName = colName;
        this.newColName = newColName;
        this.needTableStable = false;
    }

    public String getColName() {
        return this.colName;
    }

    public String getNewColName() {
        return this.newColName;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.colName)) {
            throw new AnalysisException("Column name is not set");
        }
        if (Strings.isNullOrEmpty((String)this.newColName)) {
            throw new AnalysisException("New column name is not set");
        }
        FeNameFormat.checkColumnName(this.newColName);
    }

    @Override
    public Map<String, String> getProperties() {
        return null;
    }

    @Override
    public String toSql() {
        return "RENAME COLUMN " + this.colName + " " + this.newColName;
    }

    public String toString() {
        return this.toSql();
    }
}

