/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.common.AnalysisException;

public class ColumnPosition {
    public static final ColumnPosition FIRST = new ColumnPosition();
    private String lastCol;

    public String getLastCol() {
        return this.lastCol;
    }

    private ColumnPosition() {
    }

    public ColumnPosition(String col) {
        this.lastCol = col;
    }

    public void analyze() throws AnalysisException {
        if (this == FIRST) {
            return;
        }
        if (Strings.isNullOrEmpty((String)this.lastCol)) {
            throw new AnalysisException("Column is empty.");
        }
    }

    public boolean isFirst() {
        return this == FIRST;
    }

    public String toSql() {
        StringBuilder sb = new StringBuilder();
        if (this == FIRST) {
            sb.append("FIRST");
        } else {
            sb.append("AFTER `").append(this.lastCol).append("`");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

