/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.DateLiteral;
import org.apache.doris.analysis.DecimalLiteral;
import org.apache.doris.analysis.DefaultValueExprDef;
import org.apache.doris.analysis.FloatLiteral;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LargeIntLiteral;
import org.apache.doris.analysis.TypeDef;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.FeNameFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ColumnDef {
    private static final Logger LOG = LogManager.getLogger(ColumnDef.class);
    private String name;
    private TypeDef typeDef;
    private AggregateType aggregateType;
    private boolean isKey;
    private boolean isAllowNull;
    private DefaultValue defaultValue;
    private String comment;
    private boolean visible;

    public ColumnDef(String name, TypeDef typeDef) {
        this.name = name;
        this.typeDef = typeDef;
        this.comment = "";
        this.defaultValue = DefaultValue.NOT_SET;
    }

    public ColumnDef(String name, TypeDef typeDef, boolean isKey, AggregateType aggregateType, boolean isAllowNull, DefaultValue defaultValue, String comment) {
        this(name, typeDef, isKey, aggregateType, isAllowNull, defaultValue, comment, true);
    }

    public ColumnDef(String name, TypeDef typeDef, boolean isKey, AggregateType aggregateType, boolean isAllowNull, DefaultValue defaultValue, String comment, boolean visible) {
        this.name = name;
        this.typeDef = typeDef;
        this.isKey = isKey;
        this.aggregateType = aggregateType;
        this.isAllowNull = isAllowNull;
        this.defaultValue = defaultValue;
        this.comment = comment;
        this.visible = visible;
    }

    public static ColumnDef newDeleteSignColumnDef() {
        return new ColumnDef("__DORIS_DELETE_SIGN__", TypeDef.create(PrimitiveType.TINYINT), false, null, false, new DefaultValue(true, "0"), "doris delete flag hidden column", false);
    }

    public static ColumnDef newDeleteSignColumnDef(AggregateType aggregateType) {
        return new ColumnDef("__DORIS_DELETE_SIGN__", TypeDef.create(PrimitiveType.TINYINT), false, aggregateType, false, new DefaultValue(true, "0"), "doris delete flag hidden column", false);
    }

    public static ColumnDef newSequenceColumnDef(Type type) {
        return new ColumnDef("__DORIS_SEQUENCE_COL__", new TypeDef(type), false, null, true, DefaultValue.NULL_DEFAULT_VALUE, "sequence column hidden column", false);
    }

    public static ColumnDef newSequenceColumnDef(Type type, AggregateType aggregateType) {
        return new ColumnDef("__DORIS_SEQUENCE_COL__", new TypeDef(type), false, aggregateType, true, DefaultValue.NULL_DEFAULT_VALUE, "sequence column hidden column", false);
    }

    public boolean isAllowNull() {
        return this.isAllowNull;
    }

    public String getDefaultValue() {
        return this.defaultValue.value;
    }

    public String getName() {
        return this.name;
    }

    public AggregateType getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(AggregateType aggregateType) {
        this.aggregateType = aggregateType;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public void setIsKey(boolean isKey) {
        this.isKey = isKey;
    }

    public TypeDef getTypeDef() {
        return this.typeDef;
    }

    public Type getType() {
        return this.typeDef.getType();
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void analyze(boolean isOlap) throws AnalysisException {
        ScalarType targetType;
        if (this.name == null || this.typeDef == null) {
            throw new AnalysisException("No column name or column type in column definition.");
        }
        FeNameFormat.checkColumnName(this.name);
        if (this.typeDef.getType().isScalarType() && (targetType = (ScalarType)this.typeDef.getType()).getPrimitiveType().isStringType() && !targetType.isAssignedStrLenInColDefinition()) {
            targetType.setLength(1);
        }
        this.typeDef.analyze((Analyzer)null);
        Type type = this.typeDef.getType();
        if (type.isBitmapType() || type.isHllType()) {
            if (this.isKey) {
                throw new AnalysisException("Key column can not set bitmap or hll type:" + this.name);
            }
            if (this.aggregateType == null) {
                throw new AnalysisException("Bitmap and hll type have to use aggregate function" + this.name);
            }
        }
        if (this.aggregateType != null) {
            if (this.isKey) {
                throw new AnalysisException("Key column can not set aggregation type: " + this.name);
            }
            if (!this.aggregateType.checkCompatibility(type.getPrimitiveType())) {
                throw new AnalysisException(String.format("Aggregate type %s is not compatible with primitive type %s", this.toString(), type.toSql()));
            }
        }
        if ((type.getPrimitiveType() == PrimitiveType.FLOAT || type.getPrimitiveType() == PrimitiveType.DOUBLE) && isOlap && this.isKey) {
            throw new AnalysisException("Float or double can not used as a key, use decimal instead.");
        }
        if (type.getPrimitiveType() == PrimitiveType.HLL) {
            if (this.defaultValue.isSet) {
                throw new AnalysisException("Hll type column can not set default value");
            }
            this.defaultValue = DefaultValue.HLL_EMPTY_DEFAULT_VALUE;
        }
        if (type.getPrimitiveType() == PrimitiveType.BITMAP) {
            if (this.defaultValue.isSet && this.defaultValue != DefaultValue.NULL_DEFAULT_VALUE) {
                throw new AnalysisException("Bitmap type column can not set default value");
            }
            this.defaultValue = DefaultValue.BITMAP_EMPTY_DEFAULT_VALUE;
        }
        if (type.getPrimitiveType() == PrimitiveType.ARRAY && this.defaultValue.isSet && this.defaultValue != DefaultValue.NULL_DEFAULT_VALUE) {
            throw new AnalysisException("Array type column default value only support null");
        }
        if (this.isKey() && type.getPrimitiveType() == PrimitiveType.STRING) {
            throw new AnalysisException("String Type should not be used in key column[" + this.getName() + "].");
        }
        if (type.getPrimitiveType() == PrimitiveType.MAP && this.defaultValue.isSet && this.defaultValue != DefaultValue.NULL_DEFAULT_VALUE) {
            throw new AnalysisException("Map type column default value just support null");
        }
        if (type.getPrimitiveType() == PrimitiveType.STRUCT && this.defaultValue.isSet && this.defaultValue != DefaultValue.NULL_DEFAULT_VALUE) {
            throw new AnalysisException("Struct type column default value just support null");
        }
        if (this.aggregateType == AggregateType.REPLACE_IF_NOT_NULL) {
            this.isAllowNull = true;
            if (!this.defaultValue.isSet) {
                this.defaultValue = DefaultValue.NULL_DEFAULT_VALUE;
            }
        }
        if (!this.isAllowNull && this.defaultValue == DefaultValue.NULL_DEFAULT_VALUE) {
            throw new AnalysisException("Can not set null default value to non nullable column: " + this.name);
        }
        if (this.defaultValue.isSet && this.defaultValue.value != null) {
            ColumnDef.validateDefaultValue(type, this.defaultValue.value, this.defaultValue.defaultValueExprDef);
        }
    }

    public static void validateDefaultValue(Type type, String defaultValue, DefaultValueExprDef defaultValueExprDef) throws AnalysisException {
        Preconditions.checkNotNull((Object)defaultValue);
        Preconditions.checkArgument((boolean)type.isScalarType());
        ScalarType scalarType = (ScalarType)type;
        PrimitiveType primitiveType = scalarType.getPrimitiveType();
        switch (primitiveType) {
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                IntLiteral intLiteral = new IntLiteral(defaultValue, type);
                break;
            }
            case LARGEINT: {
                LargeIntLiteral largeIntLiteral = new LargeIntLiteral(defaultValue);
                break;
            }
            case FLOAT: {
                FloatLiteral floatLiteral = new FloatLiteral(defaultValue);
                if (floatLiteral.getType().equals(Type.DOUBLE)) {
                    throw new AnalysisException("Default value will loose precision: " + defaultValue);
                }
            }
            case DOUBLE: {
                FloatLiteral doubleLiteral = new FloatLiteral(defaultValue);
                break;
            }
            case DECIMALV2: {
                DecimalLiteral decimalLiteral = new DecimalLiteral(defaultValue);
                decimalLiteral.checkPrecisionAndScale(scalarType.getScalarPrecision(), scalarType.getScalarScale());
                break;
            }
            case DATE: 
            case DATETIME: {
                if (defaultValueExprDef == null) {
                    new DateLiteral(defaultValue, type);
                    break;
                }
                if (defaultValueExprDef.getExprName().equals(DefaultValue.NOW)) break;
                throw new AnalysisException("date literal [" + defaultValue + "] is invalid");
            }
            case CHAR: 
            case VARCHAR: 
            case HLL: 
            case STRING: {
                if (defaultValue.length() <= scalarType.getLength()) break;
                throw new AnalysisException("Default value is too long: " + defaultValue);
            }
            case BITMAP: {
                break;
            }
            case ARRAY: {
                break;
            }
            case MAP: {
                break;
            }
            case STRUCT: {
                break;
            }
            case BOOLEAN: {
                BoolLiteral boolLiteral = new BoolLiteral(defaultValue);
                break;
            }
            default: {
                throw new AnalysisException("Unsupported type: " + type);
            }
        }
    }

    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("`").append(this.name).append("` ");
        sb.append(this.typeDef.toSql()).append(" ");
        if (this.aggregateType != null) {
            sb.append(this.aggregateType.name()).append(" ");
        }
        if (!this.isAllowNull) {
            sb.append("NOT NULL ");
        } else {
            sb.append("NULL ");
        }
        if (this.defaultValue.isSet) {
            sb.append("DEFAULT \"").append(this.defaultValue.value).append("\" ");
        }
        sb.append("COMMENT \"").append(this.comment).append("\"");
        return sb.toString();
    }

    public Column toColumn() {
        return new Column(this.name, this.typeDef.getType(), this.isKey, this.aggregateType, this.isAllowNull, this.defaultValue.value, this.comment, this.visible, this.defaultValue.defaultValueExprDef);
    }

    public String toString() {
        return this.toSql();
    }

    public static class DefaultValue {
        public boolean isSet;
        public String value;
        public DefaultValueExprDef defaultValueExprDef;
        public static String CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
        public static String NOW = "now";
        public static DefaultValue CURRENT_TIMESTAMP_DEFAULT_VALUE = new DefaultValue(true, CURRENT_TIMESTAMP, NOW);
        public static DefaultValue NOT_SET = new DefaultValue(false, null);
        public static DefaultValue NULL_DEFAULT_VALUE = new DefaultValue(true, null);
        public static String ZERO = new String(new byte[]{0});
        public static DefaultValue HLL_EMPTY_DEFAULT_VALUE = new DefaultValue(true, ZERO);
        public static DefaultValue BITMAP_EMPTY_DEFAULT_VALUE = new DefaultValue(true, ZERO);

        public DefaultValue(boolean isSet, String value) {
            this.isSet = isSet;
            this.value = value;
            this.defaultValueExprDef = null;
        }

        public DefaultValue(boolean isSet, String value, String exprName) {
            this.isSet = isSet;
            this.value = value;
            this.defaultValueExprDef = new DefaultValueExprDef(exprName);
        }
    }
}

