/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;

public class ClusterName
implements Writable {
    private String cluster;
    private String db;

    public ClusterName(String cluster, String db) {
        this.cluster = cluster;
        this.db = db;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getDb() {
        return this.db;
    }

    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.cluster)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NO_CLUSTER_NAME, new Object[0]);
        }
        if (Strings.isNullOrEmpty((String)this.db)) {
            throw new AnalysisException("db name is null");
        }
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.cluster);
        Text.writeString((DataOutput)out, (String)this.db);
    }

    public void readFields(DataInput in) throws IOException {
        this.cluster = Text.readString((DataInput)in);
        this.db = Text.readString((DataInput)in);
    }
}

