/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChannelDescription
implements Writable {
    private static final Logger LOG = LogManager.getLogger(ChannelDescription.class);
    @SerializedName(value="srcDatabase")
    private final String srcDatabase;
    @SerializedName(value="srcTableName")
    private final String srcTableName;
    @SerializedName(value="targetTable")
    private final String targetTable;
    @SerializedName(value="partitionNames")
    private final PartitionNames partitionNames;
    @SerializedName(value="colNames")
    private final List<String> colNames;
    @SerializedName(value="channelId")
    private long channelId;

    public ChannelDescription(String srcDatabase, String srcTableName, String targetTable, PartitionNames partitionNames, List<String> colNames) {
        this.srcDatabase = srcDatabase;
        this.srcTableName = srcTableName;
        this.targetTable = targetTable;
        this.partitionNames = partitionNames;
        this.colNames = colNames;
    }

    public List<String> getColNames() {
        if (this.colNames == null || this.colNames.isEmpty()) {
            return null;
        }
        return this.colNames;
    }

    public void analyze(String fullDbName) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.srcDatabase)) {
            throw new AnalysisException("No source database in channel description.");
        }
        if (Strings.isNullOrEmpty((String)this.srcTableName)) {
            throw new AnalysisException("No source table in channel description.");
        }
        this.checkAuth(fullDbName);
        if (this.partitionNames != null) {
            this.partitionNames.analyze(null);
        }
        this.analyzeColumns();
    }

    private void checkAuth(String fullDbName) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.targetTable)) {
            throw new AnalysisException("No target table is assigned in channel description.");
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), fullDbName, this.targetTable, PrivPredicate.LOAD)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "LOAD", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), fullDbName + ": " + this.targetTable);
        }
    }

    private void analyzeColumns() throws AnalysisException {
        TreeSet<String> columnNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (this.colNames != null && !this.colNames.isEmpty()) {
            for (String columnName : this.colNames) {
                if (columnNames.add(columnName)) continue;
                throw new AnalysisException("Duplicate column: " + columnName);
            }
        }
    }

    public void setChannelId(long channelId) {
        this.channelId = channelId;
    }

    public long getChannelId() {
        return this.channelId;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public String getSrcDatabase() {
        return this.srcDatabase;
    }

    public String getSrcTableName() {
        return this.srcTableName;
    }

    public PartitionNames getPartitionNames() {
        return this.partitionNames;
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static ChannelDescription read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (ChannelDescription)GsonUtils.GSON.fromJson(json, ChannelDescription.class);
    }
}

