/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.DecimalLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FloatLiteral;
import org.apache.doris.analysis.FunctionName;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LargeIntLiteral;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.analysis.TypeDef;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.FunctionSet;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarFunction;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Pair;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.thrift.TExpr;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;
import org.apache.doris.thrift.TExprOpcode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CastExpr
extends Expr {
    private static final Logger LOG = LogManager.getLogger(CastExpr.class);
    private TypeDef targetTypeDef;
    private boolean isImplicit;
    private boolean noOp = false;
    private static final Map<Pair<Type, Type>, Function.NullableMode> TYPE_NULLABLE_MODE = Maps.newHashMap();

    public CastExpr() {
    }

    public CastExpr(Type targetType, Expr e) {
        Preconditions.checkArgument((boolean)targetType.isValid());
        Preconditions.checkNotNull((Object)e);
        this.type = targetType;
        this.targetTypeDef = null;
        this.isImplicit = true;
        this.children.add(e);
        if (this.isImplicit) {
            try {
                this.analyze();
            }
            catch (AnalysisException ex) {
                LOG.warn("Implicit casts fail", (Throwable)ex);
                Preconditions.checkState((boolean)false, (Object)"Implicit casts should never throw analysis exception.");
            }
            this.analysisDone();
        }
    }

    public CastExpr(TypeDef targetTypeDef, Expr e) {
        Preconditions.checkNotNull((Object)targetTypeDef);
        Preconditions.checkNotNull((Object)e);
        this.targetTypeDef = targetTypeDef;
        this.isImplicit = false;
        this.children.add(e);
    }

    protected CastExpr(CastExpr other) {
        super(other);
        this.targetTypeDef = other.targetTypeDef;
        this.isImplicit = other.isImplicit;
        this.noOp = other.noOp;
    }

    private static String getFnName(Type targetType) {
        return "castTo" + targetType.getPrimitiveType().toString();
    }

    public TypeDef getTargetTypeDef() {
        return this.targetTypeDef;
    }

    private static boolean disableRegisterCastingFunction(Type fromType, Type toType) {
        if (fromType.isBoolean() && (toType.equals(Type.DECIMALV2) || toType.equals(Type.DATETIME) || toType.equals(Type.DATE))) {
            return true;
        }
        if (fromType.isObjectStored() || toType.isObjectStored()) {
            return true;
        }
        return fromType.equals(toType);
    }

    public static void initBuiltins(FunctionSet functionSet) {
        for (Type type : Type.getSupportedTypes()) {
            if (type.isNull()) continue;
            for (Type type2 : Type.getSupportedTypes()) {
                String beClass;
                if (type2.isNull() || CastExpr.disableRegisterCastingFunction(type, type2)) continue;
                String string = beClass = type2.isDecimalV2() || type.isDecimalV2() ? "DecimalV2Operators" : "CastFunctions";
                if (type.isTime()) {
                    beClass = "TimeOperators";
                }
                String typeName = Function.getUdfTypeName(type2.getPrimitiveType());
                if (type2.getPrimitiveType() == PrimitiveType.DATE) {
                    typeName = "date_val";
                }
                String beSymbol = "doris::" + beClass + "::cast_to_" + typeName;
                functionSet.addBuiltinBothScalaAndVectorized(ScalarFunction.createBuiltin(CastExpr.getFnName(type2), type2, TYPE_NULLABLE_MODE.get(new Pair<Type, Type>(type, type2)), Lists.newArrayList((Object[])new Type[]{type}), false, beSymbol, null, null, true));
            }
        }
    }

    @Override
    public Expr clone() {
        return new CastExpr(this);
    }

    @Override
    public String toSqlImpl() {
        boolean isVerbose;
        boolean bl = isVerbose = ConnectContext.get() != null && ConnectContext.get().getExecutor() != null && ConnectContext.get().getExecutor().getParsedStmt() != null && ConnectContext.get().getExecutor().getParsedStmt().getExplainOptions() != null && ConnectContext.get().getExecutor().getParsedStmt().getExplainOptions().isVerbose();
        if (this.isImplicit && !isVerbose) {
            return ((Expr)this.getChild(0)).toSql();
        }
        if (this.isAnalyzed) {
            if (this.type.isStringType()) {
                return "CAST(" + ((Expr)this.getChild(0)).toSql() + " AS CHARACTER)";
            }
            return "CAST(" + ((Expr)this.getChild(0)).toSql() + " AS " + this.type.toString() + ")";
        }
        return "CAST(" + ((Expr)this.getChild(0)).toSql() + " AS " + this.targetTypeDef.toSql() + ")";
    }

    @Override
    protected void treeToThriftHelper(TExpr container) {
        if (this.noOp) {
            ((Expr)this.getChild(0)).treeToThriftHelper(container);
            return;
        }
        super.treeToThriftHelper(container);
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.CAST_EXPR;
        msg.setOpcode(this.opcode);
        msg.setOutputColumn(this.outputColumn);
        if (this.type.isNativeType() && ((Expr)this.getChild(0)).getType().isNativeType()) {
            msg.setChildType(((Expr)this.getChild(0)).getType().getPrimitiveType().toThrift());
        }
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    public void setImplicit(boolean implicit) {
        this.isImplicit = implicit;
    }

    public void analyze() throws AnalysisException {
        if (this.type == Type.ALL) {
            return;
        }
        Type childType = ((Expr)this.getChild(0)).getType();
        if (childType.matchesType(this.type)) {
            this.noOp = true;
            return;
        }
        this.opcode = TExprOpcode.CAST;
        FunctionName fnName = new FunctionName(CastExpr.getFnName(this.type));
        Function searchDesc = new Function(fnName, Arrays.asList(this.collectChildReturnTypes()), Type.INVALID, false);
        this.fn = this.isImplicit ? Catalog.getCurrentCatalog().getFunction(searchDesc, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF) : Catalog.getCurrentCatalog().getFunction(searchDesc, Function.CompareMode.IS_IDENTICAL);
        if (this.fn == null) {
            throw new AnalysisException("Invalid type cast of " + ((Expr)this.getChild(0)).toSql() + " from " + childType + " to " + this.type);
        }
        Preconditions.checkState((boolean)this.type.matchesType(this.fn.getReturnType()), (Object)(this.type + " != " + this.fn.getReturnType()));
    }

    @Override
    public void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        if (this.isImplicit) {
            return;
        }
        if (this.targetTypeDef.getType().isScalarType()) {
            ScalarType targetType = (ScalarType)this.targetTypeDef.getType();
            if (!targetType.getPrimitiveType().isStringType() || targetType.isAssignedStrLenInColDefinition()) {
                this.targetTypeDef.analyze(analyzer);
            }
        } else {
            this.targetTypeDef.analyze(analyzer);
        }
        this.type = this.targetTypeDef.getType();
        this.analyze();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CastExpr expr = (CastExpr)obj;
        return this.opcode == expr.opcode;
    }

    @Override
    public Expr ignoreImplicitCast() {
        if (this.isImplicit) {
            Preconditions.checkState((!(this.getChild(0) instanceof CastExpr) || !((CastExpr)this.getChild(0)).isImplicit() ? 1 : 0) != 0);
            return (Expr)this.getChild(0);
        }
        return this;
    }

    public boolean canHashPartition() {
        if (this.type.isFixedPointType() && ((Expr)this.getChild(0)).getType().isFixedPointType()) {
            return true;
        }
        return this.type.isDateType() && ((Expr)this.getChild(0)).getType().isDateType();
    }

    @Override
    public Expr getResultValue() throws AnalysisException {
        Expr targetExpr;
        this.recursiveResetChildrenResult();
        Expr value = (Expr)this.children.get(0);
        if (!(value instanceof LiteralExpr)) {
            return this;
        }
        try {
            targetExpr = this.castTo((LiteralExpr)value);
        }
        catch (AnalysisException ae) {
            targetExpr = this;
        }
        catch (NumberFormatException nfe) {
            targetExpr = new NullLiteral();
        }
        return targetExpr;
    }

    private Expr castTo(LiteralExpr value) throws AnalysisException {
        if (value instanceof NullLiteral) {
            return value;
        }
        if (this.type.isIntegerType()) {
            return new IntLiteral(value.getLongValue(), this.type);
        }
        if (this.type.isLargeIntType()) {
            return new LargeIntLiteral(value.getStringValue());
        }
        if (this.type.isDecimalV2()) {
            return new DecimalLiteral(value.getStringValue());
        }
        if (this.type.isFloatingPointType()) {
            return new FloatLiteral(value.getDoubleValue(), this.type);
        }
        if (this.type.isStringType()) {
            return new StringLiteral(value.getStringValue());
        }
        if (this.type.isDateType()) {
            return new StringLiteral(value.getStringValue()).convertToDate(this.type);
        }
        if (this.type.isBoolean()) {
            return new BoolLiteral(value.getStringValue());
        }
        return this;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.isImplicit);
        if (!(this.targetTypeDef.getType() instanceof ScalarType)) {
            throw new IOException("Can not write type " + this.targetTypeDef.getType());
        }
        ScalarType scalarType = (ScalarType)this.targetTypeDef.getType();
        scalarType.write(out);
        out.writeInt(this.children.size());
        for (Expr expr : this.children) {
            Expr.writeTo(expr, out);
        }
    }

    public static CastExpr read(DataInput input) throws IOException {
        CastExpr castExpr = new CastExpr();
        castExpr.readFields(input);
        return castExpr;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.isImplicit = in.readBoolean();
        ScalarType scalarType = ScalarType.read(in);
        this.targetTypeDef = new TypeDef(scalarType);
        int counter = in.readInt();
        for (int i = 0; i < counter; ++i) {
            this.children.add(Expr.readIn(in));
        }
    }

    public CastExpr rewriteExpr(List<String> parameters, List<Expr> inputParamsExprs) throws AnalysisException {
        String columnName;
        int index;
        Expr child = (Expr)this.getChild(0);
        Expr newChild = null;
        if (child instanceof SlotRef && (index = parameters.indexOf(columnName = ((SlotRef)child).getColumnName())) != -1) {
            newChild = inputParamsExprs.get(index);
        }
        if (child instanceof CastExpr) {
            newChild = ((CastExpr)child).rewriteExpr(parameters, inputParamsExprs);
        }
        ScalarType targetType = (ScalarType)this.targetTypeDef.getType();
        PrimitiveType primitiveType = targetType.getPrimitiveType();
        ScalarType newTargetType = null;
        switch (primitiveType) {
            case DECIMALV2: {
                if (targetType.getPrecision() != 0) {
                    newTargetType = targetType;
                    break;
                }
                int precision = this.getDigital(targetType.getScalarPrecisionStr(), parameters, inputParamsExprs);
                int scale = this.getDigital(targetType.getScalarScaleStr(), parameters, inputParamsExprs);
                if (precision != -1 && scale != -1) {
                    newTargetType = ScalarType.createType(primitiveType, 0, precision, scale);
                    break;
                }
                if (precision == -1 || scale != -1) break;
                newTargetType = ScalarType.createType(primitiveType, 0, precision, 0);
                break;
            }
            case CHAR: 
            case VARCHAR: {
                if (targetType.getLength() != -1) {
                    newTargetType = targetType;
                    break;
                }
                int len = this.getDigital(targetType.getLenStr(), parameters, inputParamsExprs);
                if (len != -1) {
                    newTargetType = ScalarType.createType(primitiveType, len, 0, 0);
                }
                if (len != -1 || targetType.getLength() != -1) break;
                newTargetType = targetType;
                break;
            }
            default: {
                newTargetType = targetType;
            }
        }
        if (newTargetType != null && newChild != null) {
            TypeDef typeDef = new TypeDef(newTargetType);
            return new CastExpr(typeDef, newChild);
        }
        return this;
    }

    private int getDigital(String desc, List<String> parameters, List<Expr> inputParamsExprs) {
        Expr expr;
        int index = parameters.indexOf(desc);
        if (index != -1 && (expr = inputParamsExprs.get(index)).getType().isIntegerType()) {
            return ((Long)((IntLiteral)expr).getRealValue()).intValue();
        }
        return -1;
    }

    @Override
    public boolean isNullable() {
        return ((Expr)this.children.get(0)).isNullable() || ((Expr)this.children.get(0)).getType().isStringType() && !this.getType().isStringType() || !((Expr)this.children.get(0)).getType().isDateType() && this.getType().isDateType();
    }

    static {
        for (ScalarType fromType : Type.getSupportedTypes()) {
            if (fromType.isNull()) continue;
            for (ScalarType toType : Type.getSupportedTypes()) {
                if (fromType.isNull()) continue;
                if (fromType.isStringType() && !toType.isStringType()) {
                    TYPE_NULLABLE_MODE.put(new Pair<ScalarType, ScalarType>(fromType, toType), Function.NullableMode.ALWAYS_NULLABLE);
                    continue;
                }
                if (!fromType.isDateType() && toType.isDateType()) {
                    TYPE_NULLABLE_MODE.put(new Pair<ScalarType, ScalarType>(fromType, toType), Function.NullableMode.ALWAYS_NULLABLE);
                    continue;
                }
                TYPE_NULLABLE_MODE.put(new Pair<ScalarType, ScalarType>(fromType, toType), Function.NullableMode.DEPEND_ON_ARGUMENT);
            }
        }
    }
}

