/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.CaseWhenClause;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.DecimalLiteral;
import org.apache.doris.analysis.ExistsPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FloatLiteral;
import org.apache.doris.analysis.InPredicate;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.Subquery;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.thrift.TCaseExpr;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;

public class CaseExpr
extends Expr {
    private boolean hasCaseExpr;
    private boolean hasElseExpr;

    public CaseExpr(Expr caseExpr, List<CaseWhenClause> whenClauses, Expr elseExpr) {
        if (caseExpr != null) {
            this.children.add(caseExpr);
            this.hasCaseExpr = true;
        }
        for (CaseWhenClause whenClause : whenClauses) {
            Preconditions.checkNotNull((Object)whenClause.getWhenExpr());
            this.children.add(whenClause.getWhenExpr());
            Preconditions.checkNotNull((Object)whenClause.getThenExpr());
            this.children.add(whenClause.getThenExpr());
        }
        if (elseExpr != null) {
            this.children.add(elseExpr);
            this.hasElseExpr = true;
        }
    }

    protected CaseExpr(CaseExpr other) {
        super(other);
        this.hasCaseExpr = other.hasCaseExpr;
        this.hasElseExpr = other.hasElseExpr;
    }

    @Override
    public Expr clone() {
        return new CaseExpr(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CaseExpr expr = (CaseExpr)obj;
        return this.hasCaseExpr == expr.hasCaseExpr && this.hasElseExpr == expr.hasElseExpr;
    }

    public boolean hasCaseExpr() {
        return this.hasCaseExpr;
    }

    @Override
    public String toSqlImpl() {
        StringBuilder output = new StringBuilder("CASE");
        int childIdx = 0;
        if (this.hasCaseExpr) {
            output.append(' ').append(((Expr)this.children.get(childIdx++)).toSql());
        }
        while (childIdx + 2 <= this.children.size()) {
            output.append(" WHEN " + ((Expr)this.children.get(childIdx++)).toSql());
            output.append(" THEN " + ((Expr)this.children.get(childIdx++)).toSql());
        }
        if (this.hasElseExpr) {
            output.append(" ELSE " + ((Expr)this.children.get(this.children.size() - 1)).toSql());
        }
        output.append(" END");
        return output.toString();
    }

    @Override
    public boolean isVectorized() {
        return false;
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.CASE_EXPR;
        msg.case_expr = new TCaseExpr(this.hasCaseExpr, this.hasElseExpr);
    }

    @Override
    public void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        int i;
        int loopStart;
        Type whenType = null;
        Type returnType = null;
        Expr lastCompatibleThenExpr = null;
        Expr lastCompatibleWhenExpr = null;
        int loopEnd = this.children.size();
        if (this.hasElseExpr) {
            --loopEnd;
        }
        Expr caseExpr = null;
        if (this.hasCaseExpr) {
            loopStart = 1;
            caseExpr = (Expr)this.children.get(0);
            caseExpr.analyze(analyzer);
            if (caseExpr instanceof Subquery && !caseExpr.getType().isScalarType()) {
                throw new AnalysisException("Subquery in case-when must return scala type");
            }
            whenType = caseExpr.getType();
            lastCompatibleWhenExpr = (Expr)this.children.get(0);
        } else {
            whenType = Type.BOOLEAN;
            loopStart = 0;
        }
        for (i = loopStart; i < loopEnd; i += 2) {
            Expr whenExpr = (Expr)this.children.get(i);
            if (this.hasCaseExpr) {
                whenType = analyzer.getCompatibleType(whenType, lastCompatibleWhenExpr, whenExpr);
                lastCompatibleWhenExpr = whenExpr;
            } else {
                if (!Type.canCastTo(whenExpr.getType(), Type.BOOLEAN)) {
                    throw new AnalysisException("When expr '" + whenExpr.toSql() + "' is not of type boolean and not castable to type boolean.");
                }
                if (!whenExpr.getType().isBoolean()) {
                    this.castChild(Type.BOOLEAN, i);
                }
            }
            if (whenExpr instanceof Subquery && !whenExpr.getType().isScalarType()) {
                throw new AnalysisException("Subquery in case-when must return scala type");
            }
            if (whenExpr.contains(Predicates.instanceOf(Subquery.class)) && (!this.hasCaseExpr() || !(whenExpr instanceof Subquery)) && this.checkSubquery(whenExpr)) {
                throw new AnalysisException("Only support subquery in binary predicate in case statement.");
            }
            Expr thenExpr = (Expr)this.children.get(i + 1);
            if (thenExpr instanceof Subquery && !thenExpr.getType().isScalarType()) {
                throw new AnalysisException("Subquery in case-when must return scala type");
            }
            returnType = analyzer.getCompatibleType(returnType, lastCompatibleThenExpr, thenExpr);
            lastCompatibleThenExpr = thenExpr;
        }
        if (this.hasElseExpr) {
            Expr elseExpr = (Expr)this.children.get(this.children.size() - 1);
            if (elseExpr instanceof Subquery && !elseExpr.getType().isScalarType()) {
                throw new AnalysisException("Subquery in case-when must return scala type");
            }
            returnType = analyzer.getCompatibleType(returnType, lastCompatibleThenExpr, elseExpr);
        }
        if (this.hasCaseExpr) {
            if (!((Expr)this.children.get(0)).getType().equals(whenType)) {
                this.castChild(whenType, 0);
            }
            for (i = loopStart; i < loopEnd; i += 2) {
                if (((Expr)this.children.get(i)).getType().equals(whenType)) continue;
                this.castChild(whenType, i);
            }
        }
        for (i = loopStart + 1; i < this.children.size(); i += 2) {
            if (((Expr)this.children.get(i)).getType().equals(returnType)) continue;
            this.castChild(returnType, i);
        }
        if (this.hasElseExpr && !((Expr)this.children.get(this.children.size() - 1)).getType().equals(returnType)) {
            this.castChild(returnType, this.children.size() - 1);
        }
        this.type = returnType;
    }

    public List<Expr> getConditionExprs() {
        ArrayList exprs = Lists.newArrayList();
        int childIdx = 0;
        if (this.hasCaseExpr) {
            exprs.add((Expr)this.children.get(childIdx++));
        }
        while (childIdx + 2 <= this.children.size()) {
            exprs.add((Expr)this.children.get(childIdx++));
            ++childIdx;
        }
        return exprs;
    }

    public List<Expr> getReturnExprs() {
        ArrayList exprs = Lists.newArrayList();
        int childIdx = 0;
        if (this.hasCaseExpr) {
            ++childIdx;
        }
        while (childIdx + 2 <= this.children.size()) {
            int n = ++childIdx;
            ++childIdx;
            exprs.add((Expr)this.children.get(n));
        }
        if (this.hasElseExpr) {
            exprs.add((Expr)this.children.get(this.children.size() - 1));
        }
        return exprs;
    }

    public static Expr computeCaseExpr(CaseExpr expr) {
        Expr startExpr;
        LiteralExpr caseExpr;
        int startIndex = 0;
        int endIndex = expr.getChildren().size();
        for (Expr child : expr.getChildren()) {
            if (!(child instanceof CastExpr) || !child.contains(SlotRef.class)) continue;
            ArrayList castExprList = Lists.newArrayList();
            child.collect(CastExpr.class, castExprList);
            for (CastExpr castExpr : castExprList) {
                castExpr.resetAnalysisState();
            }
        }
        if (expr.hasCaseExpr()) {
            Expr caseChildExpr = (Expr)expr.getChild(0);
            if (!caseChildExpr.isLiteral() || caseChildExpr instanceof DecimalLiteral || caseChildExpr instanceof FloatLiteral) {
                return expr;
            }
            caseExpr = (LiteralExpr)expr.getChild(0);
            ++startIndex;
        } else {
            caseExpr = new BoolLiteral(true);
        }
        if (caseExpr instanceof NullLiteral) {
            if (expr.hasElseExpr) {
                return (Expr)expr.getChild(expr.getChildren().size() - 1);
            }
            return new NullLiteral();
        }
        if (expr.hasElseExpr) {
            --endIndex;
        }
        if (!(startExpr = (Expr)expr.getChild(startIndex)).isLiteral() || startExpr instanceof DecimalLiteral || startExpr instanceof FloatLiteral || !(startExpr instanceof NullLiteral) && !startExpr.getClass().toString().equals(caseExpr.getClass().toString())) {
            return expr;
        }
        for (int i = startIndex; i < endIndex; i += 2) {
            Expr currentWhenExpr = (Expr)expr.getChild(i);
            if (currentWhenExpr instanceof NullLiteral) continue;
            if (!currentWhenExpr.isLiteral() || currentWhenExpr instanceof DecimalLiteral || currentWhenExpr instanceof FloatLiteral || !currentWhenExpr.getClass().toString().equals(caseExpr.getClass().toString())) {
                ArrayList<Expr> exprLeft = new ArrayList<Expr>();
                if (expr.hasCaseExpr()) {
                    exprLeft.add(caseExpr);
                }
                for (int j = i; j < expr.getChildren().size(); ++j) {
                    exprLeft.add((Expr)expr.getChild(j));
                }
                Expr retCaseExpr = expr.clone();
                retCaseExpr.getChildren().clear();
                retCaseExpr.addChildren(exprLeft);
                return retCaseExpr;
            }
            if (caseExpr.compareLiteral((LiteralExpr)currentWhenExpr) != 0) continue;
            return (Expr)expr.getChild(i + 1);
        }
        if (expr.hasElseExpr) {
            return (Expr)expr.getChild(expr.getChildren().size() - 1);
        }
        return new NullLiteral();
    }

    private boolean checkSubquery(Expr expr) {
        for (Expr child : expr.getChildren()) {
            if (child instanceof Subquery && (expr instanceof ExistsPredicate || expr instanceof InPredicate)) {
                return true;
            }
            if (!this.checkSubquery(child)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNullable() {
        int loopEnd = this.children.size();
        int loopStart = this.hasCaseExpr ? 2 : 1;
        if (this.hasElseExpr) {
            --loopEnd;
        }
        for (int i = loopStart; i < loopEnd; i += 2) {
            Expr thenExpr = (Expr)this.children.get(i);
            if (!thenExpr.isNullable()) continue;
            return true;
        }
        if (this.hasElseExpr) {
            return ((Expr)this.children.get(this.children.size() - 1)).isNullable();
        }
        return true;
    }
}

