/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LikePredicate;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;

public class CancelLoadStmt
extends DdlStmt {
    private String dbName;
    private String label;
    private Expr whereClause;
    private boolean isAccurateMatch;

    public String getDbName() {
        return this.dbName;
    }

    public String getLabel() {
        return this.label;
    }

    public CancelLoadStmt(String dbName, Expr whereClause) {
        this.dbName = dbName;
        this.whereClause = whereClause;
        this.isAccurateMatch = false;
    }

    public boolean isAccurateMatch() {
        return this.isAccurateMatch;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        boolean valid;
        block14: {
            block16: {
                block17: {
                    block15: {
                        block13: {
                            super.analyze(analyzer);
                            if (Strings.isNullOrEmpty((String)this.dbName)) {
                                this.dbName = analyzer.getDefaultDb();
                                if (Strings.isNullOrEmpty((String)this.dbName)) {
                                    throw new AnalysisException("No database selected");
                                }
                            } else {
                                this.dbName = ClusterNamespace.getFullName(this.getClusterName(), this.dbName);
                            }
                            valid = true;
                            if (this.whereClause != null) break block13;
                            valid = false;
                            break block14;
                        }
                        if (!(this.whereClause instanceof BinaryPredicate)) break block15;
                        BinaryPredicate binaryPredicate = (BinaryPredicate)this.whereClause;
                        this.isAccurateMatch = true;
                        if (binaryPredicate.getOp() == BinaryPredicate.Operator.EQ) break block16;
                        valid = false;
                        break block14;
                    }
                    if (!(this.whereClause instanceof LikePredicate)) break block17;
                    LikePredicate likePredicate = (LikePredicate)this.whereClause;
                    if (likePredicate.getOp() == LikePredicate.Operator.LIKE) break block16;
                    valid = false;
                    break block14;
                }
                valid = false;
                break block14;
            }
            if (!(this.whereClause.getChild(0) instanceof SlotRef)) {
                valid = false;
            } else if (!((SlotRef)this.whereClause.getChild(0)).getColumnName().equalsIgnoreCase("label")) {
                valid = false;
            } else if (!(this.whereClause.getChild(1) instanceof StringLiteral)) {
                valid = false;
            } else {
                this.label = ((StringLiteral)this.whereClause.getChild(1)).getStringValue();
                if (Strings.isNullOrEmpty((String)this.label)) {
                    valid = false;
                } else if (!this.isAccurateMatch && !this.label.contains("%")) {
                    this.label = "%" + this.label + "%";
                }
            }
        }
        if (!valid) {
            throw new AnalysisException("Where clause should looks like: LABEL = \"your_load_label\", or LABEL LIKE \"matcher\"");
        }
    }

    @Override
    public String toSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CANCEL LOAD ");
        if (!Strings.isNullOrEmpty((String)this.dbName)) {
            stringBuilder.append("FROM " + this.dbName);
        }
        if (this.whereClause != null) {
            stringBuilder.append(" WHERE " + this.whereClause.toSql());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

