/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.CancelStmt;
import org.apache.doris.analysis.ShowAlterStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class CancelAlterTableStmt
extends CancelStmt {
    private ShowAlterStmt.AlterType alterType;
    private TableName dbTableName;
    private List<Long> alterJobIdList;

    public ShowAlterStmt.AlterType getAlterType() {
        return this.alterType;
    }

    public String getDbName() {
        return this.dbTableName.getDb();
    }

    public String getTableName() {
        return this.dbTableName.getTbl();
    }

    public CancelAlterTableStmt(ShowAlterStmt.AlterType alterType, TableName dbTableName) {
        this(alterType, dbTableName, null);
    }

    public CancelAlterTableStmt(ShowAlterStmt.AlterType alterType, TableName dbTableName, List<Long> alterJobIdList) {
        this.alterType = alterType;
        this.dbTableName = dbTableName;
        this.alterJobIdList = alterJobIdList;
    }

    public List<Long> getAlterJobIdList() {
        return this.alterJobIdList;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.dbTableName.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.dbTableName.getDb(), this.dbTableName.getTbl(), PrivPredicate.ALTER)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "CANCEL ALTER TABLE", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), this.dbTableName.getDb() + ": " + this.dbTableName.getTbl());
        }
    }

    @Override
    public String toSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CANCEL ALTER " + (Object)((Object)this.alterType));
        stringBuilder.append(" FROM " + this.dbTableName.toSql());
        if (!CollectionUtils.isEmpty(this.alterJobIdList)) {
            stringBuilder.append(" (").append(String.join((CharSequence)",", this.alterJobIdList.stream().map(String::valueOf).collect(Collectors.toList())));
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

