/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.CancelStmt;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Pair;
import org.apache.doris.system.SystemInfoService;

public class CancelAlterSystemStmt
extends CancelStmt {
    protected List<String> hostPorts;
    private List<Pair<String, Integer>> hostPortPairs;

    public CancelAlterSystemStmt(List<String> hostPorts) {
        this.hostPorts = hostPorts;
        this.hostPortPairs = new LinkedList<Pair<String, Integer>>();
    }

    public List<Pair<String, Integer>> getHostPortPairs() {
        return this.hostPortPairs;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        for (String hostPort : this.hostPorts) {
            Pair<String, Integer> pair = SystemInfoService.validateHostAndPort(hostPort);
            this.hostPortPairs.add(pair);
        }
        Preconditions.checkState((!this.hostPortPairs.isEmpty() ? 1 : 0) != 0);
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("CANCEL DECOMMISSION BACKEND ");
        for (int i = 0; i < this.hostPorts.size(); ++i) {
            sb.append("\"").append(this.hostPorts.get(i)).append("\"");
            if (i == this.hostPorts.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

