/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.apache.doris.analysis.FunctionName;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.thrift.TAggregateFunction;
import org.apache.doris.thrift.TAggregationOp;
import org.apache.doris.thrift.TFunction;
import org.apache.doris.thrift.TFunctionBinaryType;

public class BuiltinAggregateFunction
extends Function {
    private final Operator op_;
    private boolean isAnalyticFn = false;
    private Type intermediateType_;
    private boolean reqIntermediateTuple = false;

    public boolean isAnalyticFn() {
        return this.isAnalyticFn;
    }

    public boolean isReqIntermediateTuple() {
        return this.reqIntermediateTuple;
    }

    public BuiltinAggregateFunction(Operator op, ArrayList<Type> argTypes, Type retType, Type intermediateType, boolean isAnalyticFn) throws AnalysisException {
        super(FunctionName.createBuiltinName(op.toString()), argTypes, retType, false);
        Preconditions.checkState((intermediateType != null ? 1 : 0) != 0);
        Preconditions.checkState((op != null ? 1 : 0) != 0);
        this.op_ = op;
        this.intermediateType_ = intermediateType;
        if (isAnalyticFn && !intermediateType.equals(retType)) {
            this.reqIntermediateTuple = true;
        }
        this.setBinaryType(TFunctionBinaryType.BUILTIN);
        this.isAnalyticFn = isAnalyticFn;
    }

    @Override
    public TFunction toThrift() {
        TFunction fn = super.toThrift();
        if (this.op_ == Operator.FIRST_VALUE_REWRITE) {
            fn.setId(0L);
        } else {
            fn.setId((long)this.op_.thriftOp.ordinal());
        }
        fn.setAggregateFn(new TAggregateFunction(this.intermediateType_.toThrift()));
        return fn;
    }

    public Operator op() {
        return this.op_;
    }

    public Type getIntermediateType() {
        return this.intermediateType_;
    }

    public void setIntermediateType(Type t) {
        this.intermediateType_ = t;
    }

    public static enum Operator {
        COUNT("COUNT", TAggregationOp.COUNT, Type.BIGINT),
        MIN("MIN", TAggregationOp.MIN, null),
        MAX("MAX", TAggregationOp.MAX, null),
        DISTINCT_PC("DISTINCT_PC", TAggregationOp.DISTINCT_PC, ScalarType.createVarcharType(64)),
        DISTINCT_PCSA("DISTINCT_PCSA", TAggregationOp.DISTINCT_PCSA, ScalarType.createVarcharType(64)),
        SUM("SUM", TAggregationOp.SUM, null),
        AVG("AVG", TAggregationOp.INVALID, null),
        GROUP_CONCAT("GROUP_CONCAT", TAggregationOp.GROUP_CONCAT, ScalarType.createVarcharType(16)),
        NDV("NDV", TAggregationOp.HLL, ScalarType.createVarcharType(64)),
        HLL_UNION_AGG("HLL_UNION_AGG", TAggregationOp.HLL_C, ScalarType.createVarcharType(64)),
        BITMAP_UNION("BITMAP_UNION", TAggregationOp.BITMAP_UNION, ScalarType.createVarcharType(10)),
        COUNT_DISTINCT("COUNT_DISTINCT", TAggregationOp.COUNT_DISTINCT, Type.BIGINT),
        SUM_DISTINCT("SUM_DISTINCT", TAggregationOp.SUM_DISTINCT, null),
        LAG("LAG", TAggregationOp.LAG, null),
        FIRST_VALUE("FIRST_VALUE", TAggregationOp.FIRST_VALUE, null),
        LAST_VALUE("LAST_VALUE", TAggregationOp.LAST_VALUE, null),
        RANK("RANK", TAggregationOp.RANK, null),
        DENSE_RANK("DENSE_RANK", TAggregationOp.DENSE_RANK, null),
        ROW_NUMBER("ROW_NUMBER", TAggregationOp.ROW_NUMBER, null),
        LEAD("LEAD", TAggregationOp.LEAD, null),
        FIRST_VALUE_REWRITE("FIRST_VALUE_REWRITE", null, null);

        private final String description;
        private final TAggregationOp thriftOp;
        private final Type intermediateType;

        private Operator(String description, TAggregationOp thriftOp, Type intermediateType) {
            this.description = description;
            this.thriftOp = thriftOp;
            this.intermediateType = intermediateType;
        }

        public String toString() {
            return this.description;
        }

        public TAggregationOp toThrift() {
            return this.thriftOp;
        }

        public Type intermediateType() {
            return this.intermediateType;
        }
    }
}

