/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.analysis.StorageDesc;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.thrift.TFileType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrokerDesc
extends StorageDesc
implements Writable {
    private static final Logger LOG = LogManager.getLogger(BrokerDesc.class);
    public static final String MULTI_LOAD_BROKER = "__DORIS_MULTI_LOAD_BROKER__";
    public static final String MULTI_LOAD_BROKER_BACKEND_KEY = "__DORIS_MULTI_LOAD_BROKER_BACKEND__";

    private BrokerDesc() {
        this.properties = Maps.newHashMap();
        this.storageType = StorageBackend.StorageType.BROKER;
    }

    public BrokerDesc(String name, Map<String, String> properties) {
        this.name = name;
        this.properties = properties;
        if (this.properties == null) {
            this.properties = Maps.newHashMap();
        }
        this.storageType = this.isMultiLoadBroker() ? StorageBackend.StorageType.LOCAL : StorageBackend.StorageType.BROKER;
        this.tryConvertToS3();
    }

    public BrokerDesc(String name, StorageBackend.StorageType storageType, Map<String, String> properties) {
        this.name = name;
        this.properties = properties;
        if (this.properties == null) {
            this.properties = Maps.newHashMap();
        }
        this.storageType = storageType;
        this.tryConvertToS3();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public StorageBackend.StorageType getStorageType() {
        return this.storageType;
    }

    public boolean isMultiLoadBroker() {
        return this.name.equalsIgnoreCase(MULTI_LOAD_BROKER);
    }

    public TFileType getFileType() {
        if (this.storageType == StorageBackend.StorageType.LOCAL) {
            return TFileType.FILE_LOCAL;
        }
        if (this.storageType == StorageBackend.StorageType.BROKER) {
            return TFileType.FILE_BROKER;
        }
        if (this.storageType == StorageBackend.StorageType.S3) {
            return TFileType.FILE_S3;
        }
        if (this.storageType == StorageBackend.StorageType.HDFS) {
            return TFileType.FILE_HDFS;
        }
        return TFileType.FILE_BROKER;
    }

    public StorageBackend.StorageType storageType() {
        return this.storageType;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.name);
        this.properties.put("_DORIS_STORAGE_TYPE_", this.storageType.name());
        out.writeInt(this.properties.size());
        for (Map.Entry entry : this.properties.entrySet()) {
            Text.writeString((DataOutput)out, (String)((String)entry.getKey()));
            Text.writeString((DataOutput)out, (String)((String)entry.getValue()));
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.name = Text.readString((DataInput)in);
        int size = in.readInt();
        this.properties = Maps.newHashMap();
        for (int i = 0; i < size; ++i) {
            String key = Text.readString((DataInput)in);
            String val = Text.readString((DataInput)in);
            this.properties.put(key, val);
        }
        StorageBackend.StorageType st = StorageBackend.StorageType.BROKER;
        String typeStr = (String)this.properties.remove("_DORIS_STORAGE_TYPE_");
        if (typeStr != null) {
            try {
                st = StorageBackend.StorageType.valueOf(typeStr);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("set to BROKER, because of exception", (Throwable)e);
            }
        }
        this.storageType = st;
    }

    public static BrokerDesc read(DataInput in) throws IOException {
        BrokerDesc desc = new BrokerDesc();
        desc.readFields(in);
        return desc;
    }

    public String toSql() {
        StringBuilder sb = new StringBuilder();
        if (this.storageType == StorageBackend.StorageType.BROKER) {
            sb.append("WITH BROKER ").append(this.name);
        } else {
            sb.append("WITH ").append(this.storageType.name());
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            PrintableMap printableMap = new PrintableMap(this.properties, " = ", true, false, true);
            sb.append(" (").append(printableMap.toString()).append(")");
        }
        return sb.toString();
    }
}

