/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.MaxLiteral;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.thrift.TBoolLiteral;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;

public class BoolLiteral
extends LiteralExpr {
    private boolean value;

    private BoolLiteral() {
    }

    public BoolLiteral(boolean value) {
        this.setValue(value);
        this.type = Type.BOOLEAN;
    }

    public BoolLiteral(String value) throws AnalysisException {
        this.type = Type.BOOLEAN;
        if (value.trim().toLowerCase().equals("true") || value.trim().equals("1")) {
            this.setValue(true);
        } else if (value.trim().toLowerCase().equals("false") || value.trim().equals("0")) {
            this.setValue(false);
        } else {
            throw new AnalysisException("Invalid BOOLEAN literal: " + value);
        }
    }

    protected BoolLiteral(BoolLiteral other) {
        super(other);
        this.setValue(other.value);
    }

    @Override
    public Expr clone() {
        return new BoolLiteral(this);
    }

    private void setValue(boolean value) {
        this.value = value;
        this.selectivity = value ? 1.0 : 0.0;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public Object getRealValue() {
        return this.getValue();
    }

    @Override
    public boolean isMinValue() {
        return false;
    }

    @Override
    public int compareLiteral(LiteralExpr expr) {
        if (expr instanceof NullLiteral) {
            return 1;
        }
        if (expr == MaxLiteral.MAX_VALUE) {
            return -1;
        }
        return Long.signum(this.getLongValue() - expr.getLongValue());
    }

    @Override
    public String toSqlImpl() {
        return this.value ? "TRUE" : "FALSE";
    }

    @Override
    public String getStringValue() {
        return this.value ? "1" : "0";
    }

    @Override
    public ByteBuffer getHashValue(PrimitiveType type) {
        byte v = (byte)(this.value ? 1 : 0);
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(v);
        buffer.flip();
        return buffer;
    }

    @Override
    public long getLongValue() {
        return this.value ? 1L : 0L;
    }

    @Override
    public double getDoubleValue() {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.BOOL_LITERAL;
        msg.bool_literal = new TBoolLiteral(this.value);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeBoolean(this.value);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.setValue(in.readBoolean());
    }

    public static BoolLiteral read(DataInput in) throws IOException {
        BoolLiteral literal = new BoolLiteral();
        literal.readFields(in);
        return literal;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Boolean.hashCode(this.value);
    }
}

