/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.load.sync.DataSyncJobType;

public class BinlogDesc {
    private static final String TYPE = "type";
    private Map<String, String> properties;
    private DataSyncJobType dataSyncJobType;

    public BinlogDesc(Map<String, String> properties) {
        this.properties = properties;
        if (this.properties == null) {
            this.properties = Maps.newHashMap();
        }
        this.dataSyncJobType = DataSyncJobType.UNKNOWN;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public DataSyncJobType getDataSyncJobType() {
        return this.dataSyncJobType;
    }

    public void analyze() throws AnalysisException {
        if (!this.properties.containsKey(TYPE)) {
            throw new AnalysisException("Binlog properties must contain property `type`");
        }
        this.dataSyncJobType = DataSyncJobType.fromString(this.properties.get(TYPE));
    }
}

