/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.AssertNumRowsElement;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.Predicate;
import org.apache.doris.analysis.SlotId;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.analysis.Subquery;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.FunctionSet;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarFunction;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.Reference;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;
import org.apache.doris.thrift.TExprOpcode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BinaryPredicate
extends Predicate
implements Writable {
    private static final Logger LOG = LogManager.getLogger(BinaryPredicate.class);
    private boolean isInferred_ = false;
    private Operator op;
    private Boolean slotIsleft = null;

    public BinaryPredicate() {
    }

    public BinaryPredicate(Operator op, Expr e1, Expr e2) {
        this.op = op;
        this.opcode = op.opcode;
        Preconditions.checkNotNull((Object)e1);
        this.children.add(e1);
        Preconditions.checkNotNull((Object)e2);
        this.children.add(e2);
    }

    protected BinaryPredicate(BinaryPredicate other) {
        super(other);
        this.op = other.op;
        this.slotIsleft = other.slotIsleft;
        this.isInferred_ = other.isInferred_;
    }

    public boolean isInferred() {
        return this.isInferred_;
    }

    public void setIsInferred() {
        this.isInferred_ = true;
    }

    public static void initBuiltins(FunctionSet functionSet) {
        for (Type type : Type.getSupportedTypes()) {
            if (type.isNull()) continue;
            functionSet.addBuiltinBothScalaAndVectorized(ScalarFunction.createBuiltinOperator(Operator.EQ.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), Type.BOOLEAN));
            functionSet.addBuiltinBothScalaAndVectorized(ScalarFunction.createBuiltinOperator(Operator.NE.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), Type.BOOLEAN));
            functionSet.addBuiltinBothScalaAndVectorized(ScalarFunction.createBuiltinOperator(Operator.LE.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), Type.BOOLEAN));
            functionSet.addBuiltinBothScalaAndVectorized(ScalarFunction.createBuiltinOperator(Operator.GE.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), Type.BOOLEAN));
            functionSet.addBuiltinBothScalaAndVectorized(ScalarFunction.createBuiltinOperator(Operator.LT.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), Type.BOOLEAN));
            functionSet.addBuiltinBothScalaAndVectorized(ScalarFunction.createBuiltinOperator(Operator.GT.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), Type.BOOLEAN));
            functionSet.addBuiltinBothScalaAndVectorized(ScalarFunction.createBuiltinOperator(Operator.EQ_FOR_NULL.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), Type.BOOLEAN));
        }
    }

    @Override
    public Expr clone() {
        return new BinaryPredicate(this);
    }

    public Operator getOp() {
        return this.op;
    }

    public void setOp(Operator op) {
        this.op = op;
    }

    @Override
    public Expr negate() {
        Operator newOp = null;
        switch (this.op) {
            case EQ: {
                newOp = Operator.NE;
                break;
            }
            case NE: {
                newOp = Operator.EQ;
                break;
            }
            case LT: {
                newOp = Operator.GE;
                break;
            }
            case LE: {
                newOp = Operator.GT;
                break;
            }
            case GE: {
                newOp = Operator.LT;
                break;
            }
            case GT: {
                newOp = Operator.LE;
                break;
            }
            default: {
                throw new IllegalStateException("Not implemented");
            }
        }
        return new BinaryPredicate(newOp, (Expr)this.getChild(0), (Expr)this.getChild(1));
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return ((BinaryPredicate)obj).opcode == this.opcode;
    }

    @Override
    public String toSqlImpl() {
        return ((Expr)this.getChild(0)).toSql() + " " + this.op.toString() + " " + ((Expr)this.getChild(1)).toSql();
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.BINARY_PRED;
        msg.setOpcode(this.opcode);
        msg.setVectorOpcode(this.vectorOpcode);
        msg.setChildType(((Expr)this.getChild(0)).getType().getPrimitiveType().toThrift());
    }

    @Override
    public void vectorizedAnalyze(Analyzer analyzer) {
        super.vectorizedAnalyze(analyzer);
        Function match = null;
        try {
            match = this.getBuiltinFunction(analyzer, this.op.name, this.collectChildReturnTypes(), Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        }
        catch (AnalysisException e) {
            Preconditions.checkState((boolean)false);
        }
        Preconditions.checkState((match != null ? 1 : 0) != 0);
        Preconditions.checkState((match.getReturnType().getPrimitiveType() == PrimitiveType.BOOLEAN ? 1 : 0) != 0);
        LOG.debug(this.debugString() + " opcode: " + this.vectorOpcode);
    }

    private boolean canCompareDate(PrimitiveType t1, PrimitiveType t2) {
        if (t1.isDateType()) {
            return t2.isDateType() || t2.isStringType() || t2.isIntegerType();
        }
        if (t2.isDateType()) {
            return t1.isStringType() || t1.isIntegerType();
        }
        return false;
    }

    private Type getCmpType() throws AnalysisException {
        Expr leftChild;
        Expr rightChild;
        Long parsedLong;
        PrimitiveType t1 = ((Expr)this.getChild(0)).getType().getResultType().getPrimitiveType();
        PrimitiveType t2 = ((Expr)this.getChild(1)).getType().getResultType().getPrimitiveType();
        for (Expr e : this.getChildren()) {
            if (e.getType().getPrimitiveType() == PrimitiveType.HLL) {
                throw new AnalysisException("Hll type dose not support operand: " + this.toSql());
            }
            if (e.getType().getPrimitiveType() != PrimitiveType.BITMAP) continue;
            throw new AnalysisException("Bitmap type dose not support operand: " + this.toSql());
        }
        if (this.canCompareDate(((Expr)this.getChild(0)).getType().getPrimitiveType(), ((Expr)this.getChild(1)).getType().getPrimitiveType())) {
            return Type.DATETIME;
        }
        if (t1 == PrimitiveType.VARCHAR && t2 == PrimitiveType.VARCHAR) {
            return Type.VARCHAR;
        }
        if (t1 == PrimitiveType.STRING && t2 == PrimitiveType.STRING || t1 == PrimitiveType.STRING && t2 == PrimitiveType.VARCHAR || t1 == PrimitiveType.VARCHAR && t2 == PrimitiveType.STRING) {
            return Type.STRING;
        }
        if (t1 == PrimitiveType.BIGINT && t2 == PrimitiveType.BIGINT) {
            return Type.getAssignmentCompatibleType(((Expr)this.getChild(0)).getType(), ((Expr)this.getChild(1)).getType(), false);
        }
        if (!(t1 != PrimitiveType.BIGINT && t1 != PrimitiveType.DECIMALV2 || t2 != PrimitiveType.BIGINT && t2 != PrimitiveType.DECIMALV2)) {
            return Type.DECIMALV2;
        }
        if (!(t1 != PrimitiveType.BIGINT && t1 != PrimitiveType.LARGEINT || t2 != PrimitiveType.BIGINT && t2 != PrimitiveType.LARGEINT)) {
            return Type.LARGEINT;
        }
        if (t1 == PrimitiveType.BIGINT && (t2 == PrimitiveType.VARCHAR || t2 == PrimitiveType.STRING) && (parsedLong = Type.tryParseToLong(rightChild = (Expr)this.getChild(1))) != null) {
            return Type.BIGINT;
        }
        if ((t1 == PrimitiveType.VARCHAR || t1 == PrimitiveType.STRING) && t2 == PrimitiveType.BIGINT && (parsedLong = Type.tryParseToLong(leftChild = (Expr)this.getChild(0))) != null) {
            return Type.BIGINT;
        }
        return Type.DOUBLE;
    }

    @Override
    public void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        super.analyzeImpl(analyzer);
        for (Expr expr : this.children) {
            if (!(expr instanceof Subquery)) continue;
            Subquery subquery = (Subquery)expr;
            if (!subquery.returnsScalarColumn()) {
                String msg = "Subquery of binary predicate must return a single column: " + expr.toSql();
                throw new AnalysisException(msg);
            }
            if (subquery.getType().isScalarType()) continue;
            subquery.getStatement().setAssertNumRowsElement(1, AssertNumRowsElement.Assertion.LE);
        }
        if (this.contains(Subquery.class)) {
            return;
        }
        Type cmpType = this.getCmpType();
        this.castBinaryOp(cmpType);
        this.opcode = this.op.getOpcode();
        String opName = this.op.getName();
        this.fn = this.getBuiltinFunction(analyzer, opName, this.collectChildReturnTypes(), Function.CompareMode.IS_SUPERTYPE_OF);
        if (this.fn == null) {
            Preconditions.checkState((boolean)false, (Object)String.format("No match for '%s' with operand types %s and %s", this.toSql()));
        }
        Reference<SlotRef> slotRefRef = new Reference<SlotRef>();
        if (this.op == Operator.EQ && this.isSingleColumnPredicate(slotRefRef, null) && slotRefRef.getRef().getNumDistinctValues() > 0L) {
            Preconditions.checkState((slotRefRef.getRef() != null ? 1 : 0) != 0);
            this.selectivity = 1.0 / (double)slotRefRef.getRef().getNumDistinctValues();
            this.selectivity = Math.max(0.0, Math.min(1.0, this.selectivity));
        } else {
            this.selectivity = 0.1;
        }
    }

    public Expr getSlotBinding(SlotId id) {
        SlotRef slotRef = null;
        if (this.getChild(0) instanceof SlotRef) {
            slotRef = (SlotRef)this.getChild(0);
        } else if (this.getChild(0) instanceof CastExpr && ((Expr)this.getChild(0)).getChild(0) instanceof SlotRef && ((CastExpr)this.getChild(0)).canHashPartition()) {
            slotRef = (SlotRef)((Expr)this.getChild(0)).getChild(0);
        }
        if (slotRef != null && slotRef.getSlotId() == id) {
            this.slotIsleft = true;
            return (Expr)this.getChild(1);
        }
        if (this.getChild(1) instanceof SlotRef) {
            slotRef = (SlotRef)this.getChild(1);
        } else if (this.getChild(1) instanceof CastExpr && ((Expr)this.getChild(1)).getChild(0) instanceof SlotRef && ((CastExpr)this.getChild(1)).canHashPartition()) {
            slotRef = (SlotRef)((Expr)this.getChild(1)).getChild(0);
        }
        if (slotRef != null && slotRef.getSlotId() == id) {
            this.slotIsleft = false;
            return (Expr)this.getChild(0);
        }
        return null;
    }

    public static Pair<SlotId, SlotId> getEqSlots(Expr e) {
        if (!(e instanceof BinaryPredicate)) {
            return null;
        }
        return ((BinaryPredicate)e).getEqSlots();
    }

    @Override
    public Pair<SlotId, SlotId> getEqSlots() {
        if (this.op != Operator.EQ) {
            return null;
        }
        SlotRef lhs = ((Expr)this.getChild(0)).unwrapSlotRef(true);
        if (lhs == null) {
            return null;
        }
        SlotRef rhs = ((Expr)this.getChild(1)).unwrapSlotRef(true);
        if (rhs == null) {
            return null;
        }
        return new Pair<SlotId, SlotId>(lhs.getSlotId(), rhs.getSlotId());
    }

    public boolean slotIsLeft() {
        Preconditions.checkState((this.slotIsleft != null ? 1 : 0) != 0);
        return this.slotIsleft;
    }

    public Range<LiteralExpr> convertToRange() {
        Preconditions.checkState((boolean)(this.getChild(0) instanceof SlotRef));
        Preconditions.checkState((boolean)(this.getChild(1) instanceof LiteralExpr));
        LiteralExpr literalExpr = (LiteralExpr)this.getChild(1);
        switch (this.op) {
            case EQ: {
                return Range.singleton((Comparable)literalExpr);
            }
            case GE: {
                return Range.atLeast((Comparable)literalExpr);
            }
            case GT: {
                return Range.greaterThan((Comparable)literalExpr);
            }
            case LE: {
                return Range.atMost((Comparable)literalExpr);
            }
            case LT: {
                return Range.lessThan((Comparable)literalExpr);
            }
        }
        return null;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Expr right;
        boolean isWritable = true;
        Expr left = (Expr)this.getChild(0);
        if (!(left instanceof SlotRef)) {
            isWritable = false;
        }
        if (!((right = (Expr)this.getChild(1)) instanceof StringLiteral)) {
            isWritable = false;
        }
        if (isWritable) {
            out.writeInt(1);
            Text.writeString((DataOutput)out, (String)this.op.name());
            Text.writeString((DataOutput)out, (String)((SlotRef)left).getColumnName());
            Text.writeString((DataOutput)out, (String)((StringLiteral)right).getStringValue());
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int isWritable = in.readInt();
        if (isWritable == 0) {
            return;
        }
        Operator op = Operator.valueOf(Text.readString((DataInput)in));
        SlotRef left = new SlotRef(null, Text.readString((DataInput)in));
        StringLiteral right = new StringLiteral(Text.readString((DataInput)in));
        this.op = op;
        this.addChild(left);
        this.addChild(right);
    }

    public static BinaryPredicate read(DataInput in) throws IOException {
        BinaryPredicate binaryPredicate = new BinaryPredicate();
        binaryPredicate.readFields(in);
        return binaryPredicate;
    }

    @Override
    public Expr getResultValue() throws AnalysisException {
        this.recursiveResetChildrenResult();
        Expr leftChildValue = (Expr)this.getChild(0);
        Expr rightChildValue = (Expr)this.getChild(1);
        if (!(leftChildValue instanceof LiteralExpr) || !(rightChildValue instanceof LiteralExpr)) {
            return this;
        }
        return this.compareLiteral((LiteralExpr)leftChildValue, (LiteralExpr)rightChildValue);
    }

    private Expr compareLiteral(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        boolean isFirstNull = first instanceof NullLiteral;
        boolean isSecondNull = second instanceof NullLiteral;
        if (this.op == Operator.EQ_FOR_NULL) {
            if (isFirstNull && isSecondNull) {
                return new BoolLiteral(true);
            }
            if (isFirstNull || isSecondNull) {
                return new BoolLiteral(false);
            }
        } else if (isFirstNull || isSecondNull) {
            return new NullLiteral();
        }
        int compareResult = first.compareLiteral(second);
        switch (this.op) {
            case EQ: 
            case EQ_FOR_NULL: {
                return new BoolLiteral(compareResult == 0);
            }
            case GE: {
                return new BoolLiteral(compareResult == 1 || compareResult == 0);
            }
            case GT: {
                return new BoolLiteral(compareResult == 1);
            }
            case LE: {
                return new BoolLiteral(compareResult == -1 || compareResult == 0);
            }
            case LT: {
                return new BoolLiteral(compareResult == -1);
            }
            case NE: {
                return new BoolLiteral(compareResult != 0);
            }
        }
        Preconditions.checkState((boolean)false, (Object)"No defined binary operator.");
        return this;
    }

    @Override
    public void setSelectivity() {
        switch (this.op) {
            case EQ: 
            case EQ_FOR_NULL: {
                long distinctValues;
                Reference<SlotRef> slotRefRef = new Reference<SlotRef>();
                boolean singlePredicate = this.isSingleColumnPredicate(slotRefRef, null);
                if (!singlePredicate || (distinctValues = slotRefRef.getRef().getNumDistinctValues()) == -1L) break;
                this.selectivity = 1.0 / (double)distinctValues;
                break;
            }
            default: {
                this.selectivity = 0.3333333333333333;
            }
        }
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode((Object)this.op);
    }

    @Override
    public boolean isNullable() {
        if (this.op == Operator.EQ_FOR_NULL) {
            return false;
        }
        return this.hasNullableChild();
    }

    public static enum Operator {
        EQ("=", "eq", TExprOpcode.EQ),
        NE("!=", "ne", TExprOpcode.NE),
        LE("<=", "le", TExprOpcode.LE),
        GE(">=", "ge", TExprOpcode.GE),
        LT("<", "lt", TExprOpcode.LT),
        GT(">", "gt", TExprOpcode.GT),
        EQ_FOR_NULL("<=>", "eq_for_null", TExprOpcode.EQ_FOR_NULL);

        private final String description;
        private final String name;
        private final TExprOpcode opcode;

        private Operator(String description, String name, TExprOpcode opcode) {
            this.description = description;
            this.name = name;
            this.opcode = opcode;
        }

        public String toString() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        public TExprOpcode getOpcode() {
            return this.opcode;
        }

        public Operator commutative() {
            switch (this) {
                case EQ: {
                    return this;
                }
                case NE: {
                    return this;
                }
                case LE: {
                    return GE;
                }
                case GE: {
                    return LE;
                }
                case LT: {
                    return GT;
                }
                case GT: {
                    return LE;
                }
                case EQ_FOR_NULL: {
                    return this;
                }
            }
            return null;
        }

        public Operator converse() {
            switch (this) {
                case EQ: {
                    return EQ;
                }
                case NE: {
                    return NE;
                }
                case LE: {
                    return GE;
                }
                case GE: {
                    return LE;
                }
                case LT: {
                    return GT;
                }
                case GT: {
                    return LT;
                }
                case EQ_FOR_NULL: {
                    return EQ_FOR_NULL;
                }
            }
            throw new IllegalStateException("Invalid operator");
        }

        public boolean isEquivalence() {
            return this == EQ || this == EQ_FOR_NULL;
        }

        public boolean isUnNullSafeEquivalence() {
            return this == EQ;
        }

        public boolean isUnequivalence() {
            return this == NE;
        }
    }
}

