/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.Predicate;
import org.apache.doris.analysis.Subquery;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.thrift.TExprNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BetweenPredicate
extends Predicate {
    private static final Logger LOG = LogManager.getLogger(BetweenPredicate.class);
    private final boolean isNotBetween;

    public BetweenPredicate(Expr compareExpr, Expr lowerBound, Expr upperBound, boolean isNotBetween) {
        this.children.add(compareExpr);
        this.children.add(lowerBound);
        this.children.add(upperBound);
        this.isNotBetween = isNotBetween;
    }

    protected BetweenPredicate(BetweenPredicate other) {
        super(other);
        this.isNotBetween = other.isNotBetween;
    }

    @Override
    public Expr clone() {
        return new BetweenPredicate(this);
    }

    public boolean isNotBetween() {
        return this.isNotBetween;
    }

    @Override
    public void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        super.analyzeImpl(analyzer);
        if (this.children.get(0) instanceof Subquery && (this.children.get(1) instanceof Subquery || this.children.get(2) instanceof Subquery)) {
            throw new AnalysisException("Comparison between subqueries is not supported in a BETWEEN predicate: " + this.toSql());
        }
        if (this.children.get(0) instanceof Subquery || this.children.get(1) instanceof Subquery || this.children.get(2) instanceof Subquery) {
            return;
        }
        analyzer.castAllToCompatibleType(this.children);
    }

    @Override
    public boolean isVectorized() {
        return false;
    }

    @Override
    protected void toThrift(TExprNode msg) {
        throw new IllegalStateException("BetweenPredicate needs to be rewritten into a CompoundPredicate.");
    }

    @Override
    public String toSqlImpl() {
        String notStr = this.isNotBetween ? "NOT " : "";
        return ((Expr)this.children.get(0)).toSql() + " " + notStr + "BETWEEN " + ((Expr)this.children.get(1)).toSql() + " AND " + ((Expr)this.children.get(2)).toSql();
    }

    @Override
    public Expr clone(ExprSubstitutionMap sMap) {
        return new BetweenPredicate(this);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Boolean.hashCode(this.isNotBetween);
    }
}

