/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ColWithComment;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.ToSqlContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseViewStmt
extends DdlStmt {
    private static final Logger LOG = LogManager.getLogger(BaseViewStmt.class);
    protected final TableName tableName;
    protected final List<ColWithComment> cols;
    protected final QueryStmt viewDefStmt;
    protected final List<Column> finalCols;
    protected String inlineViewDef;
    protected QueryStmt cloneStmt;

    public BaseViewStmt(TableName tableName, List<ColWithComment> cols, QueryStmt queryStmt) {
        Preconditions.checkNotNull((Object)queryStmt);
        this.tableName = tableName;
        this.cols = cols;
        this.viewDefStmt = queryStmt;
        this.finalCols = Lists.newArrayList();
    }

    public String getDbName() {
        return this.tableName.getDb();
    }

    public String getTable() {
        return this.tableName.getTbl();
    }

    public List<Column> getColumns() {
        return this.finalCols;
    }

    public String getInlineViewDef() {
        return this.inlineViewDef;
    }

    protected void createColumnAndViewDefs(Analyzer analyzer) throws AnalysisException, UserException {
        Object type;
        int i;
        if (this.cols != null) {
            if (this.cols.size() != ((ArrayList)this.viewDefStmt.getColLabels()).size()) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_VIEW_WRONG_LIST, new Object[0]);
            }
            for (i = 0; i < this.cols.size(); ++i) {
                type = this.viewDefStmt.getBaseTblResultExprs().get(i).getType().getPrimitiveType();
                Column col = new Column(this.cols.get(i).getColName(), ScalarType.createType(type));
                col.setComment(this.cols.get(i).getComment());
                this.finalCols.add(col);
            }
        } else {
            for (i = 0; i < this.viewDefStmt.getBaseTblResultExprs().size(); ++i) {
                type = this.viewDefStmt.getBaseTblResultExprs().get(i).getType().getPrimitiveType();
                this.finalCols.add(new Column((String)((ArrayList)this.viewDefStmt.getColLabels()).get(i), ScalarType.createType(type)));
            }
        }
        TreeSet colSets = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (Column col : this.finalCols) {
            if (colSets.add(col.getName())) continue;
            ErrorReport.reportAnalysisException(ErrorCode.ERR_DUP_FIELDNAME, col.getName());
        }
        if (this.cols == null) {
            try (ToSqlContext toSqlContext = ToSqlContext.getOrNewThreadLocalContext();){
                toSqlContext.setNeedSlotRefId(false);
                this.inlineViewDef = this.viewDefStmt.toSql();
            }
            return;
        }
        Analyzer tmpAnalyzer = new Analyzer(analyzer);
        List<String> colNames = this.cols.stream().map(c -> c.getColName()).collect(Collectors.toList());
        this.cloneStmt.substituteSelectList(tmpAnalyzer, colNames);
        try (ToSqlContext toSqlContext = ToSqlContext.getOrNewThreadLocalContext();){
            toSqlContext.setNeedSlotRefId(false);
            this.inlineViewDef = this.cloneStmt.toSql();
        }
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        if (this.viewDefStmt.hasOutFileClause()) {
            throw new AnalysisException("Not support OUTFILE clause in CREATE VIEW statement");
        }
    }
}

