/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.UserException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseTableRef
extends TableRef {
    private static final Logger LOG = LogManager.getLogger(BaseTableRef.class);
    private Table table;

    public BaseTableRef(TableRef ref, Table table, TableName tableName) {
        super(ref);
        this.table = table;
        this.name = tableName;
        if (this.hasExplicitAlias()) {
            return;
        }
        this.aliases_ = new String[]{this.name.toString(), tableName.getNoClusterString(), tableName.getTbl()};
    }

    protected BaseTableRef(BaseTableRef other) {
        super(other);
        this.name = other.name;
        this.table = other.table;
    }

    @Override
    public TableRef clone() {
        return new BaseTableRef(this);
    }

    @Override
    public TupleDescriptor createTupleDescriptor(Analyzer analyzer) {
        TupleDescriptor result = analyzer.getDescTbl().createTupleDescriptor();
        result.setTable(this.table);
        return result;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        this.name = analyzer.getFqTableName(this.name);
        this.name.analyze(analyzer);
        this.desc = analyzer.registerTableRef(this);
        this.isAnalyzed = true;
        this.analyzeLateralViewRef(analyzer);
        this.analyzeJoin(analyzer);
        this.analyzeSortHints();
        this.analyzeHints();
    }
}

