/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.doris.analysis.AbstractBackupStmt;
import org.apache.doris.analysis.AbstractBackupTableRefClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.LabelName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.PrintableMap;

public class BackupStmt
extends AbstractBackupStmt {
    private static final String PROP_TYPE = "type";
    public static final String PROP_CONTENT = "content";
    private BackupType type = BackupType.FULL;
    private BackupContent content = BackupContent.ALL;

    public BackupStmt(LabelName labelName, String repoName, AbstractBackupTableRefClause abstractBackupTableRefClause, Map<String, String> properties) {
        super(labelName, repoName, abstractBackupTableRefClause, properties);
    }

    @Override
    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public BackupType getType() {
        return this.type;
    }

    public BackupContent getContent() {
        return this.content;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
    }

    @Override
    protected void customAnalyzeTableRefClause() throws AnalysisException {
        for (TableRef tblRef : this.abstractBackupTableRefClause.getTableRefList()) {
            if (!tblRef.hasExplicitAlias()) continue;
            throw new AnalysisException("Can not set alias for table in Backup Stmt: " + tblRef);
        }
    }

    @Override
    protected void analyzeProperties() throws AnalysisException {
        String contentProp;
        super.analyzeProperties();
        HashMap copiedProperties = Maps.newHashMap((Map)this.properties);
        String typeProp = (String)copiedProperties.get(PROP_TYPE);
        if (typeProp != null) {
            try {
                this.type = BackupType.valueOf(typeProp.toUpperCase());
            }
            catch (Exception e) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_COMMON_ERROR, "Invalid backup job type: " + typeProp);
            }
            copiedProperties.remove(PROP_TYPE);
        }
        if ((contentProp = (String)copiedProperties.get(PROP_CONTENT)) != null) {
            try {
                this.content = BackupContent.valueOf(contentProp.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_COMMON_ERROR, "Invalid backup job content:" + contentProp);
            }
            copiedProperties.remove(PROP_CONTENT);
        }
        if (!copiedProperties.isEmpty()) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_COMMON_ERROR, "Unknown backup job properties: " + copiedProperties.keySet());
        }
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("BACKUP SNAPSHOT ").append(this.labelName.toSql());
        sb.append("\n").append("TO ").append(this.repoName).append("\n");
        if (this.abstractBackupTableRefClause != null) {
            sb.append(this.abstractBackupTableRefClause.toSql()).append("\n");
        }
        sb.append("PROPERTIES\n(");
        sb.append(new PrintableMap(this.properties, " = ", true, true));
        sb.append("\n)");
        return sb.toString();
    }

    public static enum BackupContent {
        METADATA_ONLY,
        ALL;

    }

    public static enum BackupType {
        INCREMENTAL,
        FULL;

    }
}

