/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Pair;
import org.apache.doris.system.SystemInfoService;

public class BackendClause
extends AlterClause {
    protected List<String> hostPorts;
    protected List<Pair<String, Integer>> hostPortPairs;

    protected BackendClause(List<String> hostPorts) {
        super(AlterOpType.ALTER_OTHER);
        this.hostPorts = hostPorts;
        this.hostPortPairs = new LinkedList<Pair<String, Integer>>();
    }

    public List<Pair<String, Integer>> getHostPortPairs() {
        return this.hostPortPairs;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        for (String hostPort : this.hostPorts) {
            Pair<String, Integer> pair = SystemInfoService.validateHostAndPort(hostPort);
            this.hostPortPairs.add(pair);
        }
        Preconditions.checkState((!this.hostPortPairs.isEmpty() ? 1 : 0) != 0);
    }

    @Override
    public String toSql() {
        throw new NotImplementedException();
    }

    @Override
    public Map<String, String> getProperties() {
        throw new NotImplementedException();
    }
}

