/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.catalog.ArrayType;
import org.apache.doris.catalog.Type;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;

public class ArrayLiteral
extends LiteralExpr {
    public ArrayLiteral() {
        this.type = new ArrayType(Type.NULL);
        this.children = new ArrayList();
    }

    public ArrayLiteral(LiteralExpr ... v) {
        if (v.length < 1) {
            this.type = new ArrayType(Type.NULL);
            return;
        }
        this.type = new ArrayType(v[0].type);
        this.children = new ArrayList(v.length);
        this.children.addAll(Arrays.asList(v));
    }

    protected ArrayLiteral(ArrayLiteral other) {
        super(other);
    }

    @Override
    public boolean isMinValue() {
        return false;
    }

    @Override
    public int compareLiteral(LiteralExpr expr) {
        return 0;
    }

    @Override
    protected String toSqlImpl() {
        ArrayList list = new ArrayList(this.children.size());
        this.children.forEach(v -> list.add(v.toSqlImpl()));
        return "ARRAY(" + StringUtils.join(list, (String)", ") + ")";
    }

    @Override
    public String getStringValue() {
        ArrayList list = new ArrayList(this.children.size());
        this.children.forEach(v -> list.add(((LiteralExpr)v).getStringValue()));
        return "ARRAY[" + StringUtils.join(list, (String)", ") + "]";
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.ARRAY_LITERAL;
        msg.setChildType(((ArrayType)this.type).getItemType().getPrimitiveType().toThrift());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.children.size());
        for (Expr e : this.children) {
            Expr.writeTo(e, out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int size = in.readInt();
        this.children = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.children.add(Expr.readIn(in));
        }
    }

    public static ArrayLiteral read(DataInput in) throws IOException {
        ArrayLiteral literal = new ArrayLiteral();
        literal.readFields(in);
        return literal;
    }

    @Override
    public Expr clone() {
        return new ArrayLiteral(this);
    }
}

