/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.AssertNumRowsElement;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.Subquery;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.FunctionSet;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarFunction;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.util.VectorizedUtil;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;
import org.apache.doris.thrift.TExprOpcode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArithmeticExpr
extends Expr {
    private static final Logger LOG = LogManager.getLogger(ArithmeticExpr.class);
    private final Operator op;

    public static void initBuiltins(FunctionSet functionSet) {
        Type t2;
        int j;
        int i;
        for (Type type : Type.getNumericTypes()) {
            functionSet.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.MULTIPLY.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), type));
            functionSet.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.ADD.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), type));
            functionSet.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.SUBTRACT.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), type));
        }
        functionSet.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.DIVIDE.getName(), Lists.newArrayList((Object[])new Type[]{Type.DOUBLE, Type.DOUBLE}), Type.DOUBLE, Function.NullableMode.ALWAYS_NULLABLE));
        functionSet.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.DIVIDE.getName(), Lists.newArrayList((Object[])new Type[]{Type.DECIMALV2, Type.DECIMALV2}), Type.DECIMALV2, Function.NullableMode.ALWAYS_NULLABLE));
        for (Type type : Type.getIntegerTypes()) {
            functionSet.addBuiltin(ScalarFunction.createBuiltinOperator(Operator.INT_DIVIDE.getName(), Lists.newArrayList((Object[])new Type[]{type, type}), type, Function.NullableMode.ALWAYS_NULLABLE));
        }
        for (i = 0; i < Type.getNumericTypes().size(); ++i) {
            Type type = Type.getNumericTypes().get(i);
            for (j = 0; j < Type.getNumericTypes().size(); ++j) {
                t2 = Type.getNumericTypes().get(j);
                functionSet.addBuiltin(ScalarFunction.createVecBuiltinOperator(Operator.MULTIPLY.getName(), Lists.newArrayList((Object[])new Type[]{type, t2}), Type.getNextNumType(Type.getAssignmentCompatibleType(type, t2, false))));
                functionSet.addBuiltin(ScalarFunction.createVecBuiltinOperator(Operator.ADD.getName(), Lists.newArrayList((Object[])new Type[]{type, t2}), Type.getNextNumType(Type.getAssignmentCompatibleType(type, t2, false))));
                functionSet.addBuiltin(ScalarFunction.createVecBuiltinOperator(Operator.SUBTRACT.getName(), Lists.newArrayList((Object[])new Type[]{type, t2}), Type.getNextNumType(Type.getAssignmentCompatibleType(type, t2, false))));
            }
        }
        functionSet.addBuiltin(ScalarFunction.createVecBuiltinOperator(Operator.DIVIDE.getName(), Lists.newArrayList((Object[])new Type[]{Type.DOUBLE, Type.DOUBLE}), Type.DOUBLE, Function.NullableMode.ALWAYS_NULLABLE));
        functionSet.addBuiltin(ScalarFunction.createVecBuiltinOperator(Operator.DIVIDE.getName(), Lists.newArrayList((Object[])new Type[]{Type.DECIMALV2, Type.DECIMALV2}), Type.DECIMALV2, Function.NullableMode.ALWAYS_NULLABLE));
        functionSet.addBuiltin(ScalarFunction.createVecBuiltinOperator(Operator.MOD.getName(), Lists.newArrayList((Object[])new Type[]{Type.FLOAT, Type.FLOAT}), Type.FLOAT, Function.NullableMode.ALWAYS_NULLABLE));
        functionSet.addBuiltin(ScalarFunction.createVecBuiltinOperator(Operator.MOD.getName(), Lists.newArrayList((Object[])new Type[]{Type.DOUBLE, Type.DOUBLE}), Type.DOUBLE, Function.NullableMode.ALWAYS_NULLABLE));
        functionSet.addBuiltin(ScalarFunction.createVecBuiltinOperator(Operator.MOD.getName(), Lists.newArrayList((Object[])new Type[]{Type.DECIMALV2, Type.DECIMALV2}), Type.DECIMALV2, Function.NullableMode.ALWAYS_NULLABLE));
        for (i = 0; i < Type.getIntegerTypes().size(); ++i) {
            Type type = Type.getIntegerTypes().get(i);
            for (j = 0; j < Type.getIntegerTypes().size(); ++j) {
                t2 = Type.getIntegerTypes().get(j);
                functionSet.addBuiltin(ScalarFunction.createVecBuiltinOperator(Operator.INT_DIVIDE.getName(), Lists.newArrayList((Object[])new Type[]{type, t2}), Type.getAssignmentCompatibleType(type, t2, false), Function.NullableMode.ALWAYS_NULLABLE));
                functionSet.addBuiltin(ScalarFunction.createVecBuiltinOperator(Operator.MOD.getName(), Lists.newArrayList((Object[])new Type[]{type, t2}), Type.getAssignmentCompatibleType(type, t2, false), Function.NullableMode.ALWAYS_NULLABLE));
            }
        }
    }

    public ArithmeticExpr(Operator op, Expr e1, Expr e2) {
        this.op = op;
        Preconditions.checkNotNull((Object)e1);
        this.children.add(e1);
        Preconditions.checkArgument((op == Operator.BITNOT && e2 == null || op != Operator.BITNOT && e2 != null ? 1 : 0) != 0);
        if (e2 != null) {
            this.children.add(e2);
        }
    }

    protected ArithmeticExpr(ArithmeticExpr other) {
        super(other);
        this.op = other.op;
    }

    @Override
    public String toString() {
        return this.toSql();
    }

    @Override
    public Expr clone() {
        return new ArithmeticExpr(this);
    }

    @Override
    public String toSqlImpl() {
        if (this.children.size() == 1) {
            return this.op.toString() + " " + ((Expr)this.getChild(0)).toSql();
        }
        return ((Expr)this.getChild(0)).toSql() + " " + this.op.toString() + " " + ((Expr)this.getChild(1)).toSql();
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.ARITHMETIC_EXPR;
        if (!this.type.isDecimalV2()) {
            msg.setOpcode(this.op.getOpcode());
            msg.setOutputColumn(this.outputColumn);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return ((ArithmeticExpr)obj).opcode == this.opcode;
    }

    @Override
    public void computeOutputColumn(Analyzer analyzer) {
        super.computeOutputColumn(analyzer);
        ArrayList tupleIds = Lists.newArrayList();
        this.getIds(tupleIds, null);
        Preconditions.checkArgument((tupleIds.size() == 1 ? 1 : 0) != 0);
    }

    private Type findCommonType(Type t1, Type t2) {
        PrimitiveType pt1 = t1.getPrimitiveType();
        PrimitiveType pt2 = t2.getPrimitiveType();
        if (pt1 == PrimitiveType.DOUBLE || pt2 == PrimitiveType.DOUBLE) {
            return Type.DOUBLE;
        }
        if (pt1 == PrimitiveType.DECIMALV2 || pt2 == PrimitiveType.DECIMALV2) {
            return Type.DECIMALV2;
        }
        if (pt1 == PrimitiveType.LARGEINT || pt2 == PrimitiveType.LARGEINT) {
            return Type.LARGEINT;
        }
        if (pt1 != PrimitiveType.BIGINT && pt2 != PrimitiveType.BIGINT) {
            return Type.INVALID;
        }
        return Type.BIGINT;
    }

    private boolean castIfHaveSameType(Type t1, Type t2, Type target) throws AnalysisException {
        if (t1 == target || t2 == target) {
            this.castChild(target, 0);
            this.castChild(target, 1);
            return true;
        }
        return false;
    }

    private void castUpperInteger(Type t1, Type t2) throws AnalysisException {
        if (!t1.isIntegerType() || !t2.isIntegerType()) {
            return;
        }
        if (this.castIfHaveSameType(t1, t2, Type.BIGINT)) {
            return;
        }
        if (this.castIfHaveSameType(t1, t2, Type.INT)) {
            return;
        }
        if (this.castIfHaveSameType(t1, t2, Type.SMALLINT)) {
            return;
        }
        if (this.castIfHaveSameType(t1, t2, Type.TINYINT)) {
            return;
        }
    }

    @Override
    public void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        if (VectorizedUtil.isVectorized()) {
            if (this.op == Operator.BITNOT) {
                Type t = ((Expr)this.getChild(0)).getType();
                if (t.getPrimitiveType().ordinal() > PrimitiveType.LARGEINT.ordinal()) {
                    this.type = Type.BIGINT;
                    this.castChild(this.type, 0);
                } else {
                    this.type = t;
                }
                this.fn = this.getBuiltinFunction(analyzer, this.op.getName(), this.collectChildReturnTypes(), Function.CompareMode.IS_SUPERTYPE_OF);
                if (this.fn == null) {
                    Preconditions.checkState((boolean)false, (Object)String.format("No match for op with operand types", this.toSql()));
                }
                return;
            }
            this.analyzeSubqueryInChildren();
            if (this.contains(Subquery.class)) {
                return;
            }
            Type t1 = ((Expr)this.getChild(0)).getType();
            Type t2 = ((Expr)this.getChild(1)).getType();
            if (t1.isNull() || t2.isNull()) {
                this.castBinaryOp(t1.isNull() ? t2 : t1);
                t1 = ((Expr)this.getChild(0)).getType();
                t2 = ((Expr)this.getChild(1)).getType();
            }
            if (!t1.isNumericType()) {
                this.castChild(t1.getNumResultType(), 0);
                t1 = t1.getNumResultType();
            }
            if (!t2.isNumericType()) {
                this.castChild(t2.getNumResultType(), 1);
                t2 = t2.getNumResultType();
            }
            switch (this.op) {
                case MULTIPLY: 
                case ADD: 
                case SUBTRACT: {
                    if (t1.isDecimalV2() || t2.isDecimalV2()) {
                        this.castBinaryOp(this.findCommonType(t1, t2));
                    }
                    if (this.isConstant()) {
                        this.castUpperInteger(t1, t2);
                    }
                }
                case MOD: {
                    if (t1.isDecimalV2() || t2.isDecimalV2()) {
                        this.castBinaryOp(this.findCommonType(t1, t2));
                        break;
                    }
                    if (!t1.isFloatingPointType() && !t2.isFloatingPointType() || t1.equals(t2)) break;
                    this.castBinaryOp(Type.DOUBLE);
                    break;
                }
                case INT_DIVIDE: {
                    if (t1.isFixedPointType() && t2.isFloatingPointType()) break;
                    this.castBinaryOp(Type.BIGINT);
                    break;
                }
                case DIVIDE: {
                    t1 = ((Expr)this.getChild(0)).getType().getNumResultType();
                    t2 = ((Expr)this.getChild(1)).getType().getNumResultType();
                    Type commonType = this.findCommonType(t1, t2);
                    if (commonType.getPrimitiveType() == PrimitiveType.BIGINT || commonType.getPrimitiveType() == PrimitiveType.LARGEINT) {
                        commonType = Type.DOUBLE;
                    }
                    this.castBinaryOp(commonType);
                    break;
                }
                case BITAND: 
                case BITOR: 
                case BITXOR: {
                    Type commonType;
                    if (t1 == Type.BOOLEAN && t2 == Type.BOOLEAN) {
                        t1 = Type.TINYINT;
                        t2 = Type.TINYINT;
                    }
                    if ((commonType = Type.getAssignmentCompatibleType(t1, t2, false)).getPrimitiveType().ordinal() > PrimitiveType.LARGEINT.ordinal()) {
                        commonType = Type.BIGINT;
                    }
                    this.type = this.castBinaryOp(commonType);
                    break;
                }
                default: {
                    Preconditions.checkState((boolean)false, (Object)("Unknown arithmetic operation " + this.op.toString() + " in: " + this.toSql()));
                }
            }
            this.fn = this.getBuiltinFunction(analyzer, this.op.name, this.collectChildReturnTypes(), Function.CompareMode.IS_IDENTICAL);
            if (this.fn == null) {
                Preconditions.checkState((boolean)false, (Object)String.format("No match for vec function '%s' with operand types %s and %s", this.toSql(), t1, t2));
            }
            this.type = this.fn.getReturnType();
        } else {
            if (this.op == Operator.BITNOT) {
                this.type = Type.BIGINT;
                if (((Expr)this.getChild(0)).getType().getPrimitiveType() != PrimitiveType.BIGINT) {
                    this.castChild(this.type, 0);
                }
                this.fn = this.getBuiltinFunction(analyzer, this.op.getName(), this.collectChildReturnTypes(), Function.CompareMode.IS_SUPERTYPE_OF);
                if (this.fn == null) {
                    Preconditions.checkState((boolean)false, (Object)String.format("No match for op with operand types", this.toSql()));
                }
                return;
            }
            this.analyzeSubqueryInChildren();
            if (this.contains(Subquery.class)) {
                return;
            }
            Type t1 = ((Expr)this.getChild(0)).getType().getNumResultType();
            Type t2 = ((Expr)this.getChild(1)).getType().getNumResultType();
            Type commonType = Type.INVALID;
            String fnName = this.op.getName();
            switch (this.op) {
                case MULTIPLY: 
                case ADD: 
                case SUBTRACT: 
                case MOD: {
                    commonType = this.findCommonType(t1, t2);
                    break;
                }
                case DIVIDE: {
                    commonType = this.findCommonType(t1, t2);
                    if (commonType.getPrimitiveType() != PrimitiveType.BIGINT && commonType.getPrimitiveType() != PrimitiveType.LARGEINT) break;
                    commonType = Type.DOUBLE;
                    break;
                }
                case INT_DIVIDE: 
                case BITAND: 
                case BITOR: 
                case BITXOR: {
                    commonType = Type.BIGINT;
                    break;
                }
                default: {
                    Preconditions.checkState((boolean)false, (Object)("Unknown arithmetic operation " + this.op.toString() + " in: " + this.toSql()));
                }
            }
            this.type = this.castBinaryOp(commonType);
            this.fn = this.getBuiltinFunction(analyzer, fnName, this.collectChildReturnTypes(), Function.CompareMode.IS_IDENTICAL);
            if (this.fn == null) {
                Preconditions.checkState((boolean)false, (Object)String.format("No match for '%s' with operand types %s and %s", this.toSql(), t1, t2));
            }
        }
    }

    public void analyzeSubqueryInChildren() throws AnalysisException {
        for (Expr child : this.children) {
            if (!(child instanceof Subquery)) continue;
            Subquery subquery = (Subquery)child;
            if (!subquery.returnsScalarColumn()) {
                String msg = "Subquery of arithmetic expr must return a single column: " + child.toSql();
                throw new AnalysisException(msg);
            }
            if (subquery.getType().isScalarType()) continue;
            subquery.getStatement().setAssertNumRowsElement(1, AssertNumRowsElement.Assertion.LE);
        }
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode((Object)this.op);
    }

    public static enum Operator {
        MULTIPLY("*", "multiply", OperatorPosition.BINARY_INFIX, TExprOpcode.MULTIPLY),
        DIVIDE("/", "divide", OperatorPosition.BINARY_INFIX, TExprOpcode.DIVIDE),
        MOD("%", "mod", OperatorPosition.BINARY_INFIX, TExprOpcode.MOD),
        INT_DIVIDE("DIV", "int_divide", OperatorPosition.BINARY_INFIX, TExprOpcode.INT_DIVIDE),
        ADD("+", "add", OperatorPosition.BINARY_INFIX, TExprOpcode.ADD),
        SUBTRACT("-", "subtract", OperatorPosition.BINARY_INFIX, TExprOpcode.SUBTRACT),
        BITAND("&", "bitand", OperatorPosition.BINARY_INFIX, TExprOpcode.BITAND),
        BITOR("|", "bitor", OperatorPosition.BINARY_INFIX, TExprOpcode.BITOR),
        BITXOR("^", "bitxor", OperatorPosition.BINARY_INFIX, TExprOpcode.BITXOR),
        BITNOT("~", "bitnot", OperatorPosition.UNARY_PREFIX, TExprOpcode.BITNOT),
        FACTORIAL("!", "factorial", OperatorPosition.UNARY_POSTFIX, TExprOpcode.FACTORIAL);

        private final String description;
        private final String name;
        private final OperatorPosition pos;
        private final TExprOpcode opcode;

        private Operator(String description, String name, OperatorPosition pos, TExprOpcode opcode) {
            this.description = description;
            this.name = name;
            this.pos = pos;
            this.opcode = opcode;
        }

        public String toString() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        public OperatorPosition getPos() {
            return this.pos;
        }

        public TExprOpcode getOpcode() {
            return this.opcode;
        }

        public boolean isUnary() {
            return this.pos == OperatorPosition.UNARY_PREFIX || this.pos == OperatorPosition.UNARY_POSTFIX;
        }

        public boolean isBinary() {
            return this.pos == OperatorPosition.BINARY_INFIX;
        }
    }

    static enum OperatorPosition {
        BINARY_INFIX,
        UNARY_PREFIX,
        UNARY_POSTFIX;

    }
}

