/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.doris.analysis.AnalyticInfo;
import org.apache.doris.analysis.BaseTableRef;
import org.apache.doris.analysis.BetweenPredicate;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.DescriptorTable;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprId;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.FunctionName;
import org.apache.doris.analysis.InlineViewRef;
import org.apache.doris.analysis.JoinOperator;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.Predicate;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotId;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Type;
import org.apache.doris.catalog.View;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.Id;
import org.apache.doris.common.IdGenerator;
import org.apache.doris.common.Pair;
import org.apache.doris.common.VecNotImplException;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.RuntimeFilter;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.rewrite.BetweenToCompoundRule;
import org.apache.doris.rewrite.CompoundPredicateWriteRule;
import org.apache.doris.rewrite.ExprRewriter;
import org.apache.doris.rewrite.ExtractCommonFactorsRule;
import org.apache.doris.rewrite.FoldConstantsRule;
import org.apache.doris.rewrite.InferFiltersRule;
import org.apache.doris.rewrite.NormalizeBinaryPredicatesRule;
import org.apache.doris.rewrite.RewriteAliasFunctionRule;
import org.apache.doris.rewrite.RewriteBinaryPredicatesRule;
import org.apache.doris.rewrite.RewriteDateLiteralRule;
import org.apache.doris.rewrite.RewriteEncryptKeyRule;
import org.apache.doris.rewrite.RewriteFromUnixTimeRule;
import org.apache.doris.rewrite.mvrewrite.CountDistinctToBitmap;
import org.apache.doris.rewrite.mvrewrite.CountDistinctToBitmapOrHLLRule;
import org.apache.doris.rewrite.mvrewrite.CountFieldToSum;
import org.apache.doris.rewrite.mvrewrite.HLLHashToSlotRefRule;
import org.apache.doris.rewrite.mvrewrite.NDVToHll;
import org.apache.doris.rewrite.mvrewrite.ToBitmapToSlotRefRule;
import org.apache.doris.thrift.TQueryGlobals;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Analyzer {
    private static final Logger LOG = LogManager.getLogger(Analyzer.class);
    private ExprSubstitutionMap changeResSmap = new ExprSubstitutionMap();
    private final Set<String> uniqueTableAliasSet_ = Sets.newHashSet();
    private final Multimap<String, TupleDescriptor> tupleByAlias = ArrayListMultimap.create();
    private final Map<String, SlotDescriptor> slotRefMap = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
    private final Map<TupleId, List<ExprId>> tuplePredicates = Maps.newHashMap();
    private final Map<SlotId, List<ExprId>> slotPredicates = Maps.newHashMap();
    private final Set<ExprId> whereClauseConjuncts = Sets.newHashSet();
    private final Map<TupleId, List<Expr>> bufferReuseExprs = Maps.newHashMap();
    private final Map<TupleId, Integer> currentOutputColumn = Maps.newHashMap();
    private String schemaDb;
    private String schemaWild;
    private String schemaTable;
    private boolean hasLimitOffsetClause_ = false;
    private int callDepth = 0;
    private boolean isSubquery = false;
    private boolean isWithClause_ = false;
    private TupleId visibleSemiJoinedTupleId_ = null;
    private boolean isUDFAllowed = true;
    private String timezone = "Asia/Shanghai";
    private final List<RuntimeFilter> assignedRuntimeFilters = new ArrayList<RuntimeFilter>();
    private final GlobalState globalState;
    private final ArrayList<Analyzer> ancestors;
    private final Map<String, View> localViews_ = Maps.newHashMap();
    private final Map<String, TupleDescriptor> aliasMap_ = Maps.newHashMap();
    private final Map<TupleId, TableRef> tableRefMap_ = Maps.newHashMap();
    private final Set<String> ambiguousAliases_ = Sets.newHashSet();
    private boolean hasEmptyResultSet_ = false;
    private boolean hasEmptySpjResultSet_ = false;

    public void setIsSubquery() {
        this.isSubquery = true;
        this.globalState.containsSubquery = true;
    }

    public boolean setHasPlanHints() {
        this.globalState.hasPlanHints = true;
        return true;
    }

    public boolean hasPlanHints() {
        return this.globalState.hasPlanHints;
    }

    public void setIsWithClause() {
        this.isWithClause_ = true;
    }

    public boolean isWithClause() {
        return this.isWithClause_;
    }

    public void setUDFAllowed(boolean val) {
        this.isUDFAllowed = val;
    }

    public boolean isUDFAllowed() {
        return this.isUDFAllowed;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void putEquivalentSlot(SlotId src_sid, SlotId target_sid) {
        this.globalState.equivalentSlots.put(src_sid, target_sid);
    }

    public SlotId getEquivalentSlot(SlotId src_sid) {
        return (SlotId)this.globalState.equivalentSlots.get(src_sid);
    }

    public boolean containEquivalentSlot(SlotId src_sid) {
        return this.globalState.equivalentSlots.containsKey(src_sid);
    }

    public void putAssignedRuntimeFilter(RuntimeFilter rf) {
        this.assignedRuntimeFilters.add(rf);
    }

    public List<RuntimeFilter> getAssignedRuntimeFilter() {
        return this.assignedRuntimeFilters;
    }

    public void clearAssignedRuntimeFilters() {
        this.assignedRuntimeFilters.clear();
    }

    public long getAutoBroadcastJoinThreshold() {
        return this.globalState.autoBroadcastJoinThreshold;
    }

    public Analyzer(Catalog catalog, ConnectContext context) {
        this.ancestors = Lists.newArrayList();
        this.globalState = new GlobalState(catalog, context);
    }

    public Analyzer(Analyzer parentAnalyzer) {
        this(parentAnalyzer, parentAnalyzer.globalState);
        if (parentAnalyzer.isSubquery) {
            this.isSubquery = true;
        }
    }

    private Analyzer(Analyzer parentAnalyzer, GlobalState globalState) {
        this.ancestors = Lists.newArrayList((Object[])new Analyzer[]{parentAnalyzer});
        this.ancestors.addAll(parentAnalyzer.ancestors);
        this.globalState = globalState;
    }

    public static Analyzer createWithNewGlobalState(Analyzer parentAnalyzer) {
        GlobalState globalState = new GlobalState(parentAnalyzer.globalState.catalog, parentAnalyzer.getContext());
        return new Analyzer(parentAnalyzer, globalState);
    }

    public void setIsExplain() {
        this.globalState.isExplain = true;
    }

    public boolean isExplain() {
        return this.globalState.isExplain;
    }

    public int incrementCallDepth() {
        return ++this.callDepth;
    }

    public int decrementCallDepth() {
        return --this.callDepth;
    }

    public int getCallDepth() {
        return this.callDepth;
    }

    public void registerLocalView(View view) throws AnalysisException {
        Preconditions.checkState((boolean)view.isLocalView());
        if (view.hasColLabels()) {
            List<String> viewLabels = view.getColLabels();
            List queryStmtLabels = view.getQueryStmt().getColLabels();
            if (viewLabels.size() > queryStmtLabels.size()) {
                throw new AnalysisException("WITH-clause view '" + view.getName() + "' returns " + queryStmtLabels.size() + " columns, but " + viewLabels.size() + " labels were specified. The number of column labels must be smaller or equal to the number of returned columns.");
            }
        }
        if (this.localViews_.put(view.getName(), view) != null) {
            throw new AnalysisException(String.format("Duplicate table alias: '%s'", view.getName()));
        }
    }

    public static TQueryGlobals createQueryGlobals() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSSS");
        TQueryGlobals queryGlobals = new TQueryGlobals();
        Calendar currentDate = Calendar.getInstance();
        String nowStr = formatter.format(currentDate.getTime());
        queryGlobals.setNowString(nowStr);
        return queryGlobals;
    }

    public void substitute(ExprSubstitutionMap sMap) {
        for (ExprId id : this.globalState.conjuncts.keySet()) {
            if (((Expr)this.globalState.conjuncts.get(id)).substitute(sMap) instanceof BoolLiteral) continue;
            this.globalState.conjuncts.put(id, (Predicate)((Expr)this.globalState.conjuncts.get(id)).substitute(sMap));
        }
    }

    public TupleDescriptor registerTableRef(TableRef ref) throws AnalysisException {
        TupleDescriptor tupleDesc;
        String uniqueAlias = ref.getUniqueAlias();
        if (this.uniqueTableAliasSet_.contains(uniqueAlias)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_NONUNIQ_TABLE, uniqueAlias);
        }
        this.uniqueTableAliasSet_.add(uniqueAlias);
        String unqualifiedAlias = null;
        String[] aliases = ref.getAliases();
        if (aliases.length > 1 && (tupleDesc = this.aliasMap_.get(unqualifiedAlias = aliases[1])) != null) {
            if (tupleDesc.hasExplicitAlias()) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NONUNIQ_TABLE, uniqueAlias);
            } else {
                this.ambiguousAliases_.add(unqualifiedAlias);
            }
        }
        TupleDescriptor result = ref.createTupleDescriptor(this);
        result.setRef(ref);
        result.setAliases(aliases, ref.hasExplicitAlias());
        for (String alias : aliases) {
            this.tupleByAlias.put((Object)alias, (Object)result);
        }
        this.tableRefMap_.put(result.getId(), ref);
        return result;
    }

    public TupleDescriptor registerOlapTable(Table table, TableName tableName, List<String> partitions) {
        TableRef ref = new TableRef(tableName, null, partitions == null ? null : new PartitionNames(false, partitions));
        BaseTableRef tableRef = new BaseTableRef(ref, table, tableName);
        TupleDescriptor result = this.globalState.descTbl.createTupleDescriptor();
        result.setTable(table);
        result.setRef(tableRef);
        result.setAliases(tableRef.getAliases(), ref.hasExplicitAlias());
        for (Column col : table.getBaseSchema(true)) {
            SlotDescriptor slot = this.globalState.descTbl.addSlotDescriptor(result);
            slot.setIsMaterialized(true);
            slot.setColumn(col);
            slot.setIsNullable(col.isAllowNull());
            String key = tableRef.aliases_[0] + "." + col.getName();
            this.slotRefMap.put(key, slot);
        }
        this.globalState.descTbl.computeStatAndMemLayout();
        this.tableRefMap_.put(result.getId(), ref);
        for (String alias : tableRef.getAliases()) {
            this.tupleByAlias.put((Object)alias, (Object)result);
        }
        return result;
    }

    public List<TupleId> getAllTupleIds() {
        return new ArrayList<TupleId>(this.tableRefMap_.keySet());
    }

    public TableRef resolveTableRef(TableRef tableRef) throws AnalysisException {
        Boolean isNotRestoring;
        Database database;
        Table table;
        String dbName;
        if (tableRef.isResolved()) {
            return tableRef;
        }
        TableName tableName = tableRef.getName();
        if (!tableName.isFullyQualified()) {
            String viewAlias = tableName.getTbl();
            Analyzer analyzer = this;
            do {
                View localView;
                if ((localView = analyzer.localViews_.get(viewAlias)) == null) continue;
                return new InlineViewRef(localView, tableRef);
            } while ((analyzer = analyzer.ancestors.isEmpty() ? null : analyzer.ancestors.get(0)) != null);
        }
        if (Strings.isNullOrEmpty((String)(dbName = Strings.isNullOrEmpty((String)(dbName = tableName.getDb())) ? this.getDefaultDb() : ClusterNamespace.getFullName(this.getClusterName(), tableName.getDb())))) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
        }
        if ((table = (database = this.globalState.catalog.getDbOrAnalysisException(dbName)).getTableOrAnalysisException(tableName.getTbl())).getType() == Table.TableType.OLAP && (((OlapTable)table).getState() == OlapTable.OlapTableState.RESTORE || ((OlapTable)table).getState() == OlapTable.OlapTableState.RESTORE_WITH_LOAD) && (isNotRestoring = Boolean.valueOf(((OlapTable)table).getPartitions().stream().filter(partition -> partition.getState() == Partition.PartitionState.RESTORE).collect(Collectors.toList()).isEmpty())).booleanValue()) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_BAD_TABLE_STATE, "RESTORING");
        }
        TableName tblName = new TableName(dbName, tableName.getTbl());
        if (table instanceof View) {
            return new InlineViewRef((View)table, tableRef);
        }
        return new BaseTableRef(tableRef, table, tblName);
    }

    public Table getTableOrAnalysisException(TableName tblName) throws AnalysisException {
        Database db = this.globalState.catalog.getDbOrAnalysisException(tblName.getDb());
        return db.getTableOrAnalysisException(tblName.getTbl());
    }

    public ExprRewriter getExprRewriter() {
        return this.globalState.exprRewriter_;
    }

    public ExprRewriter getMVExprRewriter() {
        return this.globalState.mvExprRewriter;
    }

    public Collection<TupleDescriptor> getDescriptor(TableName name) {
        return this.tupleByAlias.get((Object)name.toString());
    }

    public TupleDescriptor getTupleDesc(TupleId id) {
        return this.globalState.descTbl.getTupleDesc(id);
    }

    public SlotDescriptor getSlotDesc(SlotId id) {
        return this.globalState.descTbl.getSlotDesc(id);
    }

    public SlotDescriptor getSlotDescriptor(String qualifiedColumnName) {
        return this.slotRefMap.get(qualifiedColumnName);
    }

    public SlotDescriptor registerColumnRef(TableName tblName, String colName) throws AnalysisException {
        String key;
        SlotDescriptor result;
        Column col;
        TableName newTblName = tblName;
        TupleDescriptor d = newTblName == null ? this.resolveColumnRef(colName) : this.resolveColumnRef(newTblName, colName);
        if (d == null && this.hasAncestors() && this.isSubquery) {
            d = newTblName == null ? this.getParentAnalyzer().resolveColumnRef(colName) : this.getParentAnalyzer().resolveColumnRef(newTblName, colName);
        }
        if (d == null) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_BAD_FIELD_ERROR, colName, newTblName == null ? "table list" : newTblName.toString());
        }
        if ((col = d.getTable().getColumn(colName)) == null) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_BAD_FIELD_ERROR, colName, newTblName == null ? d.getTable().getName() : newTblName.toString());
        }
        if ((result = this.slotRefMap.get(key = d.getAlias() + "." + col.getName())) != null) {
            result.setMultiRef(true);
            return result;
        }
        result = this.globalState.descTbl.addSlotDescriptor(d);
        result.setColumn(col);
        if (col.isAllowNull() || this.isOuterJoined(d.getId())) {
            result.setIsNullable(true);
        } else {
            result.setIsNullable(false);
        }
        this.slotRefMap.put(key, result);
        return result;
    }

    public SlotDescriptor registerVirtualColumnRef(String colName, Type type, TupleDescriptor tupleDescriptor) throws AnalysisException {
        String key = colName;
        SlotDescriptor result = this.slotRefMap.get(key);
        if (result != null) {
            result.setMultiRef(true);
            return result;
        }
        result = this.addSlotDescriptor(tupleDescriptor);
        Column col = new Column(colName, type);
        result.setColumn(col);
        result.setIsNullable(col.isAllowNull());
        this.slotRefMap.put(key, result);
        return result;
    }

    private TupleDescriptor resolveColumnRef(TableName tblName, String colName) throws AnalysisException {
        TupleDescriptor result = null;
        for (TupleDescriptor desc : this.tupleByAlias.get((Object)tblName.toString())) {
            Column col;
            if (!colName.equalsIgnoreCase("__DORIS_DELETE_SIGN__") && !this.isVisible(desc.getId())) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_ILLEGAL_COLUMN_REFERENCE_ERROR, Joiner.on((String)".").join((Object)tblName.getTbl(), (Object)colName, new Object[0]));
            }
            if ((col = desc.getTable().getColumn(colName)) == null) continue;
            if (result != null) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NON_UNIQ_ERROR, colName);
            }
            result = desc;
        }
        return result;
    }

    private TupleDescriptor resolveColumnRef(String colName) throws AnalysisException {
        TupleDescriptor result = null;
        for (TupleDescriptor desc : this.tupleByAlias.values()) {
            Column col;
            if (!this.isVisible(desc.getId()) || (col = desc.getTable().getColumn(colName)) == null) continue;
            if (result != null) {
                if (result == desc) continue;
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NON_UNIQ_ERROR, colName);
                continue;
            }
            result = desc;
        }
        return result;
    }

    public SlotDescriptor addSlotDescriptor(TupleDescriptor tupleDesc) {
        SlotDescriptor result = this.globalState.descTbl.addSlotDescriptor(tupleDesc);
        this.globalState.blockBySlot.put(result.getId(), this);
        return result;
    }

    public SlotDescriptor copySlotDescriptor(SlotDescriptor srcSlotDesc, TupleDescriptor tupleDesc) {
        SlotDescriptor result = this.globalState.descTbl.addSlotDescriptor(tupleDesc);
        this.globalState.blockBySlot.put(result.getId(), this);
        result.setStats(srcSlotDesc.getStats());
        result.setType(srcSlotDesc.getType());
        result.setIsNullable(srcSlotDesc.getIsNullable());
        return result;
    }

    public void registerInlineViewTupleId(TupleId tupleId) {
        this.globalState.inlineViewTupleIds.add(tupleId);
    }

    public void registerFullOuterJoinedConjunct(Expr e) {
        Preconditions.checkState((!this.globalState.fullOuterJoinedConjuncts.containsKey(e.getId()) ? 1 : 0) != 0);
        ArrayList tids = Lists.newArrayList();
        e.getIds(tids, null);
        for (TupleId tid : tids) {
            if (!this.globalState.fullOuterJoinedTupleIds.containsKey(tid)) continue;
            TableRef currentOuterJoin = this.globalState.fullOuterJoinedTupleIds.get(tid);
            this.globalState.fullOuterJoinedConjuncts.put(e.getId(), currentOuterJoin);
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("registerFullOuterJoinedConjunct: " + this.globalState.fullOuterJoinedConjuncts.toString());
        }
    }

    public void registerFullOuterJoinedTids(List<TupleId> tids, TableRef rhsRef) {
        for (TupleId tid : tids) {
            this.globalState.fullOuterJoinedTupleIds.put(tid, rhsRef);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("registerFullOuterJoinedTids: " + this.globalState.fullOuterJoinedTupleIds.toString());
        }
    }

    public void registerOuterJoinedTids(List<TupleId> tids, TableRef rhsRef) {
        for (TupleId tid : tids) {
            this.globalState.outerJoinedTupleIds.put(tid, rhsRef);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("registerOuterJoinedTids: " + this.globalState.outerJoinedTupleIds.toString());
        }
    }

    public void registerSemiJoinedTid(TupleId tid, TableRef rhsRef) {
        this.globalState.semiJoinedTupleIds.put(tid, rhsRef);
    }

    public void registerAnyTwoTalesJoinOperator(Pair<TupleId, TupleId> tids, JoinOperator joinOperator) {
        if (joinOperator == null) {
            joinOperator = JoinOperator.INNER_JOIN;
        }
        this.globalState.anyTwoTalesJoinOperator.put(tids, joinOperator);
    }

    public void registerOnSlotEqSlotExpr(Expr expr) {
        this.globalState.onSlotEqSlotExpr.add(expr);
    }

    public void registerOnSlotEqSlotDeDuplication(Pair<Expr, Expr> pair) {
        this.globalState.onSlotEqSlotDeDuplication.add(pair);
    }

    public void registerOnSlotToLiteralExpr(Expr expr) {
        this.globalState.onSlotToLiteralExpr.add(expr);
    }

    public void registerOnSlotToLiteralDeDuplication(Pair<Expr, Expr> pair) {
        this.globalState.onSlotToLiteralDeDuplication.add(pair);
    }

    public void registerInExpr(Expr expr) {
        this.globalState.onInExpr.add(expr);
    }

    public void registerInDeDuplication(Expr expr) {
        this.globalState.onInDeDuplication.add(expr);
    }

    public void registerOnIsNullExpr(Expr expr) {
        this.globalState.onIsNullExpr.add(expr);
    }

    public void registerOnIsNullDeDuplication(Expr expr) {
        this.globalState.onIsNullDeDuplication.add(expr);
    }

    public void registerGlobalSlotToLiteralDeDuplication(Pair<Expr, Expr> pair) {
        this.globalState.globalSlotToLiteralDeDuplication.add(pair);
    }

    public void registerGlobalInDeDuplication(Expr expr) {
        this.globalState.globalInDeDuplication.add(expr);
    }

    public void registerConjunct(Expr e, TupleId tupleId) throws AnalysisException {
        ArrayList exprs = Lists.newArrayList();
        exprs.add(e);
        this.registerConjuncts((List<Expr>)exprs, tupleId);
    }

    public void registerConjuncts(List<Expr> l, TupleId tupleId) throws AnalysisException {
        ArrayList tupleIds = Lists.newArrayList();
        tupleIds.add(tupleId);
        this.registerConjuncts(l, tupleIds);
    }

    public void registerConjunct(Expr e, List<TupleId> tupleIds) throws AnalysisException {
        ArrayList exprs = Lists.newArrayList();
        exprs.add(e);
        this.registerConjuncts((List<Expr>)exprs, tupleIds);
    }

    public void registerConjuncts(List<Expr> l, List<TupleId> ids) throws AnalysisException {
        for (Expr e : l) {
            this.registerConjuncts(e, true, ids);
        }
    }

    public void registerConjuncts(Expr e, boolean fromHavingClause) throws AnalysisException {
        this.registerConjuncts(e, fromHavingClause, null);
    }

    public void registerConjuncts(Expr e, boolean fromHavingClause, List<TupleId> ids) throws AnalysisException {
        for (Expr conjunct : e.getConjuncts()) {
            this.registerConjunct(conjunct);
            if (ids != null) {
                for (TupleId id : ids) {
                    this.registerConstantConjunct(id, conjunct);
                }
            }
            this.markConstantConjunct(conjunct, fromHavingClause);
        }
    }

    private void registerConstantConjunct(TupleId id, Expr e) {
        if (id != null && e.isConstant()) {
            HashSet set = this.globalState.constantConjunct.get(id);
            if (set == null) {
                set = Sets.newHashSet();
                this.globalState.constantConjunct.put(id, set);
            }
            set.add(e);
        }
    }

    void registerExprId(Expr expr) {
        expr.setId((ExprId)this.globalState.conjunctIdGenerator.getNextId());
    }

    private void registerConjunct(Expr e) {
        ArrayList conjunctIds;
        e.setId((ExprId)this.globalState.conjunctIdGenerator.getNextId());
        this.globalState.conjuncts.put(e.getId(), e);
        ArrayList tupleIds = Lists.newArrayList();
        ArrayList slotIds = Lists.newArrayList();
        e.getIds(tupleIds, slotIds);
        this.registerFullOuterJoinedConjunct(e);
        for (Id id : tupleIds) {
            if (!this.tuplePredicates.containsKey(id)) {
                conjunctIds = Lists.newArrayList();
                conjunctIds.add(e.getId());
                this.tuplePredicates.put((TupleId)id, conjunctIds);
                continue;
            }
            this.tuplePredicates.get(id).add(e.getId());
        }
        for (Id id : slotIds) {
            if (!this.slotPredicates.containsKey(id)) {
                conjunctIds = Lists.newArrayList();
                conjunctIds.add(e.getId());
                this.slotPredicates.put((SlotId)id, conjunctIds);
                continue;
            }
            this.slotPredicates.get(id).add(e.getId());
        }
        if (!(e instanceof BinaryPredicate)) {
            return;
        }
        BinaryPredicate binaryPred = (BinaryPredicate)e;
        if (!binaryPred.getOp().isEquivalence()) {
            return;
        }
        if (tupleIds.size() < 2) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            ArrayList lhsTupleIds = Lists.newArrayList();
            ((Expr)binaryPred.getChild(i)).getIds(lhsTupleIds, null);
            if (lhsTupleIds.size() != 1) continue;
            if (!this.globalState.eqJoinConjuncts.containsKey(lhsTupleIds.get(0))) {
                ArrayList conjunctIds2 = Lists.newArrayList();
                conjunctIds2.add(e.getId());
                this.globalState.eqJoinConjuncts.put((TupleId)lhsTupleIds.get(0), conjunctIds2);
            } else {
                ((List)this.globalState.eqJoinConjuncts.get(lhsTupleIds.get(0))).add(e.getId());
            }
            binaryPred.setIsEqJoinConjunct(true);
        }
    }

    public void createAuxEquivPredicate(Expr lhs, Expr rhs) {
        if (lhs instanceof NullLiteral || rhs instanceof NullLiteral || lhs.getType().isNull() || rhs.getType().isNull()) {
            return;
        }
        BinaryPredicate p = new BinaryPredicate(BinaryPredicate.Operator.EQ, lhs, rhs);
        p.setIsAuxExpr();
        if (LOG.isDebugEnabled()) {
            LOG.debug("register equiv predicate: " + p.toSql() + " " + p.debugString());
        }
        this.registerConjunct(p);
    }

    public Set<ExprId> getAssignedConjuncts() {
        return Sets.newHashSet((Iterable)this.globalState.assignedConjuncts);
    }

    public void setAssignedConjuncts(Set<ExprId> assigned) {
        if (assigned != null) {
            this.globalState.assignedConjuncts = Sets.newHashSet(assigned);
        }
    }

    public List<Expr> getUnassignedConjuncts(List<TupleId> tupleIds) {
        ArrayList result = Lists.newArrayList();
        for (Expr e : this.getUnassignedConjuncts(tupleIds, true)) {
            if (!this.canEvalPredicate(tupleIds, e)) continue;
            result.add(e);
        }
        return result;
    }

    public List<Expr> getUnassignedConjuncts(List<TupleId> tupleIds, boolean inclOjConjuncts) {
        ArrayList result = Lists.newArrayList();
        for (Expr e : this.globalState.conjuncts.values()) {
            if (e.isConstant()) {
                boolean isBoundByTuple = false;
                for (TupleId id : tupleIds) {
                    Set<Expr> exprSet = this.globalState.constantConjunct.get(id);
                    if (exprSet == null || !exprSet.contains(e)) continue;
                    isBoundByTuple = true;
                    break;
                }
                if (!isBoundByTuple) continue;
            }
            if (!e.isBoundByTupleIds(tupleIds) || e.isAuxExpr() || this.globalState.assignedConjuncts.contains(e.getId()) || (!inclOjConjuncts || e.isConstant()) && this.globalState.ojClauseByConjunct.containsKey(e.getId())) continue;
            result.add(e);
        }
        return result;
    }

    public List<Expr> getConjuncts(List<TupleId> tupleIds) {
        ArrayList result = Lists.newArrayList();
        ArrayList eqJoinConjunctIds = Lists.newArrayList();
        for (List conjuncts : this.globalState.eqJoinConjuncts.values()) {
            eqJoinConjunctIds.addAll(conjuncts);
        }
        for (Expr e : this.globalState.conjuncts.values()) {
            if (!e.isBoundByTupleIds(tupleIds) || e.isAuxExpr() || eqJoinConjunctIds.contains(e.getId()) || this.globalState.ojClauseByConjunct.containsKey(e.getId()) || this.globalState.sjClauseByConjunct.containsKey(e.getId()) || !this.canEvalPredicate(tupleIds, e)) continue;
            result.add(e);
        }
        return result;
    }

    public List<Expr> getAllUnassignedConjuncts(List<TupleId> tupleIds) {
        ArrayList result = Lists.newArrayList();
        for (Expr e : this.globalState.conjuncts.values()) {
            if (e.isAuxExpr() || !e.isBoundByTupleIds(tupleIds) || this.globalState.assignedConjuncts.contains(e.getId()) || this.globalState.ojClauseByConjunct.containsKey(e.getId())) continue;
            result.add(e);
        }
        return result;
    }

    public List<Expr> getUnassignedOjConjuncts(TableRef ref) {
        Preconditions.checkState((boolean)ref.getJoinOp().isOuterJoin());
        ArrayList result = Lists.newArrayList();
        List<ExprId> candidates = this.globalState.conjunctsByOjClause.get(ref.getId());
        if (candidates == null) {
            return result;
        }
        for (ExprId conjunctId : candidates) {
            if (this.globalState.assignedConjuncts.contains(conjunctId)) continue;
            Expr e = (Expr)this.globalState.conjuncts.get(conjunctId);
            Preconditions.checkState((e != null ? 1 : 0) != 0);
            result.add(e);
        }
        return result;
    }

    public boolean evalAfterJoin(Expr e) {
        ArrayList tids = Lists.newArrayList();
        e.getIds(tids, null);
        if (tids.isEmpty()) {
            return false;
        }
        return tids.size() > 1 || this.isOjConjunct(e) || this.isFullOuterJoined(e) || this.isOuterJoined((TupleId)tids.get(0)) && (!e.isOnClauseConjunct() || this.isIjConjunct(e)) || this.isAntiJoinedConjunct(e) && !this.isSemiJoined((TupleId)tids.get(0));
    }

    public TableName getFqTableName(TableName tableName) {
        if (tableName.isFullyQualified()) {
            return tableName;
        }
        return new TableName(this.getDefaultDb(), tableName.getTbl());
    }

    public TupleId getTupleId(SlotId slotId) {
        return this.globalState.descTbl.getSlotDesc(slotId).getParent().getId();
    }

    public TableRef getLastOjClause(TupleId id) {
        return (TableRef)this.globalState.outerJoinedTupleIds.get(id);
    }

    public JoinOperator getAnyTwoTablesJoinOp(Pair<TupleId, TupleId> tids) {
        return this.globalState.anyTwoTalesJoinOperator.get(tids);
    }

    public boolean isContainTupleIds(Pair<TupleId, TupleId> tids) {
        return this.globalState.anyTwoTalesJoinOperator.containsKey(tids);
    }

    public boolean isWhereClauseConjunct(Expr e) {
        return this.whereClauseConjuncts.contains(e.getId());
    }

    public boolean isSemiJoined(TupleId tid) {
        return this.globalState.semiJoinedTupleIds.containsKey(tid);
    }

    public boolean isAntiJoinedConjunct(Expr e) {
        return this.getAntiJoinRef(e) != null;
    }

    public TableRef getAntiJoinRef(Expr e) {
        TableRef tblRef = this.globalState.sjClauseByConjunct.get(e.getId());
        if (tblRef == null) {
            return null;
        }
        return tblRef.getJoinOp().isAntiJoin() ? tblRef : null;
    }

    public boolean isFullOuterJoined(TupleId tid) {
        return this.globalState.fullOuterJoinedTupleIds.containsKey(tid);
    }

    public boolean isFullOuterJoined(SlotId sid) {
        return this.isFullOuterJoined(this.getTupleId(sid));
    }

    public boolean isVisible(TupleId tid) {
        return tid == this.visibleSemiJoinedTupleId_ || !this.isSemiJoined(tid);
    }

    public boolean containsOuterJoinedTid(List<TupleId> tids) {
        for (TupleId tid : tids) {
            if (!this.isOuterJoined(tid)) continue;
            return true;
        }
        return false;
    }

    public DescriptorTable getDescTbl() {
        return this.globalState.descTbl;
    }

    public Catalog getCatalog() {
        return this.globalState.catalog;
    }

    public Set<String> getAliases() {
        return this.uniqueTableAliasSet_;
    }

    public List<Expr> getAllConjuncts(TupleId id) {
        List<ExprId> conjunctIds = this.tuplePredicates.get(id);
        if (conjunctIds == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (ExprId conjunctId : conjunctIds) {
            Expr e = (Expr)this.globalState.conjuncts.get(conjunctId);
            Preconditions.checkState((e != null ? 1 : 0) != 0);
            result.add(e);
        }
        return result;
    }

    public List<Expr> getRemainConjuncts(List<TupleId> tupleIds) {
        HashSet remainConjunctIds = Sets.newHashSet();
        for (TupleId tupleId : tupleIds) {
            if (this.tuplePredicates.get(tupleId) == null) continue;
            remainConjunctIds.addAll((Collection)this.tuplePredicates.get(tupleId));
        }
        remainConjunctIds.removeAll(this.globalState.assignedConjuncts);
        ArrayList result = Lists.newArrayList();
        for (ExprId conjunctId : remainConjunctIds) {
            Expr e = (Expr)this.globalState.conjuncts.get(conjunctId);
            Preconditions.checkState((e != null ? 1 : 0) != 0);
            if (e.isAuxExpr()) continue;
            result.add(e);
        }
        return result;
    }

    public List<Expr> getOnSlotEqSlotExpr() {
        return new ArrayList<Expr>(this.globalState.onSlotEqSlotExpr);
    }

    public Set<Pair<Expr, Expr>> getOnSlotEqSlotDeDuplication() {
        return Sets.newHashSet((Iterable)this.globalState.onSlotEqSlotDeDuplication);
    }

    public List<Expr> getOnSlotToLiteralExpr() {
        return new ArrayList<Expr>(this.globalState.onSlotToLiteralExpr);
    }

    public Set<Pair<Expr, Expr>> getOnSlotToLiteralDeDuplication() {
        return Sets.newHashSet((Iterable)this.globalState.onSlotToLiteralDeDuplication);
    }

    public List<Expr> getInExpr() {
        return new ArrayList<Expr>(this.globalState.onInExpr);
    }

    public Set<Expr> getInDeDuplication() {
        return Sets.newHashSet((Iterable)this.globalState.onInDeDuplication);
    }

    public List<Expr> getOnIsNullExpr() {
        return new ArrayList<Expr>(this.globalState.onIsNullExpr);
    }

    public Set<Expr> getOnIsNullDeDuplication() {
        return Sets.newHashSet((Iterable)this.globalState.onIsNullDeDuplication);
    }

    public Set<Pair<Expr, Expr>> getGlobalSlotToLiteralDeDuplication() {
        return Sets.newHashSet((Iterable)this.globalState.globalSlotToLiteralDeDuplication);
    }

    public Set<Expr> getGlobalInDeDuplication() {
        return Sets.newHashSet((Iterable)this.globalState.globalInDeDuplication);
    }

    public void setVisibleSemiJoinedTuple(TupleId tid) {
        Preconditions.checkState((tid == null || this.globalState.semiJoinedTupleIds.containsKey(tid) ? 1 : 0) != 0);
        Preconditions.checkState((tid == null || this.visibleSemiJoinedTupleId_ == null ? 1 : 0) != 0);
        this.visibleSemiJoinedTupleId_ = tid;
    }

    public boolean isRootAnalyzer() {
        return this.ancestors.isEmpty();
    }

    public boolean hasAncestors() {
        return !this.ancestors.isEmpty();
    }

    public Analyzer getParentAnalyzer() {
        return this.hasAncestors() ? this.ancestors.get(0) : null;
    }

    public boolean hasEmptyResultSet() {
        return this.hasEmptyResultSet_;
    }

    public void setHasEmptyResultSet() {
        this.hasEmptyResultSet_ = true;
    }

    public boolean hasEmptySpjResultSet() {
        return this.hasEmptySpjResultSet_;
    }

    public void setHasLimitOffsetClause(boolean hasLimitOffset) {
        this.hasLimitOffsetClause_ = hasLimitOffset;
    }

    public void registerOnClauseConjuncts(List<Expr> conjuncts, TableRef rhsRef) throws AnalysisException {
        Preconditions.checkNotNull((Object)rhsRef);
        Preconditions.checkNotNull(conjuncts);
        ArrayList ojConjuncts = null;
        if (rhsRef.getJoinOp().isOuterJoin() && (ojConjuncts = this.globalState.conjunctsByOjClause.get(rhsRef.getId())) == null) {
            ojConjuncts = Lists.newArrayList();
            this.globalState.conjunctsByOjClause.put(rhsRef.getId(), ojConjuncts);
        }
        for (Expr conjunct : conjuncts) {
            conjunct.setIsOnClauseConjunct(true);
            this.registerConjunct(conjunct);
            if (rhsRef.getJoinOp().isOuterJoin()) {
                this.globalState.ojClauseByConjunct.put(conjunct.getId(), rhsRef);
                ojConjuncts.add(conjunct.getId());
            }
            if (rhsRef.getJoinOp().isSemiJoin()) {
                this.globalState.sjClauseByConjunct.put(conjunct.getId(), rhsRef);
            }
            if (rhsRef.getJoinOp().isInnerJoin()) {
                this.globalState.ijClauseByConjunct.put(conjunct.getId(), rhsRef);
            }
            this.markConstantConjunct(conjunct, false);
        }
    }

    private void markConstantConjunct(Expr conjunct, boolean fromHavingClause) throws AnalysisException {
        if (!conjunct.isConstant() || this.isOjConjunct(conjunct)) {
            return;
        }
        if (!fromHavingClause && !this.hasEmptySpjResultSet_ || fromHavingClause && !this.hasEmptyResultSet_) {
            try {
                Expr newConjunct;
                if (conjunct instanceof BetweenPredicate) {
                    ExprRewriter rewriter = new ExprRewriter(BetweenToCompoundRule.INSTANCE);
                    conjunct = rewriter.rewrite(conjunct, this);
                    conjunct.analyze(this);
                }
                if ((newConjunct = conjunct.getResultValue()) instanceof BoolLiteral) {
                    BoolLiteral value = (BoolLiteral)newConjunct;
                    if (!value.getValue()) {
                        if (fromHavingClause) {
                            this.hasEmptyResultSet_ = true;
                        } else {
                            this.hasEmptySpjResultSet_ = true;
                        }
                    }
                    this.markConjunctAssigned(conjunct);
                }
                if (newConjunct instanceof NullLiteral) {
                    if (fromHavingClause) {
                        this.hasEmptyResultSet_ = true;
                    } else {
                        this.hasEmptySpjResultSet_ = true;
                    }
                    this.markConjunctAssigned(conjunct);
                }
            }
            catch (AnalysisException ex) {
                throw new AnalysisException("Error evaluating \"" + conjunct.toSql() + "\"", ex);
            }
        }
    }

    public boolean isOjConjunct(Expr e) {
        return this.globalState.ojClauseByConjunct.containsKey(e.getId());
    }

    public boolean isIjConjunct(Expr e) {
        return this.globalState.ijClauseByConjunct.containsKey(e.getId());
    }

    public boolean isSjConjunct(Expr e) {
        return this.globalState.sjClauseByConjunct.containsKey(e.getId());
    }

    public TableRef getFullOuterJoinRef(Expr e) {
        return this.globalState.fullOuterJoinedConjuncts.get(e.getId());
    }

    public boolean isFullOuterJoined(Expr e) {
        return this.globalState.fullOuterJoinedConjuncts.containsKey(e.getId());
    }

    public TableRef getOjRef(Expr e) {
        return (TableRef)this.globalState.ojClauseByConjunct.get(e.getId());
    }

    public boolean canEvalOuterJoinedConjunct(Expr e, List<TupleId> tids) {
        TableRef outerJoin = this.getOjRef(e);
        if (outerJoin == null) {
            return true;
        }
        return tids.containsAll(outerJoin.getAllTableRefIds());
    }

    public List<Expr> getEqJoinConjuncts(List<TupleId> lhsTblRefIds, List<TupleId> rhsTblRefIds) {
        ArrayList conjunctIds = Lists.newArrayList();
        for (TupleId rhsId : rhsTblRefIds) {
            List cids = (List)this.globalState.eqJoinConjuncts.get(rhsId);
            if (cids == null) continue;
            for (ExprId eid : cids) {
                if (conjunctIds.contains(eid)) continue;
                conjunctIds.add(eid);
            }
        }
        List<ExprId> ojClauseConjuncts = null;
        if (rhsTblRefIds.size() == 1) {
            ojClauseConjuncts = this.globalState.conjunctsByOjClause.get(rhsTblRefIds.get(0));
        }
        ArrayList nodeTblRefIds = Lists.newArrayList(lhsTblRefIds);
        nodeTblRefIds.addAll(rhsTblRefIds);
        ArrayList result = Lists.newArrayList();
        for (ExprId conjunctId : conjunctIds) {
            Expr e = (Expr)this.globalState.conjuncts.get(conjunctId);
            Preconditions.checkState((e != null ? 1 : 0) != 0);
            if (!this.canEvalFullOuterJoinedConjunct(e, nodeTblRefIds) || !this.canEvalAntiJoinedConjunct(e, nodeTblRefIds) || !this.canEvalOuterJoinedConjunct(e, nodeTblRefIds) || ojClauseConjuncts != null && !ojClauseConjuncts.contains(conjunctId)) continue;
            result.add(e);
        }
        return result;
    }

    public List<Expr> getEqJoinConjuncts(TupleId id) {
        List conjunctIds = (List)this.globalState.eqJoinConjuncts.get(id);
        if (conjunctIds == null) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        for (ExprId conjunctId : conjunctIds) {
            Expr e = (Expr)this.globalState.conjuncts.get(conjunctId);
            Preconditions.checkState((e != null ? 1 : 0) != 0);
            result.add(e);
        }
        return result;
    }

    public List<Expr> getEqJoinConjunctsExcludeAuxPredicates(TupleId id) {
        List<Expr> candidateEqJoinPredicates = this.getEqJoinConjuncts(id);
        Iterator<Expr> iterator = candidateEqJoinPredicates.iterator();
        while (iterator.hasNext()) {
            Expr expr = iterator.next();
            if (!expr.isAuxExpr()) continue;
            iterator.remove();
        }
        return candidateEqJoinPredicates;
    }

    public List<Expr> getBufferReuseConjuncts(TupleId id) {
        ArrayList result = this.bufferReuseExprs.get(id);
        if (null == result) {
            result = Lists.newArrayList();
            this.bufferReuseExprs.put(id, result);
        }
        return result;
    }

    public int getCurrentOutputColumn(TupleId id) {
        Integer result = this.currentOutputColumn.get(id);
        if (null == result) {
            return this.getTupleDesc(id).getSlots().size();
        }
        return result;
    }

    public void setCurrentOutputColumn(TupleId id, int v) {
        this.currentOutputColumn.put(id, v);
    }

    public void markConjunctsAssigned(List<Expr> conjuncts) {
        if (conjuncts == null) {
            return;
        }
        for (Expr p : conjuncts) {
            this.globalState.assignedConjuncts.add(p.getId());
        }
    }

    public void markConjunctAssigned(Expr conjunct) {
        this.globalState.assignedConjuncts.add(conjunct.getId());
    }

    public boolean hasUnassignedConjuncts() {
        return !this.globalState.assignedConjuncts.containsAll(this.globalState.conjuncts.keySet());
    }

    public Type getCompatibleType(Type lastCompatibleType, Expr lastCompatibleExpr, Expr expr) throws AnalysisException {
        Type newCompatibleType = lastCompatibleType == null ? expr.getType() : Type.getAssignmentCompatibleType(lastCompatibleType, expr.getType(), false);
        if (!newCompatibleType.isValid()) {
            throw new AnalysisException(String.format("Incompatible return types '%s' and '%s' of exprs '%s' and '%s'.", lastCompatibleType.toSql(), expr.getType().toSql(), lastCompatibleExpr.toSql(), expr.toSql()));
        }
        return newCompatibleType;
    }

    public Type castAllToCompatibleType(List<Expr> exprs) throws AnalysisException {
        int i;
        exprs.get(0).analyze(this);
        Type compatibleType = exprs.get(0).getType();
        for (i = 1; i < exprs.size(); ++i) {
            exprs.get(i).analyze(this);
            compatibleType = Type.getCmpType(compatibleType, exprs.get(i).getType());
        }
        if (compatibleType.equals(Type.VARCHAR) && exprs.get(0).getType().isDateType()) {
            compatibleType = Type.DATETIME;
        }
        for (i = 0; i < exprs.size(); ++i) {
            if (exprs.get(i).getType() == compatibleType) continue;
            Expr castExpr = exprs.get(i).castTo(compatibleType);
            exprs.set(i, castExpr);
        }
        return compatibleType;
    }

    public void castToSetOpsCompatibleTypes(List<List<Expr>> exprLists) throws AnalysisException {
        if (exprLists == null || exprLists.size() < 2) {
            return;
        }
        List<Expr> firstList = exprLists.get(0);
        for (int i = 0; i < firstList.size(); ++i) {
            int j;
            Type compatibleType = firstList.get(i).getType();
            Expr lastCompatibleExpr = firstList.get(i);
            for (j = 1; j < exprLists.size(); ++j) {
                Preconditions.checkState((exprLists.get(j).size() == firstList.size() ? 1 : 0) != 0);
                compatibleType = this.getCompatibleType(compatibleType, lastCompatibleExpr, exprLists.get(j).get(i));
                lastCompatibleExpr = exprLists.get(j).get(i);
            }
            for (j = 0; j < exprLists.size(); ++j) {
                if (exprLists.get(j).get(i).getType().equals(compatibleType)) continue;
                Expr castExpr = exprLists.get(j).get(i).castTo(compatibleType);
                exprLists.get(j).set(i, castExpr);
            }
        }
    }

    public long getConnectId() {
        return this.globalState.context.getConnectionId();
    }

    public String getDefaultDb() {
        return this.globalState.context.getDatabase();
    }

    public String getClusterName() {
        return this.globalState.context.getClusterName();
    }

    public String getQualifiedUser() {
        return this.globalState.context.getQualifiedUser();
    }

    public String getUserIdentity(boolean currentUser) {
        if (currentUser) {
            return "";
        }
        return this.getQualifiedUser() + "@" + ConnectContext.get().getRemoteIP();
    }

    public String getSchemaDb() {
        return this.schemaDb;
    }

    public String getSchemaTable() {
        return this.schemaTable;
    }

    public ConnectContext getContext() {
        return this.globalState.context;
    }

    public String getSchemaWild() {
        return this.schemaWild;
    }

    public TQueryGlobals getQueryGlobals() {
        return new TQueryGlobals();
    }

    public void setSchemaInfo(String db, String table, String wild) {
        this.schemaDb = db;
        this.schemaTable = table;
        this.schemaWild = wild;
    }

    public String getTargetDbName(FunctionName fnName) {
        return fnName.isFullyQualified() ? fnName.getDb() : this.getDefaultDb();
    }

    public ExprSubstitutionMap getChangeResSmap() {
        return this.changeResSmap;
    }

    public void setChangeResSmap(ExprSubstitutionMap changeResSmap) {
        this.changeResSmap = changeResSmap;
    }

    public boolean enableStarJoinReorder() {
        if (this.globalState.context == null) {
            return false;
        }
        return !this.globalState.context.getSessionVariable().isEnableJoinReorderBasedCost() && !this.globalState.context.getSessionVariable().isDisableJoinReorder();
    }

    public boolean enableInferPredicate() {
        if (this.globalState.context == null) {
            return false;
        }
        return this.globalState.context.getSessionVariable().isEnableInferPredicate();
    }

    public boolean partitionPruneV2Enabled() {
        if (this.globalState.context == null) {
            return true;
        }
        return this.globalState.context.getSessionVariable().getPartitionPruneAlgorithmVersion() == 2;
    }

    public boolean safeIsEnableJoinReorderBasedCost() {
        if (this.globalState.context == null) {
            return false;
        }
        return this.globalState.context.getSessionVariable().isEnableJoinReorderBasedCost() && !this.globalState.context.getSessionVariable().isDisableJoinReorder();
    }

    public boolean safeIsEnableFoldConstantByBe() {
        if (this.globalState.context == null) {
            return false;
        }
        return this.globalState.context.getSessionVariable().isEnableFoldConstantByBe();
    }

    private boolean canEvalPredicate(PlanNode node, Expr e) {
        return this.canEvalPredicate(node.getTblRefIds(), e);
    }

    public boolean canEvalPredicate(List<TupleId> tupleIds, Expr e) {
        if (!e.isBoundByTupleIds(tupleIds)) {
            return false;
        }
        ArrayList tids = Lists.newArrayList();
        e.getIds(tids, null);
        if (tids.isEmpty()) {
            return true;
        }
        if (e.isOnClauseConjunct()) {
            if (this.isAntiJoinedConjunct(e)) {
                return this.canEvalAntiJoinedConjunct(e, tupleIds);
            }
            if (this.isIjConjunct(e) || this.isSjConjunct(e)) {
                if (!this.containsOuterJoinedTid(tids)) {
                    return true;
                }
                TableRef onClauseTableRef = null;
                onClauseTableRef = this.isIjConjunct(e) ? this.globalState.ijClauseByConjunct.get(e.getId()) : this.globalState.sjClauseByConjunct.get(e.getId());
                Preconditions.checkNotNull((Object)onClauseTableRef);
                return tupleIds.containsAll(onClauseTableRef.getAllTableRefIds());
            }
            if (this.isFullOuterJoined(e)) {
                return this.canEvalFullOuterJoinedConjunct(e, tupleIds);
            }
            if (this.isOjConjunct(e)) {
                if (tids.size() > 1) {
                    return false;
                }
                TupleId tid = (TupleId)tids.get(0);
                return this.globalState.ojClauseByConjunct.get(e.getId()) == this.getLastOjClause(tid);
            }
        }
        for (TupleId tid : tids) {
            TableRef rhsRef = this.getLastOjClause(tid);
            if (rhsRef == null || tupleIds.containsAll(rhsRef.getAllTupleIds())) continue;
            return false;
        }
        return true;
    }

    public boolean canEvalAntiJoinedConjunct(Expr e, List<TupleId> nodeTupleIds) {
        TableRef antiJoinRef = this.getAntiJoinRef(e);
        if (antiJoinRef == null) {
            return true;
        }
        ArrayList tids = Lists.newArrayList();
        e.getIds(tids, null);
        if (tids.size() > 1) {
            return nodeTupleIds.containsAll(antiJoinRef.getAllTableRefIds()) && antiJoinRef.getAllTableRefIds().containsAll(nodeTupleIds);
        }
        return this.globalState.semiJoinedTupleIds.containsKey(tids.get(0));
    }

    public boolean canEvalFullOuterJoinedConjunct(Expr e, List<TupleId> tids) {
        TableRef fullOuterJoin = this.getFullOuterJoinRef(e);
        if (fullOuterJoin == null) {
            return true;
        }
        return tids.containsAll(fullOuterJoin.getAllTableRefIds());
    }

    public List<Expr> getUnassignedConjuncts(PlanNode node) {
        return this.getUnassignedConjuncts(node.getTblRefIds());
    }

    public boolean evalByJoin(Expr e) {
        ArrayList tids = Lists.newArrayList();
        e.getIds(tids, null);
        if (tids.isEmpty()) {
            return false;
        }
        return tids.size() > 1 || this.globalState.ojClauseByConjunct.containsKey(e.getId()) || this.globalState.outerJoinedTupleIds.containsKey(e.getId()) && this.whereClauseConjuncts.contains(e.getId()) || this.globalState.conjunctsByOjClause.containsKey(e.getId());
    }

    public void materializeSlots(List<Expr> exprs) {
        ArrayList slotIds = Lists.newArrayList();
        for (Expr e : exprs) {
            Preconditions.checkState((boolean)e.isAnalyzed);
            e.getIds(null, slotIds);
        }
        for (TupleDescriptor tupleDesc : this.getDescTbl().getTupleDescs()) {
            for (SlotDescriptor slotDesc : tupleDesc.getSlots()) {
                if (!slotIds.contains(slotDesc.getId())) continue;
                slotDesc.setIsMaterialized(true);
            }
        }
    }

    public Map<String, View> getLocalViews() {
        return this.localViews_;
    }

    public boolean isOuterJoined(TupleId tid) {
        return this.globalState.outerJoinedTupleIds.containsKey(tid);
    }

    public boolean isInlineView(TupleId tid) {
        return this.globalState.inlineViewTupleIds.contains(tid);
    }

    public boolean containSubquery() {
        return this.globalState.containsSubquery;
    }

    public void markRefdSlots(Analyzer analyzer, PlanNode planRoot, List<Expr> outputExprs, AnalyticInfo analyticInfo) {
        if (planRoot == null) {
            return;
        }
        ArrayList refdIdList = Lists.newArrayList();
        planRoot.getMaterializedIds(analyzer, refdIdList);
        if (outputExprs != null) {
            Expr.getIds(outputExprs, null, refdIdList);
        }
        HashSet refdIds = Sets.newHashSet((Iterable)refdIdList);
        for (TupleDescriptor tupleDesc : analyzer.getDescTbl().getTupleDescs()) {
            for (SlotDescriptor slotDesc : tupleDesc.getSlots()) {
                if (!refdIds.contains(slotDesc.getId())) continue;
                slotDesc.setIsMaterialized(true);
            }
        }
        if (analyticInfo != null) {
            ArrayList<SlotDescriptor> list = analyticInfo.getOutputTupleDesc().getSlots();
            for (SlotDescriptor slotDesc : list) {
                if (!refdIds.contains(slotDesc.getId())) continue;
                slotDesc.setIsMaterialized(true);
            }
        }
        if (outputExprs == null) {
            ArrayList<TupleId> tids = planRoot.getTupleIds();
            for (TupleId tid : tids) {
                TupleDescriptor tupleDesc = analyzer.getDescTbl().getTupleDesc(tid);
                for (SlotDescriptor slotDesc : tupleDesc.getSlots()) {
                    slotDesc.setIsMaterialized(true);
                }
            }
        }
    }

    public boolean hasValueTransfer(SlotId a, SlotId b) {
        return this.getValueTransferTargets(a).contains(b);
    }

    public List<SlotId> getValueTransferTargets(SlotId srcSid) {
        ArrayList<SlotId> result = new ArrayList<SlotId>();
        result.add(srcSid);
        SlotId equalSlot = srcSid;
        while (this.containEquivalentSlot(equalSlot)) {
            result.add(this.getEquivalentSlot(equalSlot));
            equalSlot = this.getEquivalentSlot(equalSlot);
        }
        return result;
    }

    public boolean hasOuterJoinedValueTransferTarget(List<SlotId> sids) {
        for (SlotId srcSid : sids) {
            for (SlotId dstSid : this.getValueTransferTargets(srcSid)) {
                if (!this.isOuterJoined(this.getTupleId(dstSid))) continue;
                return true;
            }
        }
        return false;
    }

    public void registerOuterJoinedMaterilizeTids(List<TupleId> tids) {
        this.globalState.outerJoinedMaterializedTupleIds.addAll(tids);
    }

    public boolean isOuterMaterializedJoined(TupleId tid) {
        return this.globalState.outerJoinedMaterializedTupleIds.contains(tid);
    }

    public void changeAllOuterJoinTupleToNull() throws VecNotImplException {
        for (TupleId tid : this.globalState.outerJoinedTupleIds.keySet()) {
            for (SlotDescriptor slotDescriptor : this.getTupleDesc(tid).getSlots()) {
                this.changeSlotToNull(slotDescriptor);
            }
        }
        for (TupleId tid : this.globalState.outerJoinedMaterializedTupleIds) {
            for (SlotDescriptor slotDescriptor : this.getTupleDesc(tid).getSlots()) {
                this.changeSlotToNull(slotDescriptor);
            }
        }
    }

    private void changeSlotToNull(SlotDescriptor slotDescriptor) throws VecNotImplException {
        if (slotDescriptor.getSourceExprs().isEmpty()) {
            slotDescriptor.setIsNullable(true);
            return;
        }
        for (Expr sourceExpr : slotDescriptor.getSourceExprs()) {
            if (sourceExpr.isNullable()) continue;
            throw new VecNotImplException("The slot (" + slotDescriptor.toString() + ") could not be changed to nullable");
        }
    }

    private static class GlobalState {
        private final DescriptorTable descTbl = new DescriptorTable();
        private final Catalog catalog;
        private final IdGenerator<ExprId> conjunctIdGenerator = ExprId.createGenerator();
        private final ConnectContext context;
        public boolean isExplain;
        public boolean hasPlanHints = false;
        public boolean containsSubquery = false;
        private final Map<ExprId, Expr> conjuncts = Maps.newHashMap();
        public final ArrayList<ExprId> singleTidConjuncts = Lists.newArrayList();
        private final Map<TupleId, List<ExprId>> eqJoinConjuncts = Maps.newHashMap();
        private Set<ExprId> assignedConjuncts = Collections.newSetFromMap(new IdentityHashMap());
        private Set<TupleId> inlineViewTupleIds = Sets.newHashSet();
        private final Map<TupleId, TableRef> outerJoinedTupleIds = Maps.newHashMap();
        private final Set<TupleId> outerJoinedMaterializedTupleIds = Sets.newHashSet();
        public final Map<ExprId, TableRef> fullOuterJoinedConjuncts = Maps.newHashMap();
        public final Map<TupleId, TableRef> fullOuterJoinedTupleIds = Maps.newHashMap();
        public final Map<TupleId, TableRef> semiJoinedTupleIds = Maps.newHashMap();
        public final Map<TupleId, List<ExprId>> conjunctsByOjClause = Maps.newHashMap();
        private final Map<ExprId, TableRef> ojClauseByConjunct = Maps.newHashMap();
        public final Map<ExprId, TableRef> sjClauseByConjunct = Maps.newHashMap();
        public final Map<ExprId, TableRef> ijClauseByConjunct = Maps.newHashMap();
        public final Map<TupleId, Set<Expr>> constantConjunct = Maps.newHashMap();
        public final Map<Pair<TupleId, TupleId>, JoinOperator> anyTwoTalesJoinOperator = Maps.newHashMap();
        private final List<Expr> onSlotEqSlotExpr = new ArrayList<Expr>();
        private final Set<Pair<Expr, Expr>> onSlotEqSlotDeDuplication = Sets.newHashSet();
        private final List<Expr> onSlotToLiteralExpr = new ArrayList<Expr>();
        private final Set<Pair<Expr, Expr>> onSlotToLiteralDeDuplication = Sets.newHashSet();
        private final List<Expr> onInExpr = new ArrayList<Expr>();
        private final Set<Expr> onInDeDuplication = Sets.newHashSet();
        private final List<Expr> onIsNullExpr = new ArrayList<Expr>();
        private final Set<Expr> onIsNullDeDuplication = Sets.newHashSet();
        private final Set<Pair<Expr, Expr>> globalSlotToLiteralDeDuplication = Sets.newHashSet();
        private final Set<Expr> globalInDeDuplication = Sets.newHashSet();
        private final Map<SlotId, Analyzer> blockBySlot = Maps.newHashMap();
        private final ExprRewriter exprRewriter_;
        private final ExprRewriter mvExprRewriter;
        private final long autoBroadcastJoinThreshold;
        private final Map<SlotId, SlotId> equivalentSlots = Maps.newHashMap();

        public GlobalState(Catalog catalog, ConnectContext context) {
            this.catalog = catalog;
            this.context = context;
            ArrayList rules = Lists.newArrayList();
            rules.add(BetweenToCompoundRule.INSTANCE);
            rules.add(NormalizeBinaryPredicatesRule.INSTANCE);
            rules.add(RewriteBinaryPredicatesRule.INSTANCE);
            rules.add(FoldConstantsRule.INSTANCE);
            rules.add(RewriteFromUnixTimeRule.INSTANCE);
            rules.add(CompoundPredicateWriteRule.INSTANCE);
            rules.add(RewriteDateLiteralRule.INSTANCE);
            rules.add(RewriteEncryptKeyRule.INSTANCE);
            rules.add(RewriteAliasFunctionRule.INSTANCE);
            ArrayList onceRules = Lists.newArrayList();
            onceRules.add(ExtractCommonFactorsRule.INSTANCE);
            onceRules.add(InferFiltersRule.INSTANCE);
            this.exprRewriter_ = new ExprRewriter(rules, onceRules);
            ArrayList mvRewriteRules = Lists.newArrayList();
            mvRewriteRules.add(ToBitmapToSlotRefRule.INSTANCE);
            mvRewriteRules.add(CountDistinctToBitmapOrHLLRule.INSTANCE);
            mvRewriteRules.add(CountDistinctToBitmap.INSTANCE);
            mvRewriteRules.add(NDVToHll.INSTANCE);
            mvRewriteRules.add(HLLHashToSlotRefRule.INSTANCE);
            mvRewriteRules.add(CountFieldToSum.INSTANCE);
            this.mvExprRewriter = new ExprRewriter(mvRewriteRules);
            if (context != null) {
                long perNodeMemLimit = context.getSessionVariable().getMaxExecMemByte();
                double autoBroadcastJoinThresholdPercentage = context.getSessionVariable().autoBroadcastJoinThreshold;
                if (autoBroadcastJoinThresholdPercentage > 1.0) {
                    autoBroadcastJoinThresholdPercentage = 1.0;
                } else if (autoBroadcastJoinThresholdPercentage <= 0.0) {
                    autoBroadcastJoinThresholdPercentage = -1.0;
                }
                this.autoBroadcastJoinThreshold = (long)((double)perNodeMemLimit * autoBroadcastJoinThresholdPercentage);
            } else {
                this.autoBroadcastJoinThreshold = 0L;
            }
        }
    }
}

