/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.thrift.TAnalyticWindow;
import org.apache.doris.thrift.TAnalyticWindowBoundary;
import org.apache.doris.thrift.TAnalyticWindowBoundaryType;
import org.apache.doris.thrift.TAnalyticWindowType;

public class AnalyticWindow {
    public static final AnalyticWindow DEFAULT_WINDOW = new AnalyticWindow(Type.RANGE, new Boundary(BoundaryType.UNBOUNDED_PRECEDING, null), new Boundary(BoundaryType.CURRENT_ROW, null));
    private final Type type_;
    private final Boundary leftBoundary_;
    private Boundary rightBoundary_;
    private String toSqlString_;

    public Type getType() {
        return this.type_;
    }

    public Boundary getLeftBoundary() {
        return this.leftBoundary_;
    }

    public Boundary getRightBoundary() {
        return this.rightBoundary_;
    }

    public Boundary setRightBoundary(Boundary b) {
        this.rightBoundary_ = b;
        return this.rightBoundary_;
    }

    public AnalyticWindow(Type type, Boundary b) {
        this.type_ = type;
        Preconditions.checkNotNull((Object)b);
        this.leftBoundary_ = b;
        this.rightBoundary_ = null;
    }

    public AnalyticWindow(Type type, Boundary l, Boundary r) {
        this.type_ = type;
        Preconditions.checkNotNull((Object)l);
        this.leftBoundary_ = l;
        Preconditions.checkNotNull((Object)r);
        this.rightBoundary_ = r;
    }

    private AnalyticWindow(AnalyticWindow other) {
        this.type_ = other.type_;
        Preconditions.checkNotNull((Object)other.leftBoundary_);
        this.leftBoundary_ = other.leftBoundary_.clone();
        if (other.rightBoundary_ != null) {
            this.rightBoundary_ = other.rightBoundary_.clone();
        }
        this.toSqlString_ = other.toSqlString_;
    }

    public AnalyticWindow reverse() {
        Boundary newRightBoundary = this.leftBoundary_.converse();
        Boundary newLeftBoundary = null;
        newLeftBoundary = this.rightBoundary_ == null ? new Boundary(this.leftBoundary_.getType(), null) : this.rightBoundary_.converse();
        return new AnalyticWindow(this.type_, newLeftBoundary, newRightBoundary);
    }

    public String toSql() {
        if (this.toSqlString_ != null) {
            return this.toSqlString_;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.type_.toString()).append(" ");
        if (this.rightBoundary_ == null) {
            sb.append(this.leftBoundary_.toSql());
        } else {
            sb.append("BETWEEN ").append(this.leftBoundary_.toSql()).append(" AND ");
            sb.append(this.rightBoundary_.toSql());
        }
        return sb.toString();
    }

    public TAnalyticWindow toThrift() {
        TAnalyticWindow result = new TAnalyticWindow(this.type_.toThrift());
        if (this.leftBoundary_.getType() != BoundaryType.UNBOUNDED_PRECEDING) {
            result.setWindowStart(this.leftBoundary_.toThrift(this.type_));
        }
        Preconditions.checkNotNull((Object)this.rightBoundary_);
        if (this.rightBoundary_.getType() != BoundaryType.UNBOUNDED_FOLLOWING) {
            result.setWindowEnd(this.rightBoundary_.toThrift(this.type_));
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean rightBoundaryEqual;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AnalyticWindow o = (AnalyticWindow)obj;
        boolean bl = rightBoundaryEqual = this.rightBoundary_ == null == (o.rightBoundary_ == null);
        if (rightBoundaryEqual && this.rightBoundary_ != null) {
            rightBoundaryEqual = this.rightBoundary_.equals(o.rightBoundary_);
        }
        return this.type_ == o.type_ && this.leftBoundary_.equals(o.leftBoundary_) && rightBoundaryEqual;
    }

    public AnalyticWindow clone() {
        return new AnalyticWindow(this);
    }

    private void checkOffsetExpr(Analyzer analyzer, Boundary boundary) throws AnalysisException {
        Preconditions.checkState((boolean)boundary.getType().isOffset());
        Expr e = boundary.getExpr();
        Preconditions.checkNotNull((Object)e);
        boolean isPos = true;
        Double val = null;
        if (e.isConstant() && e.getType().isNumericType()) {
            try {
                val = Expr.getConstFromExpr(e);
                if (val <= 0.0) {
                    isPos = false;
                }
            }
            catch (AnalysisException exc) {
                throw new AnalysisException("Couldn't evaluate PRECEDING/FOLLOWING expression: " + exc.getMessage());
            }
        }
        if (this.type_ == Type.ROWS) {
            if (!(e.isConstant() && e.getType().isFixedPointType() && isPos)) {
                throw new AnalysisException("For ROWS window, the value of a PRECEDING/FOLLOWING offset must be a constant positive integer: " + boundary.toSql());
            }
            Preconditions.checkNotNull((Object)val);
            boundary.offsetValue = new BigDecimal(val.longValue());
        } else {
            if (!(e.isConstant() && e.getType().isNumericType() && isPos)) {
                throw new AnalysisException("For RANGE window, the value of a PRECEDING/FOLLOWING offset must be a constant positive number: " + boundary.toSql());
            }
            boundary.offsetValue = new BigDecimal(val);
        }
    }

    private void checkOffsetBoundaries(Analyzer analyzer, Boundary b1, Boundary b2) throws AnalysisException {
        Preconditions.checkState((boolean)b1.getType().isOffset());
        Preconditions.checkState((boolean)b2.getType().isOffset());
        Expr e1 = b1.getExpr();
        Preconditions.checkState((e1 != null && e1.isConstant() && e1.getType().isNumericType() ? 1 : 0) != 0);
        Expr e2 = b2.getExpr();
        Preconditions.checkState((e2 != null && e2.isConstant() && e2.getType().isNumericType() ? 1 : 0) != 0);
        try {
            double left = Expr.getConstFromExpr(e1);
            double right = Expr.getConstFromExpr(e2);
            if (left > right) {
                throw new AnalysisException("Offset boundaries are in the wrong order: " + this.toSql());
            }
        }
        catch (AnalysisException exc) {
            throw new AnalysisException("Couldn't evaluate PRECEDING/FOLLOWING expression: " + exc.getMessage());
        }
    }

    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.leftBoundary_.analyze(analyzer);
        if (this.rightBoundary_ != null) {
            this.rightBoundary_.analyze(analyzer);
        }
        if (this.leftBoundary_.getType() == BoundaryType.UNBOUNDED_FOLLOWING) {
            throw new AnalysisException(this.leftBoundary_.getType().toString() + " is only allowed for upper bound of BETWEEN");
        }
        if (this.rightBoundary_ != null && this.rightBoundary_.getType() == BoundaryType.UNBOUNDED_PRECEDING) {
            throw new AnalysisException(this.rightBoundary_.getType().toString() + " is only allowed for lower bound of BETWEEN");
        }
        if (this.type_ == Type.RANGE && (this.leftBoundary_.type.isOffset() || this.rightBoundary_ != null && this.rightBoundary_.type.isOffset() || this.leftBoundary_.type == BoundaryType.CURRENT_ROW && (this.rightBoundary_ == null || this.rightBoundary_.type == BoundaryType.CURRENT_ROW))) {
            throw new AnalysisException("RANGE is only supported with both the lower and upper bounds UNBOUNDED or one UNBOUNDED and the other CURRENT ROW.");
        }
        if (this.rightBoundary_ == null && this.leftBoundary_.getType() == BoundaryType.FOLLOWING) {
            throw new AnalysisException(this.leftBoundary_.getType().toString() + " requires a BETWEEN clause");
        }
        if (this.leftBoundary_.getType().isOffset()) {
            this.checkOffsetExpr(analyzer, this.leftBoundary_);
        }
        if (this.rightBoundary_ == null) {
            this.toSqlString_ = this.toSql();
            this.rightBoundary_ = new Boundary(BoundaryType.CURRENT_ROW, null);
            return;
        }
        if (this.rightBoundary_.getType().isOffset()) {
            this.checkOffsetExpr(analyzer, this.rightBoundary_);
        }
        if (this.leftBoundary_.getType() == BoundaryType.FOLLOWING) {
            if (this.rightBoundary_.getType() != BoundaryType.FOLLOWING && this.rightBoundary_.getType() != BoundaryType.UNBOUNDED_FOLLOWING) {
                throw new AnalysisException("A lower window bound of " + BoundaryType.FOLLOWING.toString() + " requires that the upper bound also be " + BoundaryType.FOLLOWING.toString());
            }
            if (this.rightBoundary_.getType() != BoundaryType.UNBOUNDED_FOLLOWING) {
                this.checkOffsetBoundaries(analyzer, this.leftBoundary_, this.rightBoundary_);
            }
        }
        if (this.rightBoundary_.getType() == BoundaryType.PRECEDING) {
            if (this.leftBoundary_.getType() != BoundaryType.PRECEDING && this.leftBoundary_.getType() != BoundaryType.UNBOUNDED_PRECEDING) {
                throw new AnalysisException("An upper window bound of " + BoundaryType.PRECEDING.toString() + " requires that the lower bound also be " + BoundaryType.PRECEDING.toString());
            }
            if (this.leftBoundary_.getType() != BoundaryType.UNBOUNDED_PRECEDING) {
                this.checkOffsetBoundaries(analyzer, this.rightBoundary_, this.leftBoundary_);
            }
        }
    }

    public static class Boundary {
        private final BoundaryType type;
        private final Expr expr;
        private BigDecimal offsetValue;

        public BoundaryType getType() {
            return this.type;
        }

        public Expr getExpr() {
            return this.expr;
        }

        public Boundary(BoundaryType type, Expr e) {
            this(type, e, null);
        }

        private Boundary(BoundaryType type, Expr e, BigDecimal offsetValue) {
            Preconditions.checkState((type.isOffset() && e != null || !type.isOffset() && e == null ? 1 : 0) != 0);
            this.type = type;
            this.expr = e;
            this.offsetValue = offsetValue;
        }

        public String toSql() {
            StringBuilder sb = new StringBuilder();
            if (this.expr != null) {
                sb.append(this.expr.toSql()).append(" ");
            }
            sb.append(this.type.toString());
            return sb.toString();
        }

        public TAnalyticWindowBoundary toThrift(Type windowType) {
            TAnalyticWindowBoundary result = new TAnalyticWindowBoundary(this.type.toThrift());
            if (this.type.isOffset() && windowType == Type.ROWS) {
                result.setRowsOffsetValue(this.offsetValue.longValue());
            }
            return result;
        }

        public boolean equals(Object obj) {
            boolean exprEqual;
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Boundary o = (Boundary)obj;
            boolean bl = exprEqual = this.expr == null == (o.expr == null);
            if (exprEqual && this.expr != null) {
                exprEqual = this.expr.equals(o.expr);
            }
            return this.type == o.type && exprEqual;
        }

        public Boundary converse() {
            Boundary result = new Boundary(this.type.converse(), this.expr != null ? this.expr.clone() : null);
            result.offsetValue = this.offsetValue;
            return result;
        }

        public Boundary clone() {
            return new Boundary(this.type, this.expr != null ? this.expr.clone() : null, this.offsetValue);
        }

        public void analyze(Analyzer analyzer) throws AnalysisException {
            if (this.expr != null) {
                this.expr.analyze(analyzer);
            }
        }
    }

    static enum BoundaryType {
        UNBOUNDED_PRECEDING("UNBOUNDED PRECEDING"),
        UNBOUNDED_FOLLOWING("UNBOUNDED FOLLOWING"),
        CURRENT_ROW("CURRENT ROW"),
        PRECEDING("PRECEDING"),
        FOLLOWING("FOLLOWING");

        private final String description;

        private BoundaryType(String d) {
            this.description = d;
        }

        public String toString() {
            return this.description;
        }

        public TAnalyticWindowBoundaryType toThrift() {
            Preconditions.checkState((!this.isAbsolutePos() ? 1 : 0) != 0);
            if (this == CURRENT_ROW) {
                return TAnalyticWindowBoundaryType.CURRENT_ROW;
            }
            if (this == PRECEDING) {
                return TAnalyticWindowBoundaryType.PRECEDING;
            }
            if (this == FOLLOWING) {
                return TAnalyticWindowBoundaryType.FOLLOWING;
            }
            return null;
        }

        public boolean isAbsolutePos() {
            return this == UNBOUNDED_PRECEDING || this == UNBOUNDED_FOLLOWING;
        }

        public boolean isOffset() {
            return this == PRECEDING || this == FOLLOWING;
        }

        public boolean isPreceding() {
            return this == UNBOUNDED_PRECEDING || this == PRECEDING;
        }

        public boolean isFollowing() {
            return this == UNBOUNDED_FOLLOWING || this == FOLLOWING;
        }

        public BoundaryType converse() {
            switch (this) {
                case UNBOUNDED_PRECEDING: {
                    return UNBOUNDED_FOLLOWING;
                }
                case UNBOUNDED_FOLLOWING: {
                    return UNBOUNDED_PRECEDING;
                }
                case PRECEDING: {
                    return FOLLOWING;
                }
                case FOLLOWING: {
                    return PRECEDING;
                }
            }
            return CURRENT_ROW;
        }
    }

    static enum Type {
        ROWS("ROWS"),
        RANGE("RANGE");

        private final String description_;

        private Type(String d) {
            this.description_ = d;
        }

        public String toString() {
            return this.description_;
        }

        public TAnalyticWindowType toThrift() {
            return this == ROWS ? TAnalyticWindowType.ROWS : TAnalyticWindowType.RANGE;
        }
    }
}

