/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.AnalyticWindow;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.DecimalLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.FunctionName;
import org.apache.doris.analysis.FunctionParams;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LargeIntLiteral;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.OrderByElement;
import org.apache.doris.catalog.AggregateFunction;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.TreeNode;
import org.apache.doris.common.util.VectorizedUtil;
import org.apache.doris.thrift.TExprNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticExpr
extends Expr {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticExpr.class);
    private FunctionCallExpr fnCall;
    private final List<Expr> partitionExprs;
    private List<OrderByElement> orderByElements = Lists.newArrayList();
    private AnalyticWindow window;
    private boolean resetWindow = false;
    private String sqlString;
    private static String LEAD = "LEAD";
    private static String LAG = "LAG";
    private static String FIRSTVALUE = "FIRST_VALUE";
    private static String LASTVALUE = "LAST_VALUE";
    private static String RANK = "RANK";
    private static String DENSERANK = "DENSE_RANK";
    private static String ROWNUMBER = "ROW_NUMBER";
    private static String MIN = "MIN";
    private static String MAX = "MAX";
    private static String SUM = "SUM";
    private static String COUNT = "COUNT";
    public static String FIRST_VALUE_REWRITE = "FIRST_VALUE_REWRITE";
    public static String HLL_UNION_AGG = "HLL_UNION_AGG";

    public AnalyticExpr(FunctionCallExpr fnCall, List<Expr> partitionExprs, List<OrderByElement> orderByElements, AnalyticWindow window) {
        Preconditions.checkNotNull((Object)fnCall);
        this.fnCall = fnCall;
        ArrayList arrayList = this.partitionExprs = partitionExprs != null ? partitionExprs : new ArrayList();
        if (orderByElements != null) {
            this.orderByElements.addAll(orderByElements);
        }
        this.window = window;
        this.setChildren();
    }

    protected AnalyticExpr(AnalyticExpr other) {
        super(other);
        this.fnCall = (FunctionCallExpr)other.fnCall.clone();
        for (OrderByElement e : other.orderByElements) {
            this.orderByElements.add(e.clone());
        }
        this.partitionExprs = Expr.cloneList(other.partitionExprs);
        this.window = other.window != null ? other.window.clone() : null;
        this.resetWindow = other.resetWindow;
        this.sqlString = other.sqlString;
        this.setChildren();
    }

    public FunctionCallExpr getFnCall() {
        return this.fnCall;
    }

    public List<Expr> getPartitionExprs() {
        return this.partitionExprs;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public AnalyticWindow getWindow() {
        return this.window;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        AnalyticExpr o = (AnalyticExpr)obj;
        if (!this.fnCall.equals(o.getFnCall())) {
            return false;
        }
        if (this.window == null != (o.window == null)) {
            return false;
        }
        if (this.window != null && !this.window.equals(o.window)) {
            return false;
        }
        return this.orderByElements.equals(o.orderByElements);
    }

    @Override
    protected boolean isConstantImpl() {
        return false;
    }

    @Override
    public Expr clone() {
        return new AnalyticExpr(this);
    }

    @Override
    public String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("fn", (Object)this.getFnCall()).add("window", (Object)this.window).addValue((Object)super.debugString()).toString();
    }

    @Override
    protected void toThrift(TExprNode msg) {
    }

    public static boolean isAnalyticFn(Function fn) {
        return fn instanceof AggregateFunction && ((AggregateFunction)fn).isAnalyticFn();
    }

    public static boolean isAggregateFn(Function fn) {
        return fn.functionName().equalsIgnoreCase(SUM) || fn.functionName().equalsIgnoreCase(MIN) || fn.functionName().equalsIgnoreCase(MAX) || fn.functionName().equalsIgnoreCase(COUNT);
    }

    private static boolean isOffsetFn(Function fn) {
        if (!AnalyticExpr.isAnalyticFn(fn)) {
            return false;
        }
        return fn.functionName().equalsIgnoreCase(LEAD) || fn.functionName().equalsIgnoreCase(LAG);
    }

    private static boolean isMinMax(Function fn) {
        if (!AnalyticExpr.isAnalyticFn(fn)) {
            return false;
        }
        return fn.functionName().equalsIgnoreCase(MIN) || fn.functionName().equalsIgnoreCase(MAX);
    }

    private static boolean isRankingFn(Function fn) {
        if (!AnalyticExpr.isAnalyticFn(fn)) {
            return false;
        }
        return fn.functionName().equalsIgnoreCase(RANK) || fn.functionName().equalsIgnoreCase(DENSERANK) || fn.functionName().equalsIgnoreCase(ROWNUMBER);
    }

    private static boolean isHllAggFn(Function fn) {
        if (!AnalyticExpr.isAnalyticFn(fn)) {
            return false;
        }
        return fn.functionName().equalsIgnoreCase(HLL_UNION_AGG);
    }

    public static Expr rewrite(AnalyticExpr analyticExpr) {
        Function fn = analyticExpr.getFnCall().getFn();
        return null;
    }

    private void checkRangeOffsetBoundaryExpr(AnalyticWindow.Boundary boundary) throws AnalysisException {
        Preconditions.checkState((boolean)boundary.getType().isOffset());
        if (this.orderByElements.size() > 1) {
            throw new AnalysisException("Only one ORDER BY expression allowed if used with a RANGE window with PRECEDING/FOLLOWING: " + this.toSql());
        }
        Expr rangeExpr = boundary.getExpr();
        if (!Type.isImplicitlyCastable(rangeExpr.getType(), this.orderByElements.get(0).getExpr().getType(), false)) {
            throw new AnalysisException("The value expression of a PRECEDING/FOLLOWING clause of a RANGE window must be implicitly convertible to the ORDER BY expression's type: " + rangeExpr.toSql() + " cannot be implicitly converted to " + this.orderByElements.get(0).getExpr().toSql());
        }
    }

    void checkDefaultValue(Analyzer analyzer) throws AnalysisException {
        Expr val = (Expr)this.getFnCall().getChild(2);
        if (!(val instanceof LiteralExpr)) {
            return;
        }
        if (!((Expr)this.getFnCall().getChild(0)).getType().getPrimitiveType().isNumericType()) {
            return;
        }
        double value = Expr.getConstFromExpr(val);
        PrimitiveType type = ((Expr)this.getFnCall().getChild(0)).getType().getPrimitiveType();
        boolean out = false;
        if (type == PrimitiveType.TINYINT) {
            if (value > 127.0) {
                out = true;
            }
        } else if (type == PrimitiveType.SMALLINT) {
            if (value > 32767.0) {
                out = true;
            }
        } else if (type == PrimitiveType.INT) {
            if (value > 2.147483647E9) {
                out = true;
            }
        } else if (type == PrimitiveType.BIGINT) {
            if (value > 9.223372036854776E18) {
                out = true;
            }
        } else if (type == PrimitiveType.FLOAT) {
            if (value > 3.4028234663852886E38) {
                out = true;
            }
        } else if (type == PrimitiveType.DOUBLE) {
            if (value > Double.MAX_VALUE) {
                out = true;
            }
        } else {
            return;
        }
        if (out) {
            throw new AnalysisException("Column type=" + ((Expr)this.getFnCall().getChildren().get(0)).getType() + ", value is out of range ");
        }
    }

    void checkOffset(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((boolean)AnalyticExpr.isOffsetFn(this.getFnCall().getFn()));
        Preconditions.checkState((this.getFnCall().getChildren().size() > 1 ? 1 : 0) != 0);
        Expr offset = (Expr)this.getFnCall().getChild(1);
        try {
            Preconditions.checkState((boolean)offset.getType().isFixedPointType());
        }
        catch (Exception e) {
            throw new AnalysisException("The offset parameter of LEAD/LAG must be a constant positive integer: " + this.getFnCall().toSql());
        }
        boolean isPosConstant = true;
        if (!offset.isConstant()) {
            isPosConstant = false;
        } else {
            double value = 0.0;
            if (offset instanceof IntLiteral) {
                IntLiteral intl = (IntLiteral)offset;
                value = intl.getDoubleValue();
            } else if (offset instanceof LargeIntLiteral) {
                LargeIntLiteral intl = (LargeIntLiteral)offset;
                value = intl.getDoubleValue();
            }
            if (value <= 0.0) {
                isPosConstant = false;
            }
        }
        if (!isPosConstant) {
            throw new AnalysisException("The offset parameter of LEAD/LAG must be a constant positive integer: " + this.getFnCall().toSql());
        }
    }

    @Override
    public void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        this.fnCall.analyze(analyzer);
        this.type = this.getFnCall().getType();
        for (Expr expr : this.partitionExprs) {
            if (!expr.isConstant()) continue;
            throw new AnalysisException("Expressions in the PARTITION BY clause must not be constant: " + expr.toSql() + " (in " + this.toSql() + ")");
        }
        for (OrderByElement orderByElement : this.orderByElements) {
            if (!orderByElement.getExpr().isConstant()) continue;
            throw new AnalysisException("Expressions in the ORDER BY clause must not be constant: " + orderByElement.getExpr().toSql() + " (in " + this.toSql() + ")");
        }
        if (this.getFnCall().getParams().isDistinct()) {
            throw new AnalysisException("DISTINCT not allowed in analytic function: " + this.getFnCall().toSql());
        }
        Function fn = this.getFnCall().getFn();
        if (!(fn instanceof AggregateFunction)) {
            throw new AnalysisException("OVER clause requires aggregate or analytic function: " + this.getFnCall().toSql());
        }
        if (!AnalyticExpr.isAnalyticFn(fn)) {
            throw new AnalysisException(String.format("Aggregate function '%s' not supported with OVER clause.", this.getFnCall().toSql()));
        }
        if (AnalyticExpr.isAnalyticFn(fn) && !AnalyticExpr.isAggregateFn(fn)) {
            if ((AnalyticExpr.isRankingFn(fn) || AnalyticExpr.isOffsetFn(fn) || AnalyticExpr.isHllAggFn(fn)) && this.window != null) {
                throw new AnalysisException("Windowing clause not allowed with '" + this.getFnCall().toSql() + "'");
            }
            if (AnalyticExpr.isOffsetFn(fn) && this.getFnCall().getChildren().size() > 1) {
                this.checkOffset(analyzer);
                if (this.getFnCall().getChildren().size() > 2 && !((Expr)this.getFnCall().getChild(2)).isConstant()) {
                    throw new AnalysisException("The default parameter (parameter 3) of LEAD/LAG must be a constant: " + this.getFnCall().toSql());
                }
            }
        }
        if (this.window != null) {
            if (this.orderByElements.isEmpty()) {
                throw new AnalysisException("Windowing clause requires ORDER BY clause: " + this.toSql());
            }
            this.window.analyze(analyzer);
            if (!this.orderByElements.isEmpty() && this.window.getType() == AnalyticWindow.Type.RANGE) {
                if (this.window.getLeftBoundary().getType().isOffset()) {
                    this.checkRangeOffsetBoundaryExpr(this.window.getLeftBoundary());
                }
                if (this.window.getRightBoundary() != null && this.window.getRightBoundary().getType().isOffset()) {
                    this.checkRangeOffsetBoundaryExpr(this.window.getRightBoundary());
                }
            }
        }
        if (TreeNode.contains(this.getChildren(), AnalyticExpr.class)) {
            throw new AnalysisException("Nesting of analytic expressions is not allowed: " + this.toSql());
        }
        this.sqlString = this.toSql();
        this.standardize(analyzer);
        if (!VectorizedUtil.isVectorized() && this.window != null && AnalyticExpr.isMinMax(fn) && this.window.getLeftBoundary().getType() != AnalyticWindow.BoundaryType.UNBOUNDED_PRECEDING) {
            throw new AnalysisException("'" + this.getFnCall().toSql() + "' is only supported with an UNBOUNDED PRECEDING start bound.");
        }
        this.setChildren();
    }

    private void standardize(Analyzer analyzer) throws AnalysisException {
        FunctionName analyticFnName = this.getFnCall().getFnName();
        if (analyticFnName.getFunction().equalsIgnoreCase(ROWNUMBER)) {
            Preconditions.checkState((this.window == null ? 1 : 0) != 0, (Object)"Unexpected window set for row_number()");
            this.window = new AnalyticWindow(AnalyticWindow.Type.ROWS, new AnalyticWindow.Boundary(AnalyticWindow.BoundaryType.UNBOUNDED_PRECEDING, null), new AnalyticWindow.Boundary(AnalyticWindow.BoundaryType.CURRENT_ROW, null));
            this.resetWindow = true;
            return;
        }
        if (AnalyticExpr.isOffsetFn(this.getFnCall().getFn())) {
            Preconditions.checkState((this.window == null ? 1 : 0) != 0);
            ArrayList newExprParams = null;
            if (this.getFnCall().getChildren().size() == 1) {
                newExprParams = Lists.newArrayListWithExpectedSize((int)3);
                newExprParams.addAll(this.getFnCall().getChildren());
                newExprParams.add(new IntLiteral("1", (Type)Type.BIGINT));
                newExprParams.add(new NullLiteral());
                throw new AnalysisException("Lag/offset must have three parameters");
            }
            if (this.getFnCall().getChildren().size() == 2) {
                newExprParams = Lists.newArrayListWithExpectedSize((int)3);
                newExprParams.addAll(this.getFnCall().getChildren());
                newExprParams.add(new NullLiteral());
                throw new AnalysisException("Lag/offset must have three parameters");
            }
            Preconditions.checkState((this.getFnCall().getChildren().size() == 3 ? 1 : 0) != 0);
            Type type = ((Expr)this.getFnCall().getChildren().get(2)).getType();
            try {
                this.getFnCall().uncheckedCastChild(((Expr)this.getFnCall().getChildren().get(0)).getType(), 2);
            }
            catch (Exception e) {
                LOG.warn("", (Throwable)e);
                throw new AnalysisException("Convert type error in offset fn(default value); old_type=" + ((Expr)this.getFnCall().getChildren().get(2)).getType() + " new_type=" + ((Expr)this.getFnCall().getChildren().get(0)).getType());
            }
            if (this.getFnCall().getChildren().get(2) instanceof CastExpr) {
                throw new AnalysisException("Type = " + type + " can't not convert to " + ((Expr)this.getFnCall().getChildren().get(0)).getType());
            }
            this.checkDefaultValue(analyzer);
            try {
                this.getFnCall().uncheckedCastChild(Type.BIGINT, 1);
            }
            catch (Exception e) {
                LOG.warn("", (Throwable)e);
                throw new AnalysisException("Convert type error in offset fn(default offset); type=" + ((Expr)this.getFnCall().getChildren().get(1)).getType());
            }
            AnalyticWindow.BoundaryType rightBoundaryType = AnalyticWindow.BoundaryType.FOLLOWING;
            if (analyticFnName.getFunction().equalsIgnoreCase(LAG)) {
                rightBoundaryType = AnalyticWindow.BoundaryType.PRECEDING;
            }
            this.window = new AnalyticWindow(AnalyticWindow.Type.ROWS, new AnalyticWindow.Boundary(AnalyticWindow.BoundaryType.UNBOUNDED_PRECEDING, null), new AnalyticWindow.Boundary(rightBoundaryType, this.getOffsetExpr(this.getFnCall())));
            try {
                this.window.analyze(analyzer);
            }
            catch (AnalysisException e) {
                throw new IllegalStateException(e);
            }
            this.resetWindow = true;
            return;
        }
        if (analyticFnName.getFunction().equalsIgnoreCase(FIRSTVALUE) && this.window != null && this.window.getLeftBoundary().getType() != AnalyticWindow.BoundaryType.UNBOUNDED_PRECEDING) {
            if (this.window.getLeftBoundary().getType() != AnalyticWindow.BoundaryType.PRECEDING) {
                this.window = new AnalyticWindow(this.window.getType(), this.window.getLeftBoundary(), this.window.getLeftBoundary());
                this.fnCall = new FunctionCallExpr(new FunctionName(LASTVALUE), this.getFnCall().getParams());
            } else if (!VectorizedUtil.isVectorized()) {
                ArrayList<Expr> paramExprs = Expr.cloneList(this.getFnCall().getParams().exprs());
                if (this.window.getRightBoundary().getType() == AnalyticWindow.BoundaryType.PRECEDING) {
                    paramExprs.add(this.window.getRightBoundary().getExpr());
                } else {
                    paramExprs.add(new IntLiteral(-1L, (Type)Type.BIGINT));
                }
                this.window = new AnalyticWindow(this.window.getType(), new AnalyticWindow.Boundary(AnalyticWindow.BoundaryType.UNBOUNDED_PRECEDING, null), this.window.getLeftBoundary());
                this.fnCall = new FunctionCallExpr("FIRST_VALUE_REWRITE", new FunctionParams(paramExprs));
            }
            this.fnCall.setIsAnalyticFnCall(true);
            this.fnCall.analyzeNoThrow(analyzer);
            analyticFnName = this.getFnCall().getFnName();
        }
        if (this.window != null && this.window.getRightBoundary().getType() == AnalyticWindow.BoundaryType.UNBOUNDED_FOLLOWING && this.window.getLeftBoundary().getType() != AnalyticWindow.BoundaryType.UNBOUNDED_PRECEDING) {
            this.orderByElements = OrderByElement.reverse(this.orderByElements);
            this.window = this.window.reverse();
            FunctionName reversedFnName = null;
            if (analyticFnName.getFunction().equalsIgnoreCase(FIRSTVALUE)) {
                reversedFnName = new FunctionName(LASTVALUE);
            } else if (analyticFnName.getFunction().equalsIgnoreCase(LASTVALUE)) {
                reversedFnName = new FunctionName(FIRSTVALUE);
            }
            if (reversedFnName != null) {
                this.fnCall = new FunctionCallExpr(reversedFnName, this.getFnCall().getParams());
                this.fnCall.setIsAnalyticFnCall(true);
                this.fnCall.analyzeNoThrow(analyzer);
            }
            analyticFnName = this.getFnCall().getFnName();
        }
        if (this.window != null && this.window.getLeftBoundary().getType() == AnalyticWindow.BoundaryType.UNBOUNDED_PRECEDING && this.window.getRightBoundary().getType() != AnalyticWindow.BoundaryType.PRECEDING && analyticFnName.getFunction().equalsIgnoreCase(FIRSTVALUE)) {
            this.window.setRightBoundary(new AnalyticWindow.Boundary(AnalyticWindow.BoundaryType.CURRENT_ROW, null));
        }
        if (!this.orderByElements.isEmpty() && this.window == null) {
            this.window = AnalyticWindow.DEFAULT_WINDOW;
            this.resetWindow = true;
        }
        if (analyticFnName.getFunction().equalsIgnoreCase(FIRSTVALUE) && this.window != null && this.window.getType() == AnalyticWindow.Type.RANGE) {
            this.window = new AnalyticWindow(AnalyticWindow.Type.ROWS, this.window.getLeftBoundary(), this.window.getRightBoundary());
        }
    }

    private Expr getOffsetExpr(FunctionCallExpr offsetFnCall) {
        Preconditions.checkState((boolean)AnalyticExpr.isOffsetFn(this.getFnCall().getFn()));
        if (offsetFnCall.getChild(1) != null) {
            return (Expr)offsetFnCall.getChild(1);
        }
        return new DecimalLiteral(BigDecimal.valueOf(1L));
    }

    private void syncWithChildren() {
        int i;
        int numArgs = this.fnCall.getChildren().size();
        for (int i2 = 0; i2 < numArgs; ++i2) {
            this.fnCall.setChild(i2, (Expr)this.getChild(i2));
        }
        int numPartitionExprs = this.partitionExprs.size();
        for (i = 0; i < numPartitionExprs; ++i) {
            this.partitionExprs.set(i, (Expr)this.getChild(numArgs + i));
        }
        for (i = 0; i < this.orderByElements.size(); ++i) {
            this.orderByElements.get(i).setExpr((Expr)this.getChild(numArgs + numPartitionExprs + i));
        }
    }

    private void setChildren() {
        this.getChildren().clear();
        this.addChildren(this.fnCall.getChildren());
        this.addChildren(this.partitionExprs);
        for (OrderByElement e : this.orderByElements) {
            this.addChild(e.getExpr());
        }
        if (this.window != null) {
            if (this.window.getLeftBoundary().getExpr() != null) {
                this.addChild(this.window.getLeftBoundary().getExpr());
            }
            if (this.window.getRightBoundary() != null && this.window.getRightBoundary().getExpr() != null) {
                this.addChild(this.window.getRightBoundary().getExpr());
            }
        }
    }

    @Override
    protected void resetAnalysisState() {
        super.resetAnalysisState();
        this.fnCall.resetAnalysisState();
        if (this.resetWindow) {
            this.window = null;
        }
        this.resetWindow = false;
        this.syncWithChildren();
    }

    @Override
    protected Expr substituteImpl(ExprSubstitutionMap sMap, Analyzer analyzer) throws AnalysisException {
        Expr e = super.substituteImpl(sMap, analyzer);
        if (!(e instanceof AnalyticExpr)) {
            return e;
        }
        ((AnalyticExpr)e).syncWithChildren();
        return e;
    }

    @Override
    public String toSqlImpl() {
        if (this.sqlString != null) {
            return this.sqlString;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.fnCall.toSql()).append(" OVER (");
        boolean needsSpace = false;
        if (!this.partitionExprs.isEmpty()) {
            sb.append("PARTITION BY ").append(this.exprListToSql(this.partitionExprs));
            needsSpace = true;
        }
        if (!this.orderByElements.isEmpty()) {
            ArrayList orderByStrings = Lists.newArrayList();
            for (OrderByElement e : this.orderByElements) {
                orderByStrings.add(e.toSql());
            }
            if (needsSpace) {
                sb.append(" ");
            }
            sb.append("ORDER BY ").append(Joiner.on((String)", ").join((Iterable)orderByStrings));
            needsSpace = true;
        }
        if (this.window != null) {
            if (needsSpace) {
                sb.append(" ");
            }
            sb.append(this.window.toSql());
        }
        sb.append(")");
        return sb.toString();
    }

    private String exprListToSql(List<? extends Expr> exprs) {
        if (exprs == null || exprs.isEmpty()) {
            return "";
        }
        ArrayList strings = Lists.newArrayList();
        for (Expr expr : exprs) {
            strings.add(expr.toSql());
        }
        return Joiner.on((String)", ").join((Iterable)strings);
    }
}

