/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BaseViewStmt;
import org.apache.doris.analysis.ColWithComment;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.View;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class AlterViewStmt
extends BaseViewStmt {
    public AlterViewStmt(TableName tbl, List<ColWithComment> cols, QueryStmt queryStmt) {
        super(tbl, cols, queryStmt);
    }

    public TableName getTbl() {
        return this.tableName;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (this.tableName == null) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_TABLES_USED, new Object[0]);
        }
        this.tableName.analyze(analyzer);
        Table table = analyzer.getTableOrAnalysisException(this.tableName);
        if (!(table instanceof View)) {
            throw new AnalysisException(String.format("ALTER VIEW not allowed on a table:%s.%s", this.getDbName(), this.getTable()));
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.tableName.getDb(), this.tableName.getTbl(), PrivPredicate.ALTER)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "ALTER VIEW", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), this.tableName.getDb() + ": " + this.tableName.getTbl());
        }
        if (this.cols != null) {
            this.cloneStmt = this.viewDefStmt.clone();
        }
        this.viewDefStmt.setNeedToSql(true);
        Analyzer viewAnalyzer = new Analyzer(analyzer);
        this.viewDefStmt.analyze(viewAnalyzer);
        this.createColumnAndViewDefs(analyzer);
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER VIEW ");
        sb.append(this.tableName.toSql()).append("\n");
        if (this.cols != null) {
            sb.append("(\n");
            for (int i = 0; i < this.cols.size(); ++i) {
                if (i != 0) {
                    sb.append(",\n");
                }
                sb.append("  ").append(((ColWithComment)this.cols.get(i)).getColName());
            }
            sb.append("\n)");
        }
        sb.append("\n");
        sb.append("AS ").append(this.viewDefStmt.toSql()).append("\n");
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

