/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterClause;
import org.apache.doris.analysis.AlterUserType;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.common.AnalysisException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlterUserClause
extends AlterClause {
    private static final Logger LOG = LogManager.getLogger(AlterUserClause.class);
    private List<String> hostOrIps;
    private List<String> ips;
    private List<String> starIps;
    private List<String> hosts;
    private AlterUserType type;

    public AlterUserClause(AlterUserType type, List<String> hostOrIps) {
        super(AlterOpType.ALTER_OTHER);
        this.type = type;
        this.hostOrIps = hostOrIps;
        this.ips = Lists.newArrayList();
        this.starIps = Lists.newArrayList();
        this.hosts = Lists.newArrayList();
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.type);
        for (int i = 0; i < this.hostOrIps.size(); ++i) {
            sb.append("\"").append(this.hostOrIps.get(i)).append("\"");
            if (i == this.hostOrIps.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private boolean isHostName(String host) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)host)) {
            throw new AnalysisException("host=[" + host + "] is empty");
        }
        for (char ch : host.toCharArray()) {
            if (!Character.isLetter(ch)) continue;
            return true;
        }
        String[] ipArray = host.split("\\.");
        if (ipArray.length != 4) {
            String msg = "ip wrong, ip=" + host;
            LOG.warn("{}", (Object)msg);
            throw new AnalysisException(msg);
        }
        return false;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        HashSet sets = Sets.newHashSet(this.hostOrIps);
        for (String host : sets) {
            if (this.isHostName(host)) {
                this.hosts.add(host);
                continue;
            }
            if (host.contains("*")) {
                this.starIps.add(host);
                continue;
            }
            this.ips.add(host);
        }
    }

    public List<String> getIps() {
        return this.ips;
    }

    public List<String> getStarIps() {
        return this.starIps;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public AlterUserType getAlterUserType() {
        return this.type;
    }

    @Override
    public Map<String, String> getProperties() {
        throw new NotImplementedException();
    }
}

