/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.AddColumnClause;
import org.apache.doris.analysis.AddColumnsClause;
import org.apache.doris.analysis.AddRollupClause;
import org.apache.doris.analysis.AlterClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ColumnDef;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.DropColumnClause;
import org.apache.doris.analysis.DropRollupClause;
import org.apache.doris.analysis.EnableFeatureClause;
import org.apache.doris.analysis.ModifyColumnClause;
import org.apache.doris.analysis.ModifyEngineClause;
import org.apache.doris.analysis.ReorderColumnsClause;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TableRenameClause;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.PropertyAnalyzer;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class AlterTableStmt
extends DdlStmt {
    private TableName tbl;
    private List<AlterClause> ops;

    public AlterTableStmt(TableName tbl, List<AlterClause> ops) {
        this.tbl = tbl;
        this.ops = ops;
    }

    public void setTableName(String newTableName) {
        this.tbl = new TableName(this.tbl.getDb(), newTableName);
    }

    public TableName getTbl() {
        return this.tbl;
    }

    public List<AlterClause> getOps() {
        return this.ops;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (this.tbl == null) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_TABLES_USED, new Object[0]);
        }
        this.tbl.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.tbl.getDb(), this.tbl.getTbl(), PrivPredicate.ALTER)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "ALTER TABLE", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), this.tbl.getDb() + ": " + this.tbl.getTbl());
        }
        if (this.ops == null || this.ops.isEmpty()) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_ALTER_OPERATION, new Object[0]);
        }
        for (AlterClause op : this.ops) {
            op.analyze(analyzer);
        }
    }

    public void rewriteAlterClause(OlapTable table) throws UserException {
        ArrayList<AlterClause> clauses = new ArrayList<AlterClause>();
        for (AlterClause alterClause : this.ops) {
            if (alterClause instanceof EnableFeatureClause) {
                EnableFeatureClause.Features alterFeature = ((EnableFeatureClause)alterClause).getFeature();
                if (alterFeature == null || alterFeature == EnableFeatureClause.Features.UNKNOWN) {
                    throw new AnalysisException("unknown feature for alter clause");
                }
                if (table.getKeysType() != KeysType.UNIQUE_KEYS && alterFeature == EnableFeatureClause.Features.BATCH_DELETE) {
                    throw new AnalysisException("Batch delete only supported in unique tables.");
                }
                if (table.getKeysType() != KeysType.UNIQUE_KEYS && alterFeature == EnableFeatureClause.Features.SEQUENCE_LOAD) {
                    throw new AnalysisException("Sequence load only supported in unique tables.");
                }
                Type sequenceColType = null;
                if (alterFeature == EnableFeatureClause.Features.SEQUENCE_LOAD) {
                    Map<String, String> propertyMap = alterClause.getProperties();
                    try {
                        sequenceColType = PropertyAnalyzer.analyzeSequenceType(propertyMap, table.getKeysType());
                        if (sequenceColType == null) {
                            throw new AnalysisException("unknown sequence column type");
                        }
                    }
                    catch (Exception e) {
                        throw new AnalysisException(e.getMessage());
                    }
                }
                if (table.getVisibleIndex().size() > 1) {
                    for (MaterializedIndex idx : table.getVisibleIndex()) {
                        if (idx.getId() == table.getBaseIndexId()) continue;
                        AddColumnClause addColumnClause = null;
                        if (alterFeature == EnableFeatureClause.Features.BATCH_DELETE) {
                            addColumnClause = new AddColumnClause(ColumnDef.newDeleteSignColumnDef(), null, table.getIndexNameById(idx.getId()), null);
                        } else if (alterFeature == EnableFeatureClause.Features.SEQUENCE_LOAD) {
                            addColumnClause = new AddColumnClause(ColumnDef.newSequenceColumnDef(sequenceColType), null, table.getIndexNameById(idx.getId()), null);
                        } else {
                            throw new AnalysisException("unknown feature : " + (Object)((Object)alterFeature));
                        }
                        addColumnClause.analyze(this.analyzer);
                        clauses.add(addColumnClause);
                    }
                    continue;
                }
                AddColumnClause addColumnClause = null;
                if (alterFeature == EnableFeatureClause.Features.BATCH_DELETE) {
                    addColumnClause = new AddColumnClause(ColumnDef.newDeleteSignColumnDef(), null, null, null);
                } else if (alterFeature == EnableFeatureClause.Features.SEQUENCE_LOAD) {
                    addColumnClause = new AddColumnClause(ColumnDef.newSequenceColumnDef(sequenceColType), null, null, null);
                }
                addColumnClause.analyze(this.analyzer);
                clauses.add(addColumnClause);
                continue;
            }
            clauses.add(alterClause);
        }
        this.ops = clauses;
    }

    public void checkExternalTableOperationAllow(Table table) throws UserException {
        ArrayList<AlterClause> clauses = new ArrayList<AlterClause>();
        for (AlterClause alterClause : this.ops) {
            if (alterClause instanceof TableRenameClause || alterClause instanceof AddColumnClause || alterClause instanceof AddColumnsClause || alterClause instanceof DropColumnClause || alterClause instanceof ModifyColumnClause || alterClause instanceof ReorderColumnsClause || alterClause instanceof ModifyEngineClause) {
                clauses.add(alterClause);
                continue;
            }
            throw new AnalysisException(table.getType().toString() + " [" + table.getName() + "] do not support " + alterClause.getOpType().toString() + " clause now");
        }
        this.ops = clauses;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ").append(this.tbl.toSql()).append(" ");
        int idx = 0;
        for (AlterClause op : this.ops) {
            if (idx != 0) {
                sb.append(", \n");
            }
            if (op instanceof AddRollupClause) {
                if (idx == 0) {
                    sb.append("ADD ROLLUP");
                }
                sb.append(op.toSql().replace("ADD ROLLUP", ""));
            } else if (op instanceof DropRollupClause) {
                if (idx == 0) {
                    sb.append("DROP ROLLUP ");
                }
                sb.append(((AddRollupClause)op).getRollupName());
            } else {
                sb.append(op.toSql());
            }
            ++idx;
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

