/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import org.apache.doris.analysis.AddBackendClause;
import org.apache.doris.analysis.AddFollowerClause;
import org.apache.doris.analysis.AddObserverClause;
import org.apache.doris.analysis.AlterClause;
import org.apache.doris.analysis.AlterLoadErrorUrlClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.DecommissionBackendClause;
import org.apache.doris.analysis.DropBackendClause;
import org.apache.doris.analysis.DropFollowerClause;
import org.apache.doris.analysis.DropObserverClause;
import org.apache.doris.analysis.ModifyBackendClause;
import org.apache.doris.analysis.ModifyBrokerClause;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class AlterSystemStmt
extends DdlStmt {
    private AlterClause alterClause;

    public AlterSystemStmt(AlterClause alterClause) {
        this.alterClause = alterClause;
    }

    public AlterClause getAlterClause() {
        return this.alterClause;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.OPERATOR)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "NODE");
        }
        Preconditions.checkState((this.alterClause instanceof AddBackendClause || this.alterClause instanceof DropBackendClause || this.alterClause instanceof DecommissionBackendClause || this.alterClause instanceof AddObserverClause || this.alterClause instanceof DropObserverClause || this.alterClause instanceof AddFollowerClause || this.alterClause instanceof DropFollowerClause || this.alterClause instanceof ModifyBrokerClause || this.alterClause instanceof AlterLoadErrorUrlClause || this.alterClause instanceof ModifyBackendClause ? 1 : 0) != 0);
        this.alterClause.analyze(analyzer);
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER SYSTEM ").append(this.alterClause.toSql());
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

