/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.CreateSqlBlockRuleStmt;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.common.util.SqlBlockUtil;
import org.apache.doris.common.util.Util;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class AlterSqlBlockRuleStmt
extends DdlStmt {
    public static final Long LONG_NOT_SET = SqlBlockUtil.LONG_MINUS_ONE;
    private final String ruleName;
    private String sql;
    private String sqlHash;
    private Long partitionNum;
    private Long tabletNum;
    private Long cardinality;
    private Boolean global;
    private Boolean enable;
    private final Map<String, String> properties;

    public AlterSqlBlockRuleStmt(String ruleName, Map<String, String> properties) {
        this.ruleName = ruleName;
        this.properties = properties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
        CreateSqlBlockRuleStmt.checkCommonProperties(this.properties);
        this.setProperties(this.properties);
    }

    private void setProperties(Map<String, String> properties) throws AnalysisException {
        this.sql = properties.getOrDefault("sql", "NULL");
        this.sqlHash = properties.getOrDefault("sqlHash", "NULL");
        String partitionNumString = properties.get("partition_num");
        String tabletNumString = properties.get("tablet_num");
        String cardinalityString = properties.get("cardinality");
        SqlBlockUtil.checkSqlAndSqlHashSetBoth(this.sql, this.sqlHash);
        SqlBlockUtil.checkSqlAndLimitationsSetBoth(this.sql, this.sqlHash, partitionNumString, tabletNumString, cardinalityString);
        this.partitionNum = Util.getLongPropertyOrDefault(partitionNumString, LONG_NOT_SET, null, "partition_num should be a long");
        this.tabletNum = Util.getLongPropertyOrDefault(tabletNumString, LONG_NOT_SET, null, "tablet_num should be a long");
        this.cardinality = Util.getLongPropertyOrDefault(cardinalityString, LONG_NOT_SET, null, "cardinality should be a long");
        String globalStr = properties.get("global");
        this.global = StringUtils.isNotEmpty((CharSequence)globalStr) ? Boolean.valueOf(Boolean.parseBoolean(globalStr)) : null;
        String enableStr = properties.get("enable");
        this.enable = StringUtils.isNotEmpty((CharSequence)enableStr) ? Boolean.valueOf(Boolean.parseBoolean(enableStr)) : null;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public String getSql() {
        return this.sql;
    }

    public Long getPartitionNum() {
        return this.partitionNum;
    }

    public Long getTabletNum() {
        return this.tabletNum;
    }

    public Long getCardinality() {
        return this.cardinality;
    }

    public Boolean getGlobal() {
        return this.global;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public String getSqlHash() {
        return this.sqlHash;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER SQL_BLOCK_RULE ").append(this.ruleName).append(" \nPROPERTIES(\n").append(new PrintableMap<String, String>(this.properties, " = ", true, true, true)).append(")");
        return sb.toString();
    }
}

