/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.CreateRoutineLoadStmt;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.LabelName;
import org.apache.doris.analysis.RoutineLoadDataSourceProperties;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.common.util.Util;
import org.apache.doris.load.routineload.RoutineLoadJob;

public class AlterRoutineLoadStmt
extends DdlStmt {
    private static final String NAME_TYPE = "ROUTINE LOAD NAME";
    private static final ImmutableSet<String> CONFIGURABLE_JOB_PROPERTIES_SET = new ImmutableSet.Builder().add((Object)"desired_concurrent_number").add((Object)"max_error_number").add((Object)"max_batch_interval").add((Object)"max_batch_rows").add((Object)"max_batch_size").add((Object)"jsonpaths").add((Object)"json_root").add((Object)"strip_outer_array").add((Object)"num_as_string").add((Object)"fuzzy_parse").add((Object)"strict_mode").add((Object)"timezone").build();
    private final LabelName labelName;
    private final Map<String, String> jobProperties;
    private final RoutineLoadDataSourceProperties dataSourceProperties;
    private Map<String, String> analyzedJobProperties = Maps.newHashMap();

    public AlterRoutineLoadStmt(LabelName labelName, Map<String, String> jobProperties, RoutineLoadDataSourceProperties dataSourceProperties) {
        this.labelName = labelName;
        this.jobProperties = jobProperties != null ? jobProperties : Maps.newHashMap();
        this.dataSourceProperties = dataSourceProperties;
    }

    public String getDbName() {
        return this.labelName.getDbName();
    }

    public String getLabel() {
        return this.labelName.getLabelName();
    }

    public Map<String, String> getAnalyzedJobProperties() {
        return this.analyzedJobProperties;
    }

    public boolean hasDataSourceProperty() {
        return this.dataSourceProperties.hasAnalyzedProperties();
    }

    public RoutineLoadDataSourceProperties getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        this.labelName.analyze(analyzer);
        FeNameFormat.checkCommonName(NAME_TYPE, this.labelName.getLabelName());
        this.checkJobProperties();
        this.checkDataSourceProperties();
        if (this.analyzedJobProperties.isEmpty() && !this.dataSourceProperties.hasAnalyzedProperties()) {
            throw new AnalysisException("No properties are specified");
        }
    }

    private void checkJobProperties() throws UserException {
        Optional<String> optional = this.jobProperties.keySet().stream().filter(entity -> !CONFIGURABLE_JOB_PROPERTIES_SET.contains(entity)).findFirst();
        if (optional.isPresent()) {
            throw new AnalysisException(optional.get() + " is invalid property");
        }
        if (this.jobProperties.containsKey("desired_concurrent_number")) {
            long desiredConcurrentNum = Long.valueOf(Util.getLongPropertyOrDefault(this.jobProperties.get("desired_concurrent_number"), -1L, CreateRoutineLoadStmt.DESIRED_CONCURRENT_NUMBER_PRED, "desired_concurrent_number should > 0")).intValue();
            this.analyzedJobProperties.put("desired_concurrent_number", String.valueOf(desiredConcurrentNum));
        }
        if (this.jobProperties.containsKey("max_error_number")) {
            long maxErrorNum = Util.getLongPropertyOrDefault(this.jobProperties.get("max_error_number"), -1L, CreateRoutineLoadStmt.MAX_ERROR_NUMBER_PRED, "max_error_number should >= 0");
            this.analyzedJobProperties.put("max_error_number", String.valueOf(maxErrorNum));
        }
        if (this.jobProperties.containsKey("max_batch_interval")) {
            long maxBatchIntervalS = Util.getLongPropertyOrDefault(this.jobProperties.get("max_batch_interval"), -1L, CreateRoutineLoadStmt.MAX_BATCH_INTERVAL_PRED, "max_batch_interval should between 5 and 60");
            this.analyzedJobProperties.put("max_batch_interval", String.valueOf(maxBatchIntervalS));
        }
        if (this.jobProperties.containsKey("max_batch_rows")) {
            long maxBatchRows = Util.getLongPropertyOrDefault(this.jobProperties.get("max_batch_rows"), -1L, CreateRoutineLoadStmt.MAX_BATCH_ROWS_PRED, "max_batch_rows should > 200000");
            this.analyzedJobProperties.put("max_batch_rows", String.valueOf(maxBatchRows));
        }
        if (this.jobProperties.containsKey("max_batch_size")) {
            long maxBatchSizeBytes = Util.getLongPropertyOrDefault(this.jobProperties.get("max_batch_size"), -1L, CreateRoutineLoadStmt.MAX_BATCH_SIZE_PRED, "max_batch_size should between 100MB and 1GB");
            this.analyzedJobProperties.put("max_batch_size", String.valueOf(maxBatchSizeBytes));
        }
        if (this.jobProperties.containsKey("strict_mode")) {
            boolean strictMode = Boolean.valueOf(this.jobProperties.get("strict_mode"));
            this.analyzedJobProperties.put("strict_mode", String.valueOf(strictMode));
        }
        if (this.jobProperties.containsKey("timezone")) {
            String timezone = TimeUtils.checkTimeZoneValidAndStandardize(this.jobProperties.get("timezone"));
            this.analyzedJobProperties.put("timezone", timezone);
        }
        if (this.jobProperties.containsKey("jsonpaths")) {
            this.analyzedJobProperties.put("jsonpaths", this.jobProperties.get("jsonpaths"));
        }
        if (this.jobProperties.containsKey("json_root")) {
            this.analyzedJobProperties.put("json_root", this.jobProperties.get("json_root"));
        }
        if (this.jobProperties.containsKey("strip_outer_array")) {
            boolean stripOuterArray = Boolean.valueOf(this.jobProperties.get("strip_outer_array"));
            this.analyzedJobProperties.put("strip_outer_array", String.valueOf(stripOuterArray));
        }
        if (this.jobProperties.containsKey("num_as_string")) {
            boolean numAsString = Boolean.valueOf(this.jobProperties.get("num_as_string"));
            this.analyzedJobProperties.put("num_as_string", String.valueOf(numAsString));
        }
        if (this.jobProperties.containsKey("fuzzy_parse")) {
            boolean fuzzyParse = Boolean.valueOf(this.jobProperties.get("fuzzy_parse"));
            this.analyzedJobProperties.put("fuzzy_parse", String.valueOf(fuzzyParse));
        }
    }

    private void checkDataSourceProperties() throws UserException {
        if (!FeConstants.runningUnitTest) {
            RoutineLoadJob job = Catalog.getCurrentCatalog().getRoutineLoadManager().checkPrivAndGetJob(this.getDbName(), this.getLabel());
            this.dataSourceProperties.setTimezone(job.getTimezone());
        } else {
            this.dataSourceProperties.setTimezone("Asia/Shanghai");
        }
        this.dataSourceProperties.analyze();
    }
}

