/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.load.LoadErrorHub;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlterLoadErrorUrlClause
extends AlterClause {
    private static final Logger LOG = LogManager.getLogger(AlterLoadErrorUrlClause.class);
    private Map<String, String> properties;
    private LoadErrorHub.Param param;

    public AlterLoadErrorUrlClause(Map<String, String> properties) {
        super(AlterOpType.ALTER_OTHER);
        this.properties = properties;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.properties == null || this.properties.isEmpty()) {
            throw new AnalysisException("Load errors hub's properties are missing");
        }
        String type = this.properties.get("type");
        if (Strings.isNullOrEmpty((String)type)) {
            throw new AnalysisException("Load errors hub's type is missing");
        }
        if (!type.equalsIgnoreCase("MYSQL") && !type.equalsIgnoreCase("BROKER")) {
            throw new AnalysisException("Load errors hub's type should be MYSQL or BROKER");
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER SYSTEM SET LOAD ERRORS HUB PROPERTIES(");
        PrintableMap<String, String> printableMap = new PrintableMap<String, String>(this.properties, "=", true, true, true);
        sb.append(printableMap.toString());
        sb.append(")");
        return sb.toString();
    }
}

